/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.project;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.emf.workbench.WorkbenchByteArrayOutputStream;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jem.util.plugin.JEMUtilPlugin;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EJBJarFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifestImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.impl.CommonarchiveFactoryImpl;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.internal.archive.operations.JavaComponentLoadStrategyImpl;
import org.eclipse.jst.j2ee.internal.moduleextension.EarModuleManager;
import org.eclipse.jst.j2ee.project.facet.JavaProjectMigrationDataModelProvider;
import org.eclipse.jst.j2ee.project.facet.JavaProjectMigrationOperation;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.impl.ModuleURIUtil;
import org.eclipse.wst.common.componentcore.internal.util.ComponentUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;

public class J2EEProjectUtilities
extends ProjectUtilities {
    public static final String ENTERPRISE_APPLICATION = "jst.ear";
    public static final String APPLICATION_CLIENT = "jst.appclient";
    public static final String EJB = "jst.ejb";
    public static final String DYNAMIC_WEB = "jst.web";
    public static final String UTILITY = "jst.utility";
    public static final String JCA = "jst.connector";
    public static final String STATIC_WEB = "wst.web";

    public static IPath getRuntimeLocation(IProject aProject) {
        if (JemProjectUtilities.isBinaryProject((IProject)aProject)) {
            return J2EEProjectUtilities.getBinaryProjectJARLocation(aProject);
        }
        return JemProjectUtilities.getJavaProjectOutputAbsoluteLocation((IProject)aProject);
    }

    public static IPath getBinaryProjectJARLocation(IProject aProject) {
        List sources = JemProjectUtilities.getLocalJARPathsFromClasspath((IProject)aProject);
        if (!sources.isEmpty()) {
            IPath path = (IPath)sources.get(0);
            return aProject.getFile(path).getLocation();
        }
        return null;
    }

    public static Archive getClientJAR(EJBJarFile file, EARFile earFile) {
        EJBJar jar = file.getDeploymentDescriptor();
        if (jar == null) {
            return null;
        }
        String clientJAR = jar.getEjbClientJar();
        if (clientJAR == null || clientJAR.length() == 0) {
            return null;
        }
        String normalized = ArchiveUtil.deriveEARRelativeURI((String)clientJAR, (String)file.getURI());
        if (normalized != null) {
            try {
                File aFile = earFile.getFile(normalized);
                if (aFile.isArchive() && !aFile.isModuleFile()) {
                    return (Archive)aFile;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void appendJavaClassPath(IProject p, IClasspathEntry newEntry) throws JavaModelException {
        IJavaProject javaProject = JemProjectUtilities.getJavaProject((IProject)p);
        if (javaProject == null) {
            return;
        }
        IClasspathEntry[] classpath = javaProject.getRawClasspath();
        ArrayList<IClasspathEntry> newPathList = new ArrayList<IClasspathEntry>(classpath.length);
        int i = 0;
        while (i < classpath.length) {
            IClasspathEntry entry = classpath[i];
            if (Platform.getOS().equals("win32")) {
                if (entry.getPath().toString().equalsIgnoreCase(newEntry.getPath().toString())) return;
                newPathList.add(entry);
            } else {
                if (entry.getPath().equals((Object)newEntry.getPath())) return;
                newPathList.add(entry);
            }
            ++i;
        }
        newPathList.add(newEntry);
        IClasspathEntry[] newClasspath = newPathList.toArray(new IClasspathEntry[newPathList.size()]);
        javaProject.setRawClasspath(newClasspath, (IProgressMonitor)new NullProgressMonitor());
    }

    public static Archive asArchiveFromBinary(String jarUri, IProject aProject) throws OpenFailureException {
        IPath path = J2EEProjectUtilities.getBinaryProjectJARLocation(aProject);
        if (path != null) {
            String location = path.toOSString();
            Archive anArchive = CommonarchiveFactoryImpl.getActiveFactory().primOpenArchive(location);
            anArchive.setURI(jarUri);
            return anArchive;
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ArchiveManifest readManifest(IFile aFile) {
        InputStream in = null;
        try {
            block9: {
                if (aFile == null) break block9;
                if (!aFile.exists()) {
                    break block9;
                }
                in = aFile.getContents();
                ArchiveManifestImpl archiveManifestImpl = new ArchiveManifestImpl(in);
                Object var3_3 = null;
                if (in == null) return archiveManifestImpl;
                try {
                    in.close();
                    return archiveManifestImpl;
                }
                catch (IOException iOException) {}
                return archiveManifestImpl;
                catch (Exception ex) {
                    Logger.getLogger().logError((Throwable)ex);
                }
            }
            Object var3_2 = null;
            if (in == null) return null;
            try {}
            catch (IOException iOException) {}
            in.close();
            return null;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            if (in == null) throw throwable;
            try {}
            catch (IOException iOException) {
                throw throwable;
            }
            in.close();
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ArchiveManifest readManifest(IProject p) {
        InputStream in = null;
        try {
            block9: {
                IFile aFile = J2EEProjectUtilities.getManifestFile(p);
                if (aFile == null) break block9;
                if (!aFile.exists()) {
                    break block9;
                }
                in = aFile.getContents();
                ArchiveManifestImpl archiveManifestImpl = new ArchiveManifestImpl(in);
                Object var3_5 = null;
                if (in == null) return archiveManifestImpl;
                try {
                    in.close();
                    return archiveManifestImpl;
                }
                catch (IOException iOException) {}
                return archiveManifestImpl;
                catch (Exception ex) {
                    Logger.getLogger().logError((Throwable)ex);
                }
            }
            Object var3_4 = null;
            if (in == null) return null;
            try {}
            catch (IOException iOException) {}
            in.close();
            return null;
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            if (in == null) throw throwable;
            try {}
            catch (IOException iOException) {
                throw throwable;
            }
            in.close();
            throw throwable;
        }
    }

    public static IFile getManifestFile(IProject p) {
        IVirtualComponent component = ComponentCore.createComponent((IProject)p);
        try {
            return ComponentUtilities.findFile((IVirtualComponent)component, (IPath)new Path("META-INF/MANIFEST.MF"));
        }
        catch (CoreException ce) {
            Logger.getLogger().log((Throwable)ce);
            return null;
        }
    }

    public static void writeManifest(IProject p, ArchiveManifest manifest) throws IOException {
        IFile aFile = J2EEProjectUtilities.getManifestFile(p);
        if (aFile != null) {
            WorkbenchByteArrayOutputStream out = new WorkbenchByteArrayOutputStream(aFile);
            manifest.writeSplittingClasspath((OutputStream)out);
            out.close();
        }
    }

    public static void writeManifest(IFile aFile, ArchiveManifest manifest) throws IOException {
        if (aFile != null) {
            WorkbenchByteArrayOutputStream out = new WorkbenchByteArrayOutputStream(aFile);
            manifest.writeSplittingClasspath((OutputStream)out);
            out.close();
        }
    }

    public static Map collectEJBClientJARs(EARFile earFile) {
        if (earFile == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap<EJBJarFile, Archive> ejbClientJARs = null;
        List ejbJARFiles = earFile.getEJBJarFiles();
        Archive clientJAR = null;
        int i = 0;
        while (i < ejbJARFiles.size()) {
            EJBJarFile ejbJarFile = (EJBJarFile)ejbJARFiles.get(i);
            clientJAR = J2EEProjectUtilities.getClientJAR(ejbJarFile, earFile);
            if (clientJAR != null) {
                if (ejbClientJARs == null) {
                    ejbClientJARs = new HashMap<EJBJarFile, Archive>();
                }
                ejbClientJARs.put(ejbJarFile, clientJAR);
            }
            ++i;
        }
        return ejbClientJARs == null ? Collections.EMPTY_MAP : ejbClientJARs;
    }

    public static String computeRelativeText(String referencingURI, String referencedURI, EnterpriseBean bean) {
        if (bean == null) {
            return null;
        }
        String beanName = bean.getName();
        if (beanName == null) {
            return null;
        }
        String relativeUri = J2EEProjectUtilities.computeRelativeText(referencingURI, referencedURI);
        if (relativeUri == null) {
            return beanName;
        }
        return String.valueOf(relativeUri) + "#" + beanName;
    }

    public static String computeRelativeText(String referencingURI, String referencedURI) {
        if (referencingURI == null || referencedURI == null) {
            return null;
        }
        Path pPre = new Path(referencingURI);
        Path pDep = new Path(referencedURI);
        if (pPre.getDevice() != null || pDep.getDevice() != null) {
            return null;
        }
        pPre = pPre.makeRelative();
        pDep = pDep.makeRelative();
        while (pPre.segmentCount() > 1 && pDep.segmentCount() > 1 && pPre.segment(0).equals(pDep.segment(0))) {
            pPre = pPre.removeFirstSegments(1);
            pDep = pDep.removeFirstSegments(1);
        }
        Object result = null;
        StringBuffer buf = new StringBuffer();
        String segment = null;
        do {
            segment = pDep.lastSegment();
            pPre = pPre.removeLastSegments(1);
            pDep = pDep.removeLastSegments(1);
            if (segment != null) {
                result = result == null ? new Path(segment) : new Path(segment).append((IPath)result);
            }
            if (pPre.equals((Object)pDep) || pPre.isEmpty()) continue;
            buf.append("../");
        } while (!pPre.equals((Object)pDep));
        if (result != null) {
            buf.append(result.makeRelative().toString());
        }
        return buf.toString();
    }

    public static IProject getEJBProjectFromEJBClientProject(IProject ejbClientProject) {
        try {
            if (ejbClientProject != null && ejbClientProject.hasNature("org.eclipse.jdt.core.javanature")) {
                IProject[] allProjects = J2EEProjectUtilities.getAllProjects();
                int i = 0;
                while (i < allProjects.length) {
                    if (EarModuleManager.getEJBModuleExtension().getEJBJar(allProjects[i]) != null && ejbClientProject == EarModuleManager.getEJBModuleExtension().getDefinedEJBClientJARProject(allProjects[i])) {
                        return allProjects[i];
                    }
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    public static EnterpriseBean getEnterpriseBean(ICompilationUnit cu) {
        IProject proj = cu.getJavaProject().getProject();
        EJBJar jar = EarModuleManager.getEJBModuleExtension().getEJBJar(proj);
        if (jar == null) {
            jar = EarModuleManager.getEJBModuleExtension().getEJBJar(J2EEProjectUtilities.getEJBProjectFromEJBClientProject(proj));
        }
        if (jar != null) {
            int index = cu.getElementName().indexOf(46);
            String className = cu.getElementName();
            if (index > 0) {
                className = className.substring(0, index);
            }
            JavaClass javaClass = (JavaClass)JavaRefFactory.eINSTANCE.reflectType(cu.getParent().getElementName(), className, jar.eResource().getResourceSet());
            return jar.getEnterpriseBeanWithReference(javaClass);
        }
        return null;
    }

    public static IContainer getSourceFolderOrFirst(IProject p, String defaultSourceName) {
        IPath sourcePath;
        block4: {
            try {
                sourcePath = J2EEProjectUtilities.getSourcePathOrFirst(p, defaultSourceName);
                if (sourcePath != null) break block4;
                return null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
        if (sourcePath.isEmpty()) {
            return p;
        }
        return p.getFolder(sourcePath);
    }

    public static void removeBuilders(IProject project, List builderids) throws CoreException {
        IProjectDescription desc = project.getDescription();
        ICommand[] oldSpec = desc.getBuildSpec();
        int oldLength = oldSpec.length;
        if (oldLength == 0) {
            return;
        }
        int remaining = 0;
        int i = 0;
        while (i < oldSpec.length) {
            if (builderids.contains(oldSpec[i].getBuilderName())) {
                oldSpec[i] = null;
            } else {
                ++remaining;
            }
            ++i;
        }
        if (remaining == oldSpec.length) {
            return;
        }
        ICommand[] newSpec = new ICommand[remaining];
        int i2 = 0;
        int newIndex = 0;
        while (i2 < oldLength) {
            if (oldSpec[i2] != null) {
                newSpec[newIndex++] = oldSpec[i2];
            }
            ++i2;
        }
        desc.setBuildSpec(newSpec);
        project.setDescription(desc, 0, null);
    }

    public static IPath getSourcePathOrFirst(IProject p, String defaultSourceName) {
        IJavaProject javaProj = JemProjectUtilities.getJavaProject((IProject)p);
        if (javaProj == null) {
            return null;
        }
        IClasspathEntry[] cp = null;
        try {
            cp = javaProj.getRawClasspath();
        }
        catch (JavaModelException ex) {
            JEMUtilPlugin.getLogger().logError((Throwable)ex);
            return null;
        }
        IClasspathEntry firstSource = null;
        IPath defaultSourcePath = null;
        if (defaultSourceName != null) {
            defaultSourcePath = J2EEProjectUtilities.createPath((IProject)p, (String)defaultSourceName);
        }
        boolean found = false;
        int i = 0;
        while (i < cp.length) {
            IPath sourceFolderPath;
            IFolder sourceFolder;
            if (cp[i].getEntryKind() == 3 && J2EEProjectUtilities.isSourceFolderAnInputContainer(sourceFolder = p.getFolder(sourceFolderPath = cp[i].getPath().removeFirstSegments(1)))) {
                found = true;
                if (firstSource == null) {
                    firstSource = cp[i];
                    if (defaultSourcePath == null) break;
                }
                if (cp[i].getPath().equals((Object)defaultSourcePath)) {
                    return defaultSourcePath.removeFirstSegments(1);
                }
            }
            ++i;
        }
        if (!found) {
            i = 0;
            while (i < cp.length) {
                if (cp[i].getEntryKind() == 3) {
                    if (firstSource == null) {
                        firstSource = cp[i];
                        if (defaultSourcePath == null) break;
                    }
                    if (cp[i].getPath().equals((Object)defaultSourcePath)) {
                        return defaultSourcePath.removeFirstSegments(1);
                    }
                }
                ++i;
            }
        }
        if (firstSource == null) {
            return null;
        }
        if (firstSource.getPath().segment(0).equals(p.getName())) {
            return firstSource.getPath().removeFirstSegments(1);
        }
        return null;
    }

    public static boolean isSourceFolderAnInputContainer(IFolder sourceFolder) {
        IProject project;
        block8: {
            IFolder parent = sourceFolder;
            do {
                if ((parent = parent.getParent()) != null) continue;
                return false;
            } while (!(parent instanceof IProject));
            project = (IProject)parent;
            if (project.isAccessible()) break block8;
            return false;
        }
        try {
            if (J2EEProjectUtilities.isEJBProject(project)) {
                return sourceFolder.findMember("META-INF/ejb-jar.xml") != null;
            }
            if (J2EEProjectUtilities.isApplicationClientProject(project)) {
                return sourceFolder.findMember("META-INF/application-client.xml") != null;
            }
            if (J2EEProjectUtilities.isDynamicWebProject(project)) {
                return sourceFolder.findMember("WEB-INF/web.xml") != null;
            }
            if (J2EEProjectUtilities.isJCAProject(project)) {
                return sourceFolder.findMember("META-INF/ra.xml") != null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static Archive asArchive(String jarUri, IProject project, boolean exportSource) throws OpenFailureException {
        JavaComponentLoadStrategyImpl strat = new JavaComponentLoadStrategyImpl(ComponentCore.createComponent((IProject)project));
        strat.setExportSource(exportSource);
        return CommonarchiveFactoryImpl.getActiveFactory().primOpenArchive((LoadStrategy)strat, jarUri);
    }

    public static boolean isProjectOfType(IProject project, String typeID) {
        IFacetedProject facetedProject = null;
        try {
            facetedProject = ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException coreException) {
            return false;
        }
        if (facetedProject != null && ProjectFacetsManager.isProjectFacetDefined((String)typeID)) {
            IProjectFacet projectFacet = ProjectFacetsManager.getProjectFacet((String)typeID);
            return projectFacet != null && facetedProject.hasProjectFacet(projectFacet);
        }
        return false;
    }

    private static boolean isProjectOfType(IFacetedProject facetedProject, String typeID) {
        if (facetedProject != null && ProjectFacetsManager.isProjectFacetDefined((String)typeID)) {
            IProjectFacet projectFacet = ProjectFacetsManager.getProjectFacet((String)typeID);
            return projectFacet != null && facetedProject.hasProjectFacet(projectFacet);
        }
        return false;
    }

    private static boolean isEARProject(IFacetedProject project) {
        return J2EEProjectUtilities.isProjectOfType(project, ENTERPRISE_APPLICATION);
    }

    private static boolean isDynamicWebProject(IFacetedProject project) {
        return J2EEProjectUtilities.isProjectOfType(project, DYNAMIC_WEB);
    }

    private static boolean isStaticWebProject(IFacetedProject project) {
        return J2EEProjectUtilities.isProjectOfType(project, STATIC_WEB);
    }

    private static boolean isEJBProject(IFacetedProject project) {
        return J2EEProjectUtilities.isProjectOfType(project, EJB);
    }

    private static boolean isJCAProject(IFacetedProject project) {
        return J2EEProjectUtilities.isProjectOfType(project, JCA);
    }

    private static boolean isApplicationClientProject(IFacetedProject project) {
        return J2EEProjectUtilities.isProjectOfType(project, APPLICATION_CLIENT);
    }

    private static boolean isUtilityProject(IFacetedProject project) {
        return J2EEProjectUtilities.isProjectOfType(project, UTILITY);
    }

    public static boolean isEARProject(IProject project) {
        return J2EEProjectUtilities.isProjectOfType(project, ENTERPRISE_APPLICATION);
    }

    public static boolean isDynamicWebProject(IProject project) {
        return J2EEProjectUtilities.isProjectOfType(project, DYNAMIC_WEB);
    }

    public static boolean isStaticWebProject(IProject project) {
        return J2EEProjectUtilities.isProjectOfType(project, STATIC_WEB);
    }

    public static boolean isEJBProject(IProject project) {
        return J2EEProjectUtilities.isProjectOfType(project, EJB);
    }

    public static boolean isJCAProject(IProject project) {
        return J2EEProjectUtilities.isProjectOfType(project, JCA);
    }

    public static boolean isApplicationClientProject(IProject project) {
        return J2EEProjectUtilities.isProjectOfType(project, APPLICATION_CLIENT);
    }

    public static boolean isUtilityProject(IProject project) {
        return J2EEProjectUtilities.isProjectOfType(project, UTILITY);
    }

    public static boolean isStandaloneProject(IProject project) {
        return J2EEProjectUtilities.getReferencingEARProjects(project).length == 0;
    }

    public static IProject[] getReferencingEARProjects(IProject project) {
        ArrayList<IProject> result = new ArrayList<IProject>();
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component != null) {
            IVirtualComponent[] refComponents = component.getReferencingComponents();
            int i = 0;
            while (i < refComponents.length) {
                if (J2EEProjectUtilities.isEARProject(refComponents[i].getProject())) {
                    result.add(refComponents[i].getProject());
                }
                ++i;
            }
        }
        return result.toArray(new IProject[result.size()]);
    }

    public static IProject[] getAllProjectsInWorkspaceOfType(String type) {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> result = new ArrayList<IProject>();
        int i = 0;
        while (i < projects.length) {
            if (J2EEProjectUtilities.isProjectOfType(projects[i], type)) {
                result.add(projects[i]);
            }
            ++i;
        }
        return result.toArray(new IProject[result.size()]);
    }

    public static String getJ2EEProjectType(IProject project) {
        IFacetedProject facetedProject = null;
        try {
            facetedProject = ProjectFacetsManager.create((IProject)project);
        }
        catch (CoreException coreException) {
            return "";
        }
        if (J2EEProjectUtilities.isApplicationClientProject(facetedProject)) {
            return APPLICATION_CLIENT;
        }
        if (J2EEProjectUtilities.isDynamicWebProject(facetedProject)) {
            return DYNAMIC_WEB;
        }
        if (J2EEProjectUtilities.isEJBProject(facetedProject)) {
            return EJB;
        }
        if (J2EEProjectUtilities.isEARProject(facetedProject)) {
            return ENTERPRISE_APPLICATION;
        }
        if (J2EEProjectUtilities.isJCAProject(facetedProject)) {
            return JCA;
        }
        if (J2EEProjectUtilities.isStaticWebProject(facetedProject)) {
            return STATIC_WEB;
        }
        if (J2EEProjectUtilities.isUtilityProject(facetedProject)) {
            return UTILITY;
        }
        return "";
    }

    public static IRuntime getServerRuntime(IProject project) throws CoreException {
        if (project == null) {
            return null;
        }
        IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
        if (facetedProject == null) {
            return null;
        }
        org.eclipse.wst.common.project.facet.core.runtime.IRuntime runtime = facetedProject.getRuntime();
        if (runtime == null) {
            return null;
        }
        return FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)runtime);
    }

    public static String getJ2EEProjectVersion(IProject project) {
        String type = J2EEProjectUtilities.getJ2EEProjectType(project);
        IFacetedProject facetedProject = null;
        IProjectFacet facet = null;
        try {
            facetedProject = ProjectFacetsManager.create((IProject)project);
            facet = ProjectFacetsManager.getProjectFacet((String)type);
        }
        catch (Exception exception) {}
        if (facet != null && facetedProject.hasProjectFacet(facet)) {
            return facetedProject.getInstalledVersion(facet).getVersionString();
        }
        return null;
    }

    public static JavaProjectMigrationOperation createFlexJavaProjectForProjectOperation(IProject project) {
        IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new JavaProjectMigrationDataModelProvider());
        model.setProperty("IJavaProjectMigrationDataModelProperties.PROJECT_NAME", (Object)project.getName());
        return new JavaProjectMigrationOperation(model);
    }

    public static IPackageFragmentRoot[] getSourceContainers(IProject project) {
        IJavaProject jProject = JemProjectUtilities.getJavaProject((IProject)project);
        if (jProject == null) {
            return new IPackageFragmentRoot[0];
        }
        ArrayList<IPackageFragmentRoot> list = new ArrayList<IPackageFragmentRoot>();
        IVirtualComponent vc = ComponentCore.createComponent((IProject)project);
        try {
            IPackageFragmentRoot[] roots = jProject.getPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                IResource resource;
                if (roots[i].getKind() == 1 && (resource = roots[i].getResource()) != null) {
                    IVirtualResource[] vResources = ComponentCore.createResources((IResource)resource);
                    boolean found = false;
                    int j = 0;
                    while (!found && j < vResources.length) {
                        if (vResources[j].getComponent().equals(vc)) {
                            if (!list.contains(roots[i])) {
                                list.add(roots[i]);
                            }
                            found = true;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException e) {
            Logger.getLogger().logError((Throwable)e);
        }
        return list.toArray(new IPackageFragmentRoot[list.size()]);
    }

    public static IContainer[] getOutputContainers(IProject project) {
        ArrayList<IContainer> result = new ArrayList<IContainer>();
        try {
            if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
                return new IContainer[0];
            }
        }
        catch (Exception exception) {}
        IPackageFragmentRoot[] sourceContainers = J2EEProjectUtilities.getSourceContainers(project);
        int i = 0;
        while (i < sourceContainers.length) {
            IContainer outputFolder = J2EEProjectUtilities.getOutputContainer(project, sourceContainers[i]);
            if (outputFolder != null && !result.contains(outputFolder)) {
                result.add(outputFolder);
            }
            ++i;
        }
        return result.toArray(new IContainer[result.size()]);
    }

    public static IContainer getOutputContainer(IProject project, IPackageFragmentRoot sourceContainer) {
        try {
            IJavaProject jProject = JavaCore.create((IProject)project);
            IPath outputPath = sourceContainer.getRawClasspathEntry().getOutputLocation();
            if (outputPath == null) {
                if (jProject.getOutputLocation().segmentCount() == 1) {
                    return project;
                }
                return project.getFolder(jProject.getOutputLocation().removeFirstSegments(1));
            }
            return project.getFolder(outputPath.removeFirstSegments(1));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static IPath getResolvedPathForArchiveComponent(String name) {
        URI uri = URI.createURI((String)name);
        String resourceType = uri.segment(0);
        URI contenturi = ModuleURIUtil.trimToRelativePath((URI)uri, (int)1);
        String contentName = contenturi.toString();
        if (resourceType.equals("lib")) {
            return Path.fromOSString((String)contentName);
        }
        if (resourceType.equals("var")) {
            String classpathVar = contenturi.segment(0);
            URI remainingPathuri = ModuleURIUtil.trimToRelativePath((URI)contenturi, (int)1);
            String remainingPath = remainingPathuri.toString();
            String[] classpathvars = JavaCore.getClasspathVariableNames();
            boolean found = false;
            int i = 0;
            while (i < classpathvars.length) {
                if (classpathVar.equals(classpathvars[i])) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (found) {
                IPath path = JavaCore.getClasspathVariable((String)classpathVar);
                URI finaluri = URI.createURI((String)(String.valueOf(path.toOSString()) + '/' + remainingPath));
                return Path.fromOSString((String)finaluri.toString());
            }
        }
        return null;
    }

    public static List getAllJavaNonFlexProjects() throws CoreException {
        ArrayList<IProject> nonFlexJavaProjects = new ArrayList<IProject>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            if (projects[i].isAccessible() && projects[i].hasNature("org.eclipse.jdt.core.javanature") && !projects[i].hasNature("org.eclipse.wst.common.modulecore.ModuleCoreNature")) {
                nonFlexJavaProjects.add(projects[i]);
            }
            ++i;
        }
        return nonFlexJavaProjects;
    }

    public static String getServerContextRoot(IProject project) {
        return ComponentUtilities.getServerContextRoot((IProject)project);
    }

    public static void setServerContextRoot(IProject project, String contextRoot) {
        ComponentUtilities.setServerContextRoot((IProject)project, (String)contextRoot);
    }
}

