/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.contentassist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.ui.text.java.CompletionProposalCollector;
import org.eclipse.jdt.ui.text.java.CompletionProposalComparator;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jst.jsp.core.internal.java.JSP2ServletNameUtil;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslation;
import org.eclipse.jst.jsp.ui.internal.contentassist.JSPCompletionProposal;
import org.eclipse.swt.graphics.Image;

public class JSPProposalCollector
extends CompletionProposalCollector {
    private String fJspName;
    private String fMangledName;
    private JSPTranslation fTranslation;
    private Comparator fComparator;

    public JSPProposalCollector(ICompilationUnit cu, JSPTranslation translation) {
        super(cu);
        if (cu != null) {
            String cuName = cu.getPath().lastSegment();
            this.setMangledName(cuName.substring(0, cuName.lastIndexOf(46)));
            String unmangled = JSP2ServletNameUtil.unmangle((String)cuName);
            this.setJspName(unmangled.substring(unmangled.lastIndexOf(47) + 1));
        }
        if (translation == null) {
            throw new IllegalArgumentException("JSPTranslation cannot be null");
        }
        this.fTranslation = translation;
    }

    public JSPCompletionProposal[] getJSPCompletionProposals() {
        ArrayList<IJavaCompletionProposal> results = new ArrayList<IJavaCompletionProposal>();
        IJavaCompletionProposal[] javaProposals = this.getJavaCompletionProposals();
        int i = 0;
        while (i < javaProposals.length) {
            if (javaProposals[i] instanceof JSPCompletionProposal) {
                results.add(javaProposals[i]);
            }
            ++i;
        }
        Collections.sort(results, this.getComparator());
        return results.toArray(new JSPCompletionProposal[results.size()]);
    }

    private Comparator getComparator() {
        if (this.fComparator == null) {
            this.fComparator = new CompletionProposalComparator();
        }
        return this.fComparator;
    }

    protected IJavaCompletionProposal createJavaCompletionProposal(CompletionProposal proposal) {
        JSPCompletionProposal jspProposal = null;
        String completion = String.valueOf(proposal.getCompletion());
        String mangledName = this.getMangledName();
        if (mangledName != null && completion.indexOf(mangledName) == -1) {
            int offset = proposal.getReplaceStart();
            int length = proposal.getReplaceEnd() - offset;
            offset = this.fTranslation.getJspOffset(offset);
            int positionAfter = this.calculatePositionAfter(proposal, completion, offset);
            IJavaCompletionProposal javaProposal = super.createJavaCompletionProposal(proposal);
            Image image = javaProposal.getImage();
            String displayString = javaProposal.getDisplayString();
            displayString = this.fixupDisplayString(displayString);
            IContextInformation contextInformation = javaProposal.getContextInformation();
            String additionalInfo = javaProposal.getAdditionalProposalInfo();
            int relevance = javaProposal.getRelevance();
            boolean updateLengthOnValidate = true;
            jspProposal = new JSPCompletionProposal(completion, offset, length, positionAfter, image, displayString, contextInformation, additionalInfo, relevance, updateLengthOnValidate);
        }
        return jspProposal;
    }

    private int calculatePositionAfter(CompletionProposal proposal, String completion, int currentCursorOffset) {
        int positionAfter = completion.length();
        int kind = proposal.getKind();
        if (kind == 1 || kind == 7 || kind == 11 || kind == 6) {
            String[] params = Signature.getParameterTypes((String)String.valueOf(proposal.getSignature()));
            if (completion.length() > 0 && params.length > 0) {
                --positionAfter;
            }
        }
        return positionAfter;
    }

    private String fixupDisplayString(String displayString) {
        int index;
        StringBuffer fixedName = new StringBuffer(displayString);
        String mangledName = this.getMangledName();
        if (mangledName != null && (index = displayString.indexOf(mangledName)) != -1) {
            fixedName = new StringBuffer();
            fixedName.append(displayString.substring(0, index));
            fixedName.append(this.getJspName());
            fixedName.append(displayString.substring(index + mangledName.length()));
        }
        return fixedName.toString();
    }

    private String getMangledName() {
        return this.fMangledName;
    }

    private void setMangledName(String mangledName) {
        this.fMangledName = mangledName;
    }

    private String getJspName() {
        return this.fJspName;
    }

    private void setJspName(String jspName) {
        this.fJspName = jspName;
    }

    static char[] getTypeTriggers() {
        return TYPE_TRIGGERS;
    }

    public JSPTranslation getTranslation() {
        return this.fTranslation;
    }
}

