/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.java.refactoring;

import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ICreateTargetQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.JavaMoveProcessor;
import org.eclipse.jdt.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.jdt.internal.ui.refactoring.reorg.CreateTargetQueries;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgMoveWizard;
import org.eclipse.jdt.internal.ui.refactoring.reorg.ReorgQueries;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jst.jsp.ui.internal.JSPUIMessages;
import org.eclipse.jst.jsp.ui.internal.Logger;
import org.eclipse.jst.jsp.ui.internal.java.refactoring.JSPJavaSelectionProvider;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.participants.MoveProcessor;
import org.eclipse.ltk.core.refactoring.participants.MoveRefactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.ui.internal.util.PlatformStatusLineUtil;

public class JSPMoveElementActionDelegate
implements IEditorActionDelegate,
IActionDelegate2,
IViewActionDelegate {
    private IEditorPart fEditor;

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.fEditor = targetEditor;
    }

    public void dispose() {
        this.fEditor = null;
    }

    public void init(IAction action) {
        if (action != null) {
            action.setText(JSPUIMessages.MoveElement_label);
            action.setToolTipText(JSPUIMessages.MoveElement_label);
        }
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void run(IAction action) {
        IJavaElement[] elements = this.getSelectedElements();
        if (elements.length > 0) {
            try {
                JavaMoveProcessor processor = JavaMoveProcessor.create((IResource[])this.getResources(elements), (IJavaElement[])elements);
                Shell parent = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                MoveRefactoring refactoring = new MoveRefactoring((MoveProcessor)processor);
                RefactoringWizard wizard = this.createWizard(refactoring);
                processor.setCreateTargetQueries((ICreateTargetQueries)new CreateTargetQueries((Wizard)wizard));
                processor.setReorgQueries((IReorgQueries)new ReorgQueries((Wizard)wizard));
                String openRefactoringWizMsg = JSPUIMessages.MoveElementWizard;
                new RefactoringStarter().activate((Refactoring)refactoring, wizard, parent, openRefactoringWizMsg, true);
                PlatformStatusLineUtil.clearStatusLine();
            }
            catch (JavaModelException e) {
                Logger.logException(e);
            }
        } else {
            PlatformStatusLineUtil.displayErrorMessage((String)JSPUIMessages.JSPMoveElementAction_0);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        PlatformStatusLineUtil.clearStatusLine();
    }

    public void init(IViewPart view) {
    }

    private IJavaElement[] getSelectedElements() {
        IJavaElement[] elements = new IJavaElement[]{};
        if (this.fEditor instanceof ITextEditor) {
            elements = JSPJavaSelectionProvider.getSelection((ITextEditor)this.fEditor);
        }
        return elements;
    }

    private IResource[] getResources(IJavaElement[] elements) {
        IResource[] resources = new IResource[elements.length];
        int i = 0;
        while (i < elements.length) {
            try {
                resources[i] = elements[i].getPrimaryElement().getCorrespondingResource();
            }
            catch (JavaModelException e) {
                Logger.logException(e);
            }
            ++i;
        }
        return resources;
    }

    private RefactoringWizard createWizard(MoveRefactoring refactoring) {
        return new ReorgMoveWizard(refactoring);
    }
}

