/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.generic.core.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jst.server.generic.core.internal.GenericPublisher;
import org.eclipse.jst.server.generic.core.internal.GenericServer;
import org.eclipse.jst.server.generic.core.internal.GenericServerCoreMessages;
import org.eclipse.jst.server.generic.core.internal.GenericServerRuntime;
import org.eclipse.jst.server.generic.core.internal.PingThread;
import org.eclipse.jst.server.generic.core.internal.PublishManager;
import org.eclipse.jst.server.generic.core.internal.ServerTypeDefinitionUtil;
import org.eclipse.jst.server.generic.core.internal.Trace;
import org.eclipse.jst.server.generic.servertype.definition.ArchiveType;
import org.eclipse.jst.server.generic.servertype.definition.ArgumentPair;
import org.eclipse.jst.server.generic.servertype.definition.Classpath;
import org.eclipse.jst.server.generic.servertype.definition.LaunchConfiguration;
import org.eclipse.jst.server.generic.servertype.definition.ServerRuntime;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerPort;
import org.eclipse.wst.server.core.internal.DeletedModule;
import org.eclipse.wst.server.core.model.ServerBehaviourDelegate;
import org.eclipse.wst.server.core.util.SocketUtil;

public class GenericServerBehaviour
extends ServerBehaviourDelegate {
    private static final String ATTR_STOP = "stop-server";
    protected transient PingThread ping = null;
    protected transient IDebugEventSetListener processListener;
    protected transient IProcess process;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void publishServer(int kind, IProgressMonitor monitor) throws CoreException {
    }

    public void publishModule(int kind, int deltaKind, IModule[] module, IProgressMonitor monitor) throws CoreException {
        this.checkClosed(module);
        if (3 == deltaKind) {
            this.removeFromServer(module, monitor);
        } else {
            String publisherId = ServerTypeDefinitionUtil.getPublisherID(module[0], this.getServerDefinition());
            GenericPublisher publisher = PublishManager.getPublisher(publisherId);
            if (publisher == null) {
                Status status = new Status(4, "org.eclipse.jst.server.generic.core", 0, GenericServerCoreMessages.bind((String)GenericServerCoreMessages.unableToCreatePublisher, (Object)publisherId), null);
                throw new CoreException((IStatus)status);
            }
            publisher.initialize(module, this.getServer());
            IStatus[] status = publisher.publish(null, monitor);
            if (status == null) {
                this.setModulePublishState(module, 1);
            } else {
                int i = 0;
                while (i < status.length) {
                    if (4 == status[i].getSeverity()) {
                        this.setModulePublishState(module, 0);
                        throw new CoreException(status[i]);
                    }
                    ++i;
                }
            }
        }
    }

    private void checkClosed(IModule[] module) throws CoreException {
        int i = 0;
        while (i < module.length) {
            if (module[i] instanceof DeletedModule) {
                Status status = new Status(4, "org.eclipse.jst.server.generic.core", 0, GenericServerCoreMessages.bind((String)GenericServerCoreMessages.canNotPublishDeletedModule, (Object)module[i].getName()), null);
                throw new CoreException((IStatus)status);
            }
            ++i;
        }
    }

    private void removeFromServer(IModule[] module, IProgressMonitor monitor) throws CoreException {
        String publisherId = ServerTypeDefinitionUtil.getPublisherID(module[0], this.getServerDefinition());
        GenericPublisher publisher = PublishManager.getPublisher(publisherId);
        if (publisher == null) {
            Status status = new Status(4, "org.eclipse.jst.server.generic.core", 0, GenericServerCoreMessages.bind((String)GenericServerCoreMessages.unableToCreatePublisher, (Object)publisherId), null);
            throw new CoreException((IStatus)status);
        }
        publisher.initialize(module, this.getServer());
        publisher.unpublish(monitor);
    }

    public void stop(boolean force) {
        if (force) {
            this.terminate();
            return;
        }
        int state = this.getServer().getServerState();
        if (state == 4) {
            return;
        }
        if (state == 1 || state == 3) {
            this.terminate();
            return;
        }
        this.shutdown(state);
    }

    protected void shutdown(int state) {
        GenericServerRuntime runtime = this.getRuntimeDelegate();
        try {
            Trace.trace(Trace.FINEST, "Stopping Server");
            if (state != 4) {
                this.setServerState(3);
            }
            String configTypeID = this.getConfigTypeID();
            ILaunchManager mgr = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType type = mgr.getLaunchConfigurationType(configTypeID);
            String launchName = this.getStopLaunchName();
            String uniqueLaunchName = mgr.generateUniqueLaunchConfigurationNameFrom(launchName);
            ILaunchConfiguration conf = null;
            ILaunchConfiguration[] lch = mgr.getLaunchConfigurations(type);
            int i = 0;
            while (i < lch.length) {
                if (launchName.equals(lch[i].getName())) {
                    conf = lch[i];
                    break;
                }
                ++i;
            }
            ILaunchConfigurationWorkingCopy wc = null;
            wc = conf != null ? conf.getWorkingCopy() : type.newInstance(null, uniqueLaunchName);
            wc.setAttribute(IDebugUIConstants.ATTR_PRIVATE, true);
            wc.setAttribute(ATTR_STOP, "true");
            this.setupStopLaunchConfiguration(runtime, wc);
            wc.launch("run", (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error stopping Server", e);
        }
    }

    protected String getConfigTypeID() {
        return IJavaLaunchConfigurationConstants.ID_JAVA_APPLICATION;
    }

    protected String getStopLaunchName() {
        return "GenericServerStopper";
    }

    private boolean isRemote() {
        return this.getServer().getServerType().supportsRemoteHosts() && !SocketUtil.isLocalhost((String)this.getServer().getHost());
    }

    protected void setupStopLaunchConfiguration(GenericServerRuntime runtime, ILaunchConfigurationWorkingCopy wc) {
        if (this.isRemote()) {
            return;
        }
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, this.getServerDefinition().getResolver().resolveProperties(this.getServerDefinition().getStop().getMainClass()));
        IVMInstall vmInstall = runtime.getVMInstall();
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, runtime.getVMInstallTypeId());
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_NAME, vmInstall.getName());
        this.setupLaunchClasspath(wc, vmInstall, this.getStopClasspath());
        Map environVars = this.getEnvironmentVariables(this.getServerDefinition().getStop());
        if (!environVars.isEmpty()) {
            wc.setAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, environVars);
        }
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, this.getServerDefinition().getResolver().resolveProperties(this.getServerDefinition().getStop().getWorkingDirectory()));
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, this.getServerDefinition().getResolver().resolveProperties(this.getServerDefinition().getStop().getProgramArgumentsAsString()));
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, this.getServerDefinition().getResolver().resolveProperties(this.getServerDefinition().getStop().getVmParametersAsString()));
    }

    public String getStartClassName() {
        return this.getServerDefinition().getResolver().resolveProperties(this.getServerDefinition().getStart().getMainClass());
    }

    public ServerRuntime getServerDefinition() {
        IServer iServer = this.getServer();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.server.core.model.ServerDelegate");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        GenericServer server = (GenericServer)((Object)iServer.loadAdapter((Class)clazz, null));
        return server.getServerDefinition();
    }

    protected GenericServerRuntime getRuntimeDelegate() {
        IRuntime iRuntime = this.getServer().getRuntime();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jst.server.generic.core.internal.GenericServerRuntime");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (GenericServerRuntime)((Object)iRuntime.loadAdapter((Class)clazz, null));
    }

    private List getStartClasspath() {
        String cpRef = this.getServerDefinition().getStart().getClasspathReference();
        return this.serverClasspath(cpRef);
    }

    protected List serverClasspath(String cpRef) {
        Classpath classpath = this.getServerDefinition().getClasspath(cpRef);
        ArrayList<IRuntimeClasspathEntry> cpEntryList = new ArrayList<IRuntimeClasspathEntry>(classpath.getArchive().size());
        Iterator iterator = classpath.getArchive().iterator();
        while (iterator.hasNext()) {
            ArchiveType archive = (ArchiveType)iterator.next();
            String cpath = this.getServerDefinition().getResolver().resolveProperties(archive.getPath());
            cpEntryList.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)new Path(cpath)));
        }
        return cpEntryList;
    }

    protected void setupLaunchClasspath(ILaunchConfigurationWorkingCopy wc, IVMInstall vmInstall, List cp) {
        try {
            IRuntimeClasspathEntry[] existingCps = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)wc);
            int i = 0;
            while (i < existingCps.length) {
                if (!cp.contains(existingCps[i])) {
                    cp.add(existingCps[i]);
                }
                ++i;
            }
        }
        catch (CoreException coreException) {}
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, this.convertCPEntryToMemento(cp));
        wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
    }

    private List convertCPEntryToMemento(List cpEntryList) {
        ArrayList<String> list = new ArrayList<String>(cpEntryList.size());
        Iterator iterator = cpEntryList.iterator();
        while (iterator.hasNext()) {
            IRuntimeClasspathEntry entry = (IRuntimeClasspathEntry)iterator.next();
            try {
                list.add(entry.getMemento());
            }
            catch (CoreException coreException) {}
        }
        return list;
    }

    private String getWorkingDirectory() {
        return this.getServerDefinition().getResolver().resolveProperties(this.getServerDefinition().getStart().getWorkingDirectory());
    }

    protected String getProgramArguments() {
        return this.getServerDefinition().getResolver().resolveProperties(this.getServerDefinition().getStart().getProgramArgumentsAsString());
    }

    protected Map getEnvironmentVariables(LaunchConfiguration config) {
        List variables = config.getEnvironmentVariable();
        HashMap<String, String> varsMap = new HashMap<String, String>(variables.size());
        Iterator iterator = variables.iterator();
        while (iterator.hasNext()) {
            ArgumentPair pair = (ArgumentPair)iterator.next();
            varsMap.put(pair.getName(), this.getServerDefinition().getResolver().resolveProperties(pair.getValue()));
        }
        return varsMap;
    }

    private String getVmArguments() {
        return this.getServerDefinition().getResolver().resolveProperties(this.getServerDefinition().getStart().getVmParametersAsString());
    }

    public void setupLaunchConfiguration(ILaunchConfigurationWorkingCopy workingCopy, IProgressMonitor monitor) throws CoreException {
        if (this.isRemote()) {
            return;
        }
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, this.getStartClassName());
        GenericServerRuntime runtime = this.getRuntimeDelegate();
        IVMInstall vmInstall = runtime.getVMInstall();
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, runtime.getVMInstallTypeId());
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_NAME, vmInstall.getName());
        this.setupLaunchClasspath(workingCopy, vmInstall, this.getStartClasspath());
        workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_WORKING_DIRECTORY, this.getWorkingDirectory());
        Map environVars = this.getEnvironmentVariables(this.getServerDefinition().getStart());
        if (!environVars.isEmpty()) {
            workingCopy.setAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, environVars);
        }
        String existingProgArgs = workingCopy.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, null);
        String serverProgArgs = this.getProgramArguments();
        if (existingProgArgs == null || existingProgArgs.indexOf(serverProgArgs) < 0) {
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, serverProgArgs);
        }
        String existingVMArgs = workingCopy.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, null);
        String serverVMArgs = this.getVmArguments();
        if (existingVMArgs == null || existingVMArgs.indexOf(serverVMArgs) < 0) {
            workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_ARGUMENTS, serverVMArgs);
        }
    }

    protected void setupLaunch(ILaunch launch, String launchMode, IProgressMonitor monitor) throws CoreException {
        if ("true".equals(launch.getLaunchConfiguration().getAttribute(ATTR_STOP, "false"))) {
            return;
        }
        String host = this.getServer().getHost();
        ServerPort[] ports = this.getServer().getServerPorts(null);
        ServerPort sp = null;
        if (!this.getServer().getServerType().supportsRemoteHosts() && SocketUtil.isLocalhost((String)host)) {
            int i = 0;
            while (i < ports.length) {
                sp = ports[i];
                if (SocketUtil.isPortInUse((int)ports[i].getPort(), (int)5)) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.jst.server.generic.core", 0, GenericServerCoreMessages.bind((String)GenericServerCoreMessages.errorPortInUse, (Object)Integer.toString(sp.getPort()), (Object)sp.getName()), null));
                }
                ++i;
            }
        }
        this.setServerState(1);
        this.setMode(launchMode);
        try {
            String url = "http://" + host;
            int port = sp.getPort();
            if (port != 80) {
                url = String.valueOf(url) + ":" + port;
            }
            this.ping = new PingThread(this.getServer(), url, this);
        }
        catch (Exception exception) {
            Trace.trace(Trace.SEVERE, "Can't ping for server startup.");
        }
    }

    protected void setProcess(IProcess newProcess) {
        if (this.process != null) {
            return;
        }
        if (this.processListener != null) {
            DebugPlugin.getDefault().removeDebugEventListener(this.processListener);
        }
        if (newProcess == null) {
            return;
        }
        this.process = newProcess;
        this.processListener = new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                if (events != null) {
                    int size = events.length;
                    int i = 0;
                    while (i < size) {
                        if (GenericServerBehaviour.this.process != null && GenericServerBehaviour.this.process.equals(events[i].getSource()) && events[i].getKind() == 8) {
                            DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                            GenericServerBehaviour.this.stopImpl();
                        }
                        ++i;
                    }
                }
            }
        };
        DebugPlugin.getDefault().addDebugEventListener(this.processListener);
    }

    protected void stopImpl() {
        if (this.ping != null) {
            this.ping.stop();
            this.ping = null;
        }
        if (this.process != null) {
            this.process = null;
            DebugPlugin.getDefault().removeDebugEventListener(this.processListener);
            this.processListener = null;
        }
        this.setServerState(4);
    }

    protected void terminate() {
        if (this.getServer().getServerState() == 4) {
            return;
        }
        try {
            this.setServerState(3);
            Trace.trace(Trace.FINEST, "Killing the Server process");
            if (this.process != null && !this.process.isTerminated()) {
                this.process.terminate();
            }
            this.stopImpl();
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Error killing the process", e);
        }
    }

    private List getStopClasspath() {
        String cpRef = this.getServerDefinition().getStop().getClasspathReference();
        return this.serverClasspath(cpRef);
    }

    public void publishFinish(IProgressMonitor monitor) throws CoreException {
        IModule[] modules = this.getServer().getModules();
        boolean allpublished = true;
        int i = 0;
        while (i < modules.length) {
            if (this.getServer().getModulePublishState(new IModule[]{modules[i]}) != 1) {
                allpublished = false;
            }
            ++i;
        }
        if (allpublished) {
            this.setServerPublishState(1);
        }
    }

    protected void setServerStarted() {
        this.setServerState(2);
    }
}

