/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.wsrt;

import java.util.Hashtable;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.ClientType;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.ServiceType;
import org.eclipse.wst.ws.internal.wsrt.IWebServiceRuntime;

public class WebServiceRuntimeInfo {
    private IConfigurationElement elem_;
    private Hashtable allServiceTypes_;
    private Hashtable allClientTypes_;
    private String id;
    private String label;
    private ServiceType[] serviceTypes;
    private ClientType[] clientTypes;
    private String[] servletLevels;
    private String[] j2eeLevels;
    private String[] runtimeIds;
    private String[] serverFactoryIds;
    private String className;
    private IWebServiceRuntime webServiceRuntime_;

    public WebServiceRuntimeInfo(IConfigurationElement elem_, Hashtable allServiceTypes_, Hashtable allClientTypes_) {
        this.elem_ = elem_;
        this.allServiceTypes_ = allServiceTypes_;
        this.allClientTypes_ = allClientTypes_;
    }

    public String getClassName() {
        if (this.className == null) {
            this.className = this.elem_.getAttribute("class");
        }
        return this.className;
    }

    public ClientType[] getClientTypes() {
        String attr;
        if (this.clientTypes == null && (attr = this.elem_.getAttribute("clientTypes")) != null && attr.length() > 0) {
            StringTokenizer st = new StringTokenizer(attr, " ");
            int size = st.countTokens();
            this.clientTypes = new ClientType[size];
            int i = 0;
            while (i < this.clientTypes.length) {
                String ctid = st.nextToken();
                this.clientTypes[i] = (ClientType)this.allClientTypes_.get(ctid);
                ++i;
            }
        }
        return this.clientTypes;
    }

    public String getId() {
        if (this.id == null) {
            this.id = this.elem_.getAttribute("id");
        }
        return this.id;
    }

    public String getLabel() {
        if (this.label == null) {
            this.label = this.elem_.getAttribute("label");
        }
        return this.label;
    }

    public String[] getJ2eeLevels() {
        String attr;
        if (this.j2eeLevels == null && (attr = this.elem_.getAttribute("j2eeLevels")) != null && attr.length() > 0) {
            StringTokenizer st = new StringTokenizer(attr, " ");
            int size = st.countTokens();
            this.j2eeLevels = new String[size];
            int i = 0;
            while (i < this.j2eeLevels.length) {
                this.j2eeLevels[i] = st.nextToken();
                ++i;
            }
        }
        return this.j2eeLevels;
    }

    public String[] getRuntimeIds() {
        String attr;
        if (this.runtimeIds == null && (attr = this.elem_.getAttribute("runtimes")) != null && attr.length() > 0) {
            StringTokenizer st = new StringTokenizer(attr, " ");
            int size = st.countTokens();
            this.runtimeIds = new String[size];
            int i = 0;
            while (i < this.runtimeIds.length) {
                this.runtimeIds[i] = st.nextToken();
                ++i;
            }
        }
        return this.runtimeIds;
    }

    public String[] getServerFactoryIds() {
        String attr;
        if (this.serverFactoryIds == null && (attr = this.elem_.getAttribute("servers")) != null && attr.length() > 0) {
            StringTokenizer st = new StringTokenizer(attr, " ");
            int size = st.countTokens();
            this.serverFactoryIds = new String[size];
            int i = 0;
            while (i < this.serverFactoryIds.length) {
                this.serverFactoryIds[i] = st.nextToken();
                ++i;
            }
        }
        return this.serverFactoryIds;
    }

    public ServiceType[] getServiceTypes() {
        String attr;
        if (this.serviceTypes == null && (attr = this.elem_.getAttribute("serviceTypes")) != null && attr.length() > 0) {
            StringTokenizer st = new StringTokenizer(attr, " ");
            int size = st.countTokens();
            this.serviceTypes = new ServiceType[size];
            int i = 0;
            while (i < this.serviceTypes.length) {
                String ctid = st.nextToken();
                this.serviceTypes[i] = (ServiceType)this.allServiceTypes_.get(ctid);
                ++i;
            }
        }
        return this.serviceTypes;
    }

    public String[] getServletLevels() {
        String attr;
        if (this.servletLevels == null && (attr = this.elem_.getAttribute("servletLevels")) != null && attr.length() > 0) {
            StringTokenizer st = new StringTokenizer(attr, " ");
            int size = st.countTokens();
            this.servletLevels = new String[size];
            int i = 0;
            while (i < this.servletLevels.length) {
                this.servletLevels[i] = st.nextToken();
                ++i;
            }
        }
        return this.servletLevels;
    }

    public IWebServiceRuntime getWebServiceRuntime() {
        if (this.webServiceRuntime_ == null) {
            try {
                this.webServiceRuntime_ = (IWebServiceRuntime)this.elem_.createExecutableExtension("class");
            }
            catch (CoreException ce) {
                ce.printStackTrace();
            }
        }
        return this.webServiceRuntime_;
    }
}

