/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.creation.ui.widgets.runtime;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.ws.internal.consumption.common.FacetUtils;
import org.eclipse.jst.ws.internal.consumption.ui.ConsumptionUIMessages;
import org.eclipse.jst.ws.internal.consumption.ui.common.ValidationUtils;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.runtime.ClientRuntimeSelectionWidget;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.runtime.ProjectSelectionWidget;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.runtime.RuntimeServerSelectionWidget;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceRuntimeExtensionUtils2;
import org.eclipse.jst.ws.internal.data.TypeRuntimeServer;
import org.eclipse.jst.ws.internal.ui.common.UIUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;

public class ServerRuntimeSelectionWidget
extends SimpleWidgetDataContributor {
    private String createPluginId_ = "org.eclipse.jst.ws.creation.ui";
    private String INFOPOP_PWRS_GROUP_SERVICE = "PWRS0002";
    private RuntimeServerSelectionWidget runtimeWidget_;
    private ProjectSelectionWidget projectWidget_;
    private ClientRuntimeSelectionWidget clientWidget_;
    private TextModifyListener textListener_;
    private boolean isClientWidgetVisible_ = true;

    public WidgetDataEvents addControls(Composite parent, Listener statusListener) {
        UIUtils uiUtils = new UIUtils(this.createPluginId_);
        ScrolledComposite scroller = new ScrolledComposite(parent, 768);
        scroller.setExpandHorizontal(true);
        scroller.setExpandVertical(true);
        Composite root = uiUtils.createComposite((Composite)scroller, 1);
        scroller.setContent((Control)root);
        Composite textComposite = uiUtils.createComposite(root, 1, 0, 0);
        this.createMessageText(textComposite, NLS.bind((String)ConsumptionUIMessages.MSG_GENERAL_PROJECT_AND_EAR, (Object[])new String[]{ConsumptionUIMessages.MSG_SERVICE_SUB}));
        this.createMessageText(textComposite, ConsumptionUIMessages.MSG_EAR_PROJECT_WILL_BE_CREATED);
        Composite serverComp = uiUtils.createComposite(root, 1, 5, 0);
        Group serverGroup = uiUtils.createGroup(serverComp, ConsumptionUIMessages.LABEL_SELECTION_VIEW_TITLE, null, this.INFOPOP_PWRS_GROUP_SERVICE, 2, 5, 5);
        this.runtimeWidget_ = new RuntimeServerSelectionWidget(false);
        this.runtimeWidget_.addControls((Composite)serverGroup, statusListener);
        this.textListener_ = new TextModifyListener();
        this.runtimeWidget_.addModifyListener((ModifyListener)this.textListener_);
        this.projectWidget_ = new ProjectSelectionWidget();
        this.projectWidget_.addControls((Composite)serverGroup, statusListener);
        this.clientWidget_ = new ClientRuntimeSelectionWidget();
        this.clientWidget_.addControls(root, statusListener);
        Point size = root.computeSize(-1, -1);
        scroller.setMinSize(size);
        root.setSize(size);
        scroller.setLayoutData((Object)new GridData(1808));
        return this;
    }

    public void setGenerateProxy(Boolean value) {
        this.clientWidget_.setVisible(value.booleanValue());
        this.isClientWidgetVisible_ = value;
    }

    public TypeRuntimeServer getServiceTypeRuntimeServer() {
        return this.runtimeWidget_.getTypeRuntimeServer();
    }

    public void setServiceTypeRuntimeServer(TypeRuntimeServer ids) {
        this.runtimeWidget_.removeModifyListener((ModifyListener)this.textListener_);
        this.runtimeWidget_.setTypeRuntimeServer(ids);
        this.projectWidget_.setTypeRuntimeServer(ids);
        this.projectWidget_.refreshProjectItems();
        this.runtimeWidget_.addModifyListener((ModifyListener)this.textListener_);
    }

    public TypeRuntimeServer getClientTypeRuntimeServer() {
        return this.clientWidget_.getClientTypeRuntimeServer();
    }

    public void setClientTypeRuntimeServer(TypeRuntimeServer ids) {
        this.clientWidget_.setClientTypeRuntimeServer(ids);
    }

    public void setServiceRuntimeId(String id) {
    }

    public String getServiceRuntimeId() {
        String projectName = this.projectWidget_.getProjectName();
        String templateId = this.projectWidget_.getComponentType();
        return WebServiceRuntimeExtensionUtils2.getServiceRuntimeId((TypeRuntimeServer)this.runtimeWidget_.getTypeRuntimeServer(), (String)projectName, (String)templateId);
    }

    public void setClientRuntimeId(String id) {
    }

    public String getClientRuntimeId() {
        return this.clientWidget_.getClientRuntimeId();
    }

    public boolean getServiceNeedEAR() {
        return this.projectWidget_.getNeedEAR();
    }

    public void setServiceNeedEAR(boolean b) {
        this.projectWidget_.setNeedEAR(b);
    }

    public boolean getClientNeedEAR() {
        return this.clientWidget_.getClientNeedEAR();
    }

    public void setClientNeedEAR(boolean b) {
        this.clientWidget_.setClientNeedEAR(b);
    }

    public String getServiceComponentType() {
        return this.projectWidget_.getComponentType();
    }

    public void setServiceComponentType(String type) {
        this.projectWidget_.setComponentType(type);
    }

    public String getClientComponentType() {
        return this.clientWidget_.getClientComponentType();
    }

    public void setClientComponentType(String type) {
        this.clientWidget_.setClientComponentType(type);
    }

    public String getServiceProjectName() {
        return this.projectWidget_.getProjectName();
    }

    public void setServiceProjectName(String name) {
        this.projectWidget_.setProjectName(name);
    }

    public String getServiceEarProjectName() {
        return this.projectWidget_.getEarProjectName();
    }

    public void setServiceEarProjectName(String name) {
        this.projectWidget_.setEarProjectName(name);
    }

    public String getClientProjectName() {
        return this.clientWidget_.getClientProjectName();
    }

    public void setClientProjectName(String name) {
        this.clientWidget_.setClientProjectName(name);
    }

    public String getClientEarProjectName() {
        return this.clientWidget_.getClientEarProjectName();
    }

    public void setClientEarProjectName(String name) {
        this.clientWidget_.setClientEarProjectName(name);
    }

    public void setInstallService(boolean b) {
        this.runtimeWidget_.setInstall(b);
    }

    public void setInstallClient(boolean b) {
        this.clientWidget_.setInstallClient(b);
    }

    public IStatus getStatus() {
        IStatus serviceStatus = this.runtimeWidget_.getStatus();
        IStatus projectStatus = this.projectWidget_.getStatus();
        IStatus clientStatus = this.clientWidget_.getStatus();
        IStatus finalStatus = Status.OK_STATUS;
        if (serviceStatus.getSeverity() == 4) {
            finalStatus = serviceStatus;
        } else if (clientStatus.getSeverity() == 4) {
            if (this.isClientWidgetVisible_) {
                finalStatus = clientStatus;
            }
        } else if (projectStatus.getSeverity() == 4) {
            finalStatus = projectStatus;
        }
        String projectName = this.projectWidget_.getProjectName();
        if (projectName != null && projectName.length() > 0) {
            ValidationUtils valUtils = new ValidationUtils();
            IProject project = ProjectUtilities.getProject((String)projectName);
            String typeId = this.getServiceTypeRuntimeServer().getTypeId();
            String runtimeId = this.getServiceTypeRuntimeServer().getRuntimeId();
            String serverFactoryId = this.getServiceTypeRuntimeServer().getServerId();
            if (project.exists()) {
                if (!WebServiceRuntimeExtensionUtils2.doesServiceTypeAndRuntimeSupportProject((String)typeId, (String)runtimeId, (String)projectName)) {
                    String runtimeLabel = WebServiceRuntimeExtensionUtils2.getRuntimeLabelById((String)runtimeId);
                    finalStatus = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_SERVICE_RUNTIME_DOES_NOT_SUPPORT_PROJECT, (Object[])new String[]{runtimeLabel, projectName}));
                }
                if (serverFactoryId != null && serverFactoryId.length() > 0 && !valUtils.doesServerSupportProject(serverFactoryId, projectName)) {
                    String serverLabel = WebServiceRuntimeExtensionUtils2.getServerLabelById((String)serverFactoryId);
                    finalStatus = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_SERVICE_SERVER_DOES_NOT_SUPPORT_PROJECT, (Object[])new String[]{serverLabel, projectName}));
                }
            } else {
                String templateId = this.getServiceComponentType();
                if (templateId != null && templateId.length() > 0) {
                    String templateLabel;
                    if (!WebServiceRuntimeExtensionUtils2.doesServiceTypeAndRuntimeSupportTemplate((String)typeId, (String)runtimeId, (String)templateId)) {
                        String runtimeLabel = WebServiceRuntimeExtensionUtils2.getRuntimeLabelById((String)runtimeId);
                        templateLabel = FacetUtils.getTemplateLabelById((String)templateId);
                        finalStatus = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_SERVICE_RUNTIME_DOES_NOT_SUPPORT_TEMPLATE, (Object[])new String[]{runtimeLabel, templateLabel}));
                    }
                    if (serverFactoryId != null && serverFactoryId.length() > 0 && !valUtils.doesServerSupportTemplate(serverFactoryId, templateId)) {
                        String serverLabel = WebServiceRuntimeExtensionUtils2.getServerLabelById((String)serverFactoryId);
                        templateLabel = FacetUtils.getTemplateLabelById((String)templateId);
                        finalStatus = StatusUtils.errorStatus((String)NLS.bind((String)ConsumptionUIMessages.MSG_SERVICE_SERVER_DOES_NOT_SUPPORT_TEMPLATE, (Object[])new String[]{serverLabel, templateLabel}));
                    }
                }
            }
        }
        if (this.isClientWidgetVisible_) {
            String clientEARName = this.clientWidget_.getClientEarProjectName();
            String clientProjName = this.clientWidget_.getClientProjectName();
            String serviceProjName = this.projectWidget_.getProjectName();
            String serviceEarName = this.projectWidget_.getEarProjectName();
            String warning_msg = this.getEARProjectWarningMessage(serviceEarName, clientEARName);
            if (clientProjName != null && serviceProjName != null && clientProjName.equalsIgnoreCase(serviceProjName)) {
                String error_msg = ConsumptionUIMessages.MSG_SAME_CLIENT_AND_SERVICE_PROJECTS;
                finalStatus = StatusUtils.errorStatus((String)error_msg);
            }
            if (warning_msg != null && finalStatus.getSeverity() != 4) {
                return StatusUtils.warningStatus((String)warning_msg);
            }
        }
        if (finalStatus.getSeverity() != 4) {
            if (serviceStatus.getSeverity() == 2) {
                finalStatus = serviceStatus;
            } else if (clientStatus.getSeverity() == 2) {
                finalStatus = serviceStatus;
            }
        }
        return finalStatus;
    }

    private void createMessageText(Composite parent, String value) {
        Text messageText = new Text(parent, 74);
        GridData gridData = new GridData(1808);
        gridData.horizontalIndent = 10;
        messageText.setLayoutData((Object)gridData);
        messageText.setText(value);
    }

    private String getEARProjectWarningMessage(String serviceEARName, String clientEARName) {
        if (serviceEARName != null && clientEARName != null && clientEARName.equalsIgnoreCase(serviceEARName) && clientEARName.length() > 0) {
            return NLS.bind((String)ConsumptionUIMessages.MSG_SAME_CLIENT_AND_SERVICE_EARS, (Object[])new String[]{"EAR"});
        }
        return null;
    }

    private class TextModifyListener
    implements ModifyListener {
        private TextModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            if (ServerRuntimeSelectionWidget.this.clientWidget_.isVisible()) {
                TypeRuntimeServer serviceIds = ServerRuntimeSelectionWidget.this.runtimeWidget_.getTypeRuntimeServer();
                TypeRuntimeServer clientIds = ServerRuntimeSelectionWidget.this.clientWidget_.getClientTypeRuntimeServer();
                clientIds.setRuntimeId(serviceIds.getRuntimeId());
                clientIds.setServerId(serviceIds.getServerId());
                clientIds.setServerInstanceId(serviceIds.getServerInstanceId());
                ServerRuntimeSelectionWidget.this.clientWidget_.setClientTypeRuntimeServer(clientIds);
            }
            ServerRuntimeSelectionWidget.this.projectWidget_.setTypeRuntimeServer(ServerRuntimeSelectionWidget.this.runtimeWidget_.getTypeRuntimeServer());
            ServerRuntimeSelectionWidget.this.projectWidget_.refreshProjectItems();
        }
    }
}

