/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.componentcore.ModuleCoreNature;
import org.eclipse.wst.common.componentcore.datamodel.ProjectMigratorDataModelProvider;
import org.eclipse.wst.common.componentcore.internal.ModulecorePlugin;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.internal.datamodel.IWorkspaceRunnableWithStatus;
import org.eclipse.wst.common.internal.emfworkbench.WorkbenchResourceHelper;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.osgi.framework.Bundle;

public class ModuleMigratorManager {
    private static HashMap managerCache = new HashMap();
    private static HashSet migrated = new HashSet();
    private boolean migrating;
    private HashSet moved = new HashSet();

    public static ModuleMigratorManager getManager(IProject proj) {
        ModuleMigratorManager manager = (ModuleMigratorManager)managerCache.get(proj);
        if (manager == null) {
            manager = new ModuleMigratorManager();
            managerCache.put(proj, manager);
        }
        return manager;
    }

    private void migrateComponentsIfNecessary(IProject project, boolean multiComps) {
        if (multiComps) {
            this.setupAndMigrateComponentProject(project);
        } else {
            IProject[] projects = WorkbenchResourceHelper.getWorkspace().getRoot().getProjects();
            int i = 0;
            while (i < projects.length) {
                IProject proj = projects[i];
                this.setupAndMigrateComponentProject(proj);
                ++i;
            }
        }
    }

    /*
     * Exception decompiling
     */
    private IStatus validateEdit(IResource aRes) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 214->217)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setupAndMigrateComponentProject(IProject proj) {
        migrated.add(proj);
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new ProjectMigratorDataModelProvider());
        dm.setStringProperty("IProjectMigratorDataModelProperties.PROJECT_NAME", proj.getName());
        try {
            dm.getDefaultOperation().execute(null, null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    public synchronized void migrateOldMetaData(IProject aProject, final boolean multiComps) throws CoreException {
        this.migrating = true;
        IWorkspaceRunnableWithStatus workspaceRunnable = new IWorkspaceRunnableWithStatus((IAdaptable)aProject){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor pm) throws CoreException {
                IProject aProj = (IProject)this.getInfo();
                try {
                    if (aProj.isAccessible() && ModuleCoreNature.isFlexibleProject(aProj)) {
                        if (aProj.findMember(".wtpmodules") != null) {
                            if (!ModuleMigratorManager.this.moved.contains(aProj)) {
                                ModuleMigratorManager.this.moveOldMetaDataFile();
                            }
                        } else {
                            ModuleMigratorManager.this.moved.add(aProj);
                        }
                        if (this.needsComponentMigration(aProj, multiComps)) {
                            ModuleMigratorManager.this.migrateComponentsIfNecessary(aProj, multiComps);
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    ModuleMigratorManager.this.migrating = false;
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                }
                ModuleMigratorManager.this.migrating = false;
            }

            private boolean needsComponentMigration(IProject aProj, boolean multiComps2) throws CoreException {
                boolean needs;
                boolean bl = needs = !migrated.contains(aProj);
                if (multiComps2) {
                    return needs && multiComps2;
                }
                return aProj.findMember(".settings/.component") != null && ProjectFacetsManager.create((IProject)aProj) == null && needs;
            }
        };
        ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)workspaceRunnable, null, 1, null);
    }

    private void moveMetaDataFile(IProject project) {
        IResource oldfile = project.findMember(".wtpmodules");
        if (oldfile != null && oldfile.exists()) {
            try {
                if (!this.validateEdit((IResource)((IFile)oldfile)).isOK()) {
                    return;
                }
                IFolder settingsFolder = project.getFolder(".settings");
                if (!settingsFolder.exists()) {
                    settingsFolder.create(true, true, null);
                }
                oldfile.move((IPath)new Path(".settings/.component"), true, null);
            }
            catch (CoreException e) {
                Platform.getLog((Bundle)ModulecorePlugin.getDefault().getBundle()).log((IStatus)new Status(4, "org.eclipse.wst.common.modulecore", 4, e.getMessage(), (Throwable)e));
            }
        }
    }

    private void moveOldMetaDataFile() {
        try {
            IProject[] projects = WorkbenchResourceHelper.getWorkspace().getRoot().getProjects();
            int i = 0;
            while (i < projects.length) {
                IFolder depFolder;
                IProject project = projects[i];
                if (!this.moved.contains(project)) {
                    this.moveMetaDataFile(project);
                }
                if ((depFolder = project.getFolder(".deployables")).exists()) {
                    if (!this.validateEdit((IResource)depFolder).isOK()) {
                        return;
                    }
                    depFolder.delete(true, null);
                }
                project.refreshLocal(2, null);
                this.moved.add(project);
                ++i;
            }
        }
        catch (Exception exception) {}
    }

    protected boolean isMigrating() {
        return this.migrating;
    }

    private List collectFiles(IResource[] members, List result) throws CoreException {
        int i = 0;
        while (i < members.length) {
            IResource res = members[i];
            if (res instanceof IFolder) {
                this.collectFiles(((IFolder)res).members(), result);
            } else if (res instanceof IFile) {
                result.add(res);
            }
            ++i;
        }
        return result;
    }

    private IFile[] getAllContainerFiles(IContainer container) {
        List result = new ArrayList();
        if (container == null) {
            return new IFile[0];
        }
        try {
            result = this.collectFiles(container.members(), result);
        }
        catch (CoreException coreException) {}
        return result.toArray(new IFile[result.size()]);
    }
}

