/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.navigator.internal.views;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.wst.common.navigator.internal.provisional.views.CommonNavigator;
import org.eclipse.wst.common.navigator.internal.provisional.views.CommonViewer;
import org.eclipse.wst.common.navigator.internal.views.NavigatorPlugin;
import org.eclipse.wst.common.navigator.internal.views.actions.CollapseAllAction;
import org.eclipse.wst.common.navigator.internal.views.actions.LinkEditorAction;
import org.eclipse.wst.common.navigator.internal.views.filters.SelectFiltersAction;

public class CommonNavigatorActionGroup
extends ActionGroup {
    private LinkEditorAction toggleLinkingAction;
    private CollapseAllAction collapseAllAction;
    private SelectFiltersAction selectFiltersAction;
    private final CommonViewer commonViewer;
    private CommonNavigator commonNavigator;

    public CommonNavigatorActionGroup(CommonNavigator aNavigator, CommonViewer aViewer) {
        this.commonNavigator = aNavigator;
        this.commonViewer = aViewer;
        this.makeActions();
    }

    protected final ImageDescriptor getImageDescriptor(String relativePath) {
        String iconPath = "icons/full/";
        try {
            NavigatorPlugin plugin = NavigatorPlugin.getDefault();
            URL installURL = plugin.getDescriptor().getInstallURL();
            URL url = new URL(installURL, String.valueOf(iconPath) + relativePath);
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private void makeActions() {
        this.toggleLinkingAction = new LinkEditorAction(this.commonNavigator, this.commonViewer);
        ImageDescriptor syncIcon = this.getImageDescriptor("elcl16/synced.gif");
        this.toggleLinkingAction.setImageDescriptor(syncIcon);
        this.toggleLinkingAction.setHoverImageDescriptor(syncIcon);
        this.collapseAllAction = new CollapseAllAction(this.commonViewer);
        ImageDescriptor collapseAllIcon = this.getImageDescriptor("elcl16/collapseall.gif");
        this.collapseAllAction.setImageDescriptor(collapseAllIcon);
        this.collapseAllAction.setHoverImageDescriptor(collapseAllIcon);
        this.selectFiltersAction = new SelectFiltersAction(this.commonViewer);
        ImageDescriptor selectFiltersIcon = this.getImageDescriptor("elcl16/filter_ps.gif");
        this.selectFiltersAction.setImageDescriptor(selectFiltersIcon);
        this.selectFiltersAction.setHoverImageDescriptor(selectFiltersIcon);
    }

    public void fillActionBars(IActionBars theActionBars) {
        IMenuManager menu = theActionBars.getMenuManager();
        menu.add((IAction)this.selectFiltersAction);
        menu.add((IAction)this.toggleLinkingAction);
        theActionBars.getToolBarManager().add((IAction)this.collapseAllAction);
        theActionBars.getToolBarManager().add((IAction)this.toggleLinkingAction);
        theActionBars.updateActionBars();
    }
}

