/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.navigator.internal.views.filters;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.wst.common.navigator.internal.provisional.views.NavigatorContentService;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentDescriptor;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentDescriptorRegistry;
import org.eclipse.wst.common.navigator.internal.views.filters.ExtensionFilterDescriptor;
import org.eclipse.wst.common.navigator.internal.views.filters.ExtensionFilterRegistryManager;
import org.eclipse.wst.common.navigator.internal.views.filters.ExtensionFilterViewerRegistry;

public class CommonFilterContentProvider
implements IStructuredContentProvider {
    private static final NavigatorContentDescriptorRegistry CONTENT_DESCRIPTOR_REGISTRY = NavigatorContentDescriptorRegistry.getInstance();
    private NavigatorContentService contentService;

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof NavigatorContentService) {
            this.contentService = (NavigatorContentService)newInput;
        }
    }

    public Object[] getElements(Object inputElement) {
        ExtensionFilterViewerRegistry filterRegistry = ExtensionFilterRegistryManager.getInstance().getViewerRegistry(this.contentService.getViewerId());
        ArrayList<ExtensionFilterDescriptor> results = new ArrayList<ExtensionFilterDescriptor>();
        NavigatorContentDescriptor[] descriptors = CONTENT_DESCRIPTOR_REGISTRY.getAllContentDescriptors();
        int i = 0;
        while (i < descriptors.length) {
            results.addAll(Arrays.asList(filterRegistry.getAllDescriptors(descriptors[i].getId())));
            ++i;
        }
        return results.toArray();
    }

    public void dispose() {
    }
}

