/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.navigator.internal.groups;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.wst.common.navigator.internal.groups.NavigatorGroupContentProvider;
import org.eclipse.wst.common.navigator.internal.plugin.WorkbenchNavigatorMessages;
import org.eclipse.wst.common.navigator.internal.plugin.WorkbenchNavigatorPlugin;
import org.eclipse.wst.common.navigator.internal.provisional.views.NavigatorContentService;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentDescriptor;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentDescriptorRegistry;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentProvider;

public class ToggleGroupingAction
extends Action
implements IAction {
    private static final NavigatorContentDescriptorRegistry CONTENT_DESCRIPTOR_REGISTRY = NavigatorContentDescriptorRegistry.getInstance();
    private final StructuredViewer structuredViewer;
    private final NavigatorContentService contentService;
    private NavigatorGroupContentProvider groupProvider = null;
    private boolean isGroupingEnabled;

    public ToggleGroupingAction(StructuredViewer aViewer, NavigatorContentService aContentService) {
        super(WorkbenchNavigatorMessages._9_UI_, 1);
        this.setToolTipText(WorkbenchNavigatorMessages._10_UI_);
        ImageDescriptor icon = this.getImageDescriptor("icons/shownavigatorgroups_obj.gif");
        this.setHoverImageDescriptor(icon);
        this.setImageDescriptor(icon);
        this.structuredViewer = aViewer;
        this.contentService = aContentService;
        this.isGroupingEnabled = this.getGroupProvider().isGroupingEnabled();
        this.setChecked(this.isGroupingEnabled);
    }

    protected ImageDescriptor getImageDescriptor(String relativePath) {
        try {
            WorkbenchNavigatorPlugin plugin = WorkbenchNavigatorPlugin.getDefault();
            URL installURL = plugin.getDescriptor().getInstallURL();
            URL url = new URL(installURL, relativePath);
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (MalformedURLException malformedURLException) {
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    public void setGroupingEnabled(boolean toEnableGrouping) {
        if (toEnableGrouping != this.isGroupingEnabled) {
            this.isGroupingEnabled = toEnableGrouping;
            if (this.getGroupProvider() != null) {
                this.getGroupProvider().setGroupingEnabled(this.isGroupingEnabled);
            }
            this.structuredViewer.refresh();
        }
    }

    public boolean isGroupingEnabled() {
        return this.isGroupingEnabled;
    }

    public void run() {
        this.setGroupingEnabled(!this.isGroupingEnabled);
    }

    private NavigatorGroupContentProvider getGroupProvider() {
        NavigatorContentDescriptor groupDescriptor;
        if (this.groupProvider == null && (groupDescriptor = CONTENT_DESCRIPTOR_REGISTRY.getContentDescriptor("org.eclipse.wst.common.navigator.internal.plugin.root")) != null) {
            NavigatorContentProvider delegateContentProvider = (NavigatorContentProvider)this.contentService.getDescriptorInstance(groupDescriptor).getContentProvider();
            this.groupProvider = (NavigatorGroupContentProvider)delegateContentProvider.getDelegateContentProvider();
        }
        return this.groupProvider;
    }
}

