/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.ui.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.wst.common.project.facet.core.IListener;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponent;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntimeComponentType;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.common.project.facet.ui.IDecorationsProvider;
import org.eclipse.wst.common.project.facet.ui.IRuntimeComponentLabelProvider;
import org.eclipse.wst.common.project.facet.ui.internal.FacetsSelectionPanel;

public final class RuntimesPanel
extends Composite {
    private final Label runtimesLabel;
    private final CheckboxTableViewer runtimes;
    private final Button makePreferredButton;
    private final Label runtimeComponentsLabel;
    private final TableViewer runtimeComponents;
    private final FacetsSelectionPanel facetsSelectionPanel;
    private final Map facetFilters;
    private final Set filters;
    private IRuntime boundRuntime;
    private final Set listeners;

    public RuntimesPanel(Composite parent, int style, FacetsSelectionPanel facetsSelectionPanel) {
        super(parent, style);
        this.facetsSelectionPanel = facetsSelectionPanel;
        this.facetFilters = new HashMap();
        this.filters = new HashSet();
        this.listeners = new HashSet();
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.runtimesLabel = new Label((Composite)this, 0);
        this.runtimesLabel.setText(Resources.runtimesLabel);
        this.runtimesLabel.setLayoutData((Object)RuntimesPanel.gdhfill());
        this.runtimes = CheckboxTableViewer.newCheckList((Composite)this, (int)2048);
        this.runtimes.getTable().setLayoutData((Object)RuntimesPanel.gdfill());
        this.runtimes.setContentProvider((IContentProvider)new ContentProvider());
        this.runtimes.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.runtimes.setSorter((ViewerSorter)new Sorter());
        this.runtimes.setInput(new Object());
        this.runtimes.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                RuntimesPanel.this.handleRuntimeSelectionChanged();
            }
        });
        this.runtimes.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent e) {
                RuntimesPanel.this.handleCheckStateChanged(e);
            }
        });
        this.makePreferredButton = new Button((Composite)this, 8);
        this.makePreferredButton.setText(Resources.makePreferredLabel);
        GridData gd = RuntimesPanel.halign(new GridData(), 3);
        gd = RuntimesPanel.whint(gd, RuntimesPanel.getPreferredWidth((Control)this.makePreferredButton) + 15);
        this.makePreferredButton.setLayoutData((Object)gd);
        this.makePreferredButton.setEnabled(false);
        this.makePreferredButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RuntimesPanel.this.handleMakePreferred();
            }
        });
        this.runtimeComponentsLabel = new Label((Composite)this, 0);
        this.runtimeComponentsLabel.setText(Resources.runtimeCompositionLabel);
        this.runtimeComponentsLabel.setLayoutData((Object)RuntimesPanel.gdhfill());
        this.runtimeComponents = new TableViewer((Composite)this, 2048);
        this.runtimeComponents.getTable().setLayoutData((Object)RuntimesPanel.hhint(RuntimesPanel.gdhfill(), 50));
        this.runtimeComponents.setContentProvider((IContentProvider)new RuntimeComponentsContentProvider());
        this.runtimeComponents.setLabelProvider((IBaseLabelProvider)new RuntimeComponentsLabelProvider());
        this.runtimeComponents.getTable().setBackground(new Color(null, 255, 255, 206));
        final IListener listener = new IListener(){

            public void handle() {
                RuntimesPanel.this.refresh();
            }
        };
        RuntimeManager.addRuntimeListener((IListener)listener);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                RuntimeManager.removeRuntimeListener((IListener)listener);
            }
        });
    }

    public IRuntime getRuntime() {
        return this.boundRuntime;
    }

    public void setRuntime(IRuntime runtime) {
        IRuntime old = this.boundRuntime;
        if (old != null) {
            this.removeProjectFacetsFilter(old);
            this.boundRuntime = null;
            this.runtimes.update((Object)old, null);
        }
        this.boundRuntime = runtime;
        if (runtime != null) {
            this.addProjectFacetsFilter(runtime);
            this.runtimes.update((Object)runtime, null);
        }
        this.notifyRuntimeListeners();
    }

    public void addRuntimeListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeRuntimeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    private void notifyRuntimeListeners() {
        Iterator itr = this.listeners.iterator();
        while (itr.hasNext()) {
            ((Listener)itr.next()).handleEvent(null);
        }
    }

    public void addFilter(IFilter filter) {
        this.filters.add(filter);
        this.refresh();
    }

    public void removeFilter(IFilter filter) {
        this.filters.remove(filter);
        this.refresh();
    }

    private boolean isFilteredOut(IRuntime r) {
        Iterator itr = this.filters.iterator();
        while (itr.hasNext()) {
            IFilter filter = (IFilter)itr.next();
            if (filter.check(r)) continue;
            return true;
        }
        return false;
    }

    public void refresh() {
        this.runtimes.refresh();
        Iterator itr = RuntimeManager.getRuntimes().iterator();
        while (itr.hasNext()) {
            IRuntime r = (IRuntime)itr.next();
            if (this.isFilteredOut(r)) {
                this.runtimes.setGrayed((Object)r, true);
                continue;
            }
            this.runtimes.setGrayed((Object)r, false);
        }
    }

    private void addProjectFacetsFilter(IRuntime r) {
        if (!this.facetFilters.containsKey(r)) {
            SupportedFacetsFilter filter = new SupportedFacetsFilter(r);
            this.facetFilters.put(r, filter);
            this.facetsSelectionPanel.addFilter(filter);
            if (!this.runtimes.getChecked((Object)r)) {
                this.runtimes.setChecked((Object)r, true);
            }
        }
    }

    private void removeProjectFacetsFilter(IRuntime r) {
        FacetsSelectionPanel.IFilter filter = (FacetsSelectionPanel.IFilter)this.facetFilters.remove(r);
        this.facetsSelectionPanel.removeFilter(filter);
        if (this.runtimes.getChecked((Object)r)) {
            this.runtimes.setChecked((Object)r, false);
        }
    }

    private void handleCheckStateChanged(CheckStateChangedEvent e) {
        IRuntime runtime = (IRuntime)e.getElement();
        if (this.isFilteredOut(runtime) && e.getChecked()) {
            this.runtimes.setChecked((Object)runtime, false);
            return;
        }
        if (this.facetFilters.containsKey(runtime)) {
            this.removeProjectFacetsFilter(runtime);
            if (runtime == this.boundRuntime) {
                if (this.facetFilters.isEmpty()) {
                    this.boundRuntime = null;
                } else {
                    IRuntime r;
                    this.boundRuntime = r = (IRuntime)this.facetFilters.keySet().iterator().next();
                    this.runtimes.update((Object)r, null);
                    IRuntime selection = this.getSelection();
                    if (selection != null && selection.equals(r)) {
                        this.makePreferredButton.setEnabled(false);
                    }
                }
                this.runtimes.update((Object)runtime, null);
                this.notifyRuntimeListeners();
            }
        } else {
            this.addProjectFacetsFilter(runtime);
            if (this.boundRuntime == null) {
                this.boundRuntime = runtime;
                this.runtimes.update((Object)runtime, null);
                this.notifyRuntimeListeners();
            }
        }
    }

    private void handleRuntimeSelectionChanged() {
        IRuntime r = this.getSelection();
        if (r != null) {
            if (this.runtimeComponents.getInput() == null || !this.runtimeComponents.getInput().equals(r)) {
                this.runtimeComponents.setInput((Object)r);
            }
            if (this.runtimes.getChecked((Object)r) && this.boundRuntime != null && !this.boundRuntime.equals(r) && !this.isFilteredOut(r)) {
                this.makePreferredButton.setEnabled(true);
            } else {
                this.makePreferredButton.setEnabled(false);
            }
        }
    }

    private void handleMakePreferred() {
        IRuntime old = this.boundRuntime;
        this.boundRuntime = this.getSelection();
        this.runtimes.refresh((Object)old);
        this.runtimes.refresh((Object)this.boundRuntime);
        this.notifyRuntimeListeners();
    }

    private IRuntime getSelection() {
        IStructuredSelection ssel = (IStructuredSelection)this.runtimes.getSelection();
        if (ssel.isEmpty()) {
            return null;
        }
        return (IRuntime)ssel.getFirstElement();
    }

    private static final GridData gdfill() {
        return new GridData(4, 4, true, true);
    }

    private static final GridData gdhfill() {
        return new GridData(768);
    }

    private static final GridData whint(GridData gd, int width) {
        gd.widthHint = width;
        return gd;
    }

    private static final GridData hhint(GridData gd, int height) {
        gd.heightHint = height;
        return gd;
    }

    private static final GridData halign(GridData gd, int alignment) {
        gd.horizontalAlignment = alignment;
        return gd;
    }

    private static final int getPreferredWidth(Control control) {
        return control.computeSize((int)-1, (int)-1).x;
    }

    public static interface IFilter {
        public boolean check(IRuntime var1);
    }

    private final class ContentProvider
    implements IStructuredContentProvider {
        private ContentProvider() {
        }

        public Object[] getElements(Object element) {
            return RuntimeManager.getRuntimes().toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldObject, Object newObject) {
        }
    }

    private final class LabelProvider
    implements ILabelProvider,
    IFontProvider,
    IColorProvider {
        private final Color COLOR_GREY = new Color(null, 160, 160, 164);
        private final ImageRegistry imageRegistry = new ImageRegistry();
        private final Font boldFont;
        static /* synthetic */ Class class$0;

        public LabelProvider() {
            FontData system = Display.getCurrent().getSystemFont().getFontData()[0];
            FontData bold = new FontData(system.getName(), system.getHeight(), 1);
            this.boldFont = new Font((Device)Display.getCurrent(), bold);
        }

        public String getText(Object element) {
            return ((IRuntime)element).getName();
        }

        public Image getImage(Object element) {
            IRuntime r = (IRuntime)element;
            IRuntimeComponent rc = (IRuntimeComponent)r.getRuntimeComponents().get(0);
            IRuntimeComponentType rct = rc.getRuntimeComponentType();
            Image image = this.imageRegistry.get(rct.getId());
            if (image == null) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.wst.common.project.facet.ui.IDecorationsProvider");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                IDecorationsProvider decprov = (IDecorationsProvider)rct.getAdapter((Class)clazz);
                this.imageRegistry.put(rct.getId(), decprov.getIcon());
                image = this.imageRegistry.get(rct.getId());
            }
            if (RuntimesPanel.this.isFilteredOut(r)) {
                String greyedId = String.valueOf(rct.getId()) + "##greyed##";
                Image greyed = this.imageRegistry.get(greyedId);
                if (greyed == null) {
                    greyed = new Image(null, image, 2);
                    this.imageRegistry.put(greyedId, greyed);
                }
                return greyed;
            }
            return image;
        }

        public Font getFont(Object element) {
            if (RuntimesPanel.this.boundRuntime != null && RuntimesPanel.this.boundRuntime.equals(element)) {
                return this.boldFont;
            }
            return null;
        }

        public Color getForeground(Object element) {
            if (RuntimesPanel.this.isFilteredOut((IRuntime)element)) {
                return this.COLOR_GREY;
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }

        public void dispose() {
            this.imageRegistry.dispose();
            this.boldFont.dispose();
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private final class Sorter
    extends ViewerSorter {
        private Sorter() {
        }

        public int compare(Viewer viewer, Object a, Object b) {
            IRuntime r1 = (IRuntime)a;
            boolean r1fo = RuntimesPanel.this.isFilteredOut(r1);
            IRuntime r2 = (IRuntime)b;
            boolean r2fo = RuntimesPanel.this.isFilteredOut(r2);
            if (r1fo && !r2fo) {
                return 1;
            }
            if (!r1fo && r2fo) {
                return -1;
            }
            return r1.getName().compareToIgnoreCase(r2.getName());
        }
    }

    private final class RuntimeComponentsContentProvider
    implements IStructuredContentProvider {
        private RuntimeComponentsContentProvider() {
        }

        public Object[] getElements(Object element) {
            IRuntime r = (IRuntime)element;
            return r.getRuntimeComponents().toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldObject, Object newObject) {
        }
    }

    private final class RuntimeComponentsLabelProvider
    implements ILabelProvider {
        private final ImageRegistry imageRegistry = new ImageRegistry();
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;

        private RuntimeComponentsLabelProvider() {
        }

        public String getText(Object element) {
            IRuntimeComponentLabelProvider provider;
            IRuntimeComponent comp = (IRuntimeComponent)element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.common.project.facet.ui.IRuntimeComponentLabelProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((provider = (IRuntimeComponentLabelProvider)comp.getAdapter((Class)clazz)) == null) {
                StringBuffer label = new StringBuffer();
                label.append(comp.getRuntimeComponentType().getId());
                label.append(' ');
                label.append(comp.getRuntimeComponentVersion().getVersionString());
                return label.toString();
            }
            return provider.getLabel();
        }

        public Image getImage(Object element) {
            IRuntimeComponent rc = (IRuntimeComponent)element;
            IRuntimeComponentType rct = rc.getRuntimeComponentType();
            Image image = this.imageRegistry.get(rct.getId());
            if (image == null) {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.wst.common.project.facet.ui.IDecorationsProvider");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                IDecorationsProvider decprov = (IDecorationsProvider)rct.getAdapter((Class)clazz);
                this.imageRegistry.put(rct.getId(), decprov.getIcon());
                image = this.imageRegistry.get(rct.getId());
            }
            return image;
        }

        public void dispose() {
            this.imageRegistry.dispose();
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private static final class SupportedFacetsFilter
    implements FacetsSelectionPanel.IFilter {
        private final IRuntime runtime;

        public SupportedFacetsFilter(IRuntime runtime) {
            this.runtime = runtime;
        }

        public boolean check(IProjectFacetVersion fv) {
            return this.runtime.supports(fv);
        }
    }

    private static final class Resources
    extends NLS {
        public static String runtimesLabel;
        public static String runtimeCompositionLabel;
        public static String makePreferredLabel;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.common.project.facet.ui.internal.RuntimesPanel");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String string = clazz.getName();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.wst.common.project.facet.ui.internal.RuntimesPanel$Resources");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Resources.initializeMessages((String)string, (Class)clazz2);
        }

        private Resources() {
        }
    }
}

