/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.internal.core.rte.fe;

import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.wst.rdb.internal.core.containment.ContainmentServiceImpl;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinition;
import org.eclipse.wst.rdb.internal.core.definition.DatabaseDefinitionRegistryImpl;
import org.eclipse.wst.rdb.internal.models.sql.constraints.CheckConstraint;
import org.eclipse.wst.rdb.internal.models.sql.constraints.Constraint;
import org.eclipse.wst.rdb.internal.models.sql.constraints.ForeignKey;
import org.eclipse.wst.rdb.internal.models.sql.constraints.Index;
import org.eclipse.wst.rdb.internal.models.sql.constraints.IndexMember;
import org.eclipse.wst.rdb.internal.models.sql.constraints.PrimaryKey;
import org.eclipse.wst.rdb.internal.models.sql.constraints.ReferenceConstraint;
import org.eclipse.wst.rdb.internal.models.sql.constraints.TableConstraint;
import org.eclipse.wst.rdb.internal.models.sql.constraints.UniqueConstraint;
import org.eclipse.wst.rdb.internal.models.sql.datatypes.PredefinedDataType;
import org.eclipse.wst.rdb.internal.models.sql.datatypes.SQLDataType;
import org.eclipse.wst.rdb.internal.models.sql.datatypes.UserDefinedType;
import org.eclipse.wst.rdb.internal.models.sql.routines.Routine;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.internal.models.sql.schema.ReferentialActionType;
import org.eclipse.wst.rdb.internal.models.sql.schema.Schema;
import org.eclipse.wst.rdb.internal.models.sql.schema.Sequence;
import org.eclipse.wst.rdb.internal.models.sql.schema.TypedElement;
import org.eclipse.wst.rdb.internal.models.sql.statements.SQLStatement;
import org.eclipse.wst.rdb.internal.models.sql.tables.ActionGranularityType;
import org.eclipse.wst.rdb.internal.models.sql.tables.ActionTimeType;
import org.eclipse.wst.rdb.internal.models.sql.tables.BaseTable;
import org.eclipse.wst.rdb.internal.models.sql.tables.CheckType;
import org.eclipse.wst.rdb.internal.models.sql.tables.Column;
import org.eclipse.wst.rdb.internal.models.sql.tables.Table;
import org.eclipse.wst.rdb.internal.models.sql.tables.Trigger;
import org.eclipse.wst.rdb.internal.models.sql.tables.ViewTable;

public class GenericDdlBuilder {
    protected static final String NEWLINE = System.getProperty("line.separator");
    protected static final String EMPTY_STRING = "";
    protected static final String DOT = ".";
    protected static final String SPACE = " ";
    protected static final String COMMA = ",";
    protected static final String SINGLE_QUOTE = "'";
    protected static final String DOUBLE_QUOTE = "\"";
    protected static final String TAB = "\t";
    protected static final String LEFT_PARENTHESIS = "(";
    protected static final String RIGHT_PARENTHESIS = ")";
    protected static final String DROP = "DROP";
    protected static final String CREATE = "CREATE";
    protected static final String ALTER = "ALTER";
    protected static final String ADD = "ADD";
    protected static final String DELETE = "DELETE";
    protected static final String UPDATE = "UPDATE";
    protected static final String CASCADE = "CASCADE";
    protected static final String CASCADED = "CASCADED";
    protected static final String LOCAL = "LOCAL";
    protected static final String OPTION = "OPTION";
    protected static final String RESTRICT = "RESTRICT";
    protected static final String NULL = "NULL";
    protected static final String NOT = "NOT";
    protected static final String DEFAULT = "DEFAULT";
    protected static final String SET = "SET";
    protected static final String TRIGGER = "TRIGGER";
    protected static final String TABLE = "TABLE";
    protected static final String VIEW = "VIEW";
    protected static final String INDEX = "INDEX";
    protected static final String PROCEDURE = "PROCEDURE";
    protected static final String FUNCTION = "FUNCTION";
    protected static final String CONSTRAINT = "CONSTRAINT";
    protected static final String UNIQUE = "UNIQUE";
    protected static final String CHECK = "CHECK";
    protected static final String TYPE = "TYPE";
    protected static final String ON = "ON";
    protected static final String FOREIGN_KEY = "FOREIGN KEY";
    protected static final String REFERENCES = "REFERENCES";
    protected static final String PRIMARY_KEY = "PRIMARY KEY";
    protected static final String DEFERRABLE = "DEFERRABLE";
    protected static final String DEFERRED = "DEFERRED";
    protected static final String INITIALLY = "INITIALLY";
    protected static final String ALIAS = "ALIAS";
    protected static final String AS = "AS";
    protected static final String FOR = "FOR";
    protected static final String LONG = "LONG";
    protected static final String BLOB = "BLOB";
    protected static final String DBCLOB = "DBCLOB";
    protected static final String CLOB = "CLOB";
    protected static final String VARCHAR = "VARCHAR";
    protected static final String WITH = "WITH";
    protected static final String COMPARISONS = "COMPARISONS";
    protected static final String DATALINK = "DATALINK";
    protected static final String VARGRAPHIC = "VARGRAPHIC";
    protected static final String AFTER = "AFTER";
    protected static final String BEFORE = "BEFORE";
    protected static final String INSTEAD_OF = "INSTEAD OF";
    protected static final String INSERT = "INSERT";
    protected static final String NO = "NO";
    protected static final String OF = "OF";
    protected static final String REFERENCING = "REFERENCING";
    protected static final String NEW = "NEW";
    protected static final String OLD = "OLD";
    protected static final String NEW_TABLE = "NEW_TABLE";
    protected static final String OLD_TABLE = "OLD_TABLE";
    protected static final String EACH = "EACH";
    protected static final String ROW = "ROW";
    protected static final String STATEMENT = "STATEMENT";
    protected static final String WHEN = "WHEN";

    public String dropTrigger(Trigger trigger, boolean quoteIdentifiers, boolean qualifyNames) {
        return "DROP TRIGGER " + this.getName(trigger, quoteIdentifiers, qualifyNames);
    }

    public String dropView(ViewTable view, boolean quoteIdentifiers, boolean qualifyNames) {
        return "DROP VIEW " + this.getName((Table)view, quoteIdentifiers, qualifyNames);
    }

    public String dropTableConstraint(TableConstraint constraint, boolean quoteIdentifiers, boolean qualifyNames) {
        return "ALTER TABLE " + this.getName((Table)constraint.getBaseTable(), quoteIdentifiers, qualifyNames) + " DROP CONSTRAINT " + this.getName(constraint, quoteIdentifiers);
    }

    public String dropIndex(Index index, boolean quoteIdentifiers, boolean qualifyNames) {
        return "DROP INDEX " + this.getName(index, quoteIdentifiers, qualifyNames);
    }

    public String dropTable(BaseTable table, boolean quoteIdentifiers, boolean qualifyNames) {
        return "DROP TABLE " + this.getName((Table)table, quoteIdentifiers, qualifyNames);
    }

    public String createTable(BaseTable table, boolean quoteIdentifiers, boolean qualifyNames) {
        String statement = "CREATE TABLE " + this.getName((Table)table, quoteIdentifiers, qualifyNames) + SPACE + LEFT_PARENTHESIS + NEWLINE;
        Iterator it = table.getColumns().iterator();
        while (it.hasNext()) {
            Column column = (Column)it.next();
            statement = String.valueOf(statement) + "\t\t" + this.getColumnString(column, quoteIdentifiers);
            if (it.hasNext()) {
                statement = String.valueOf(statement) + COMMA;
            }
            statement = String.valueOf(statement) + NEWLINE;
        }
        statement = String.valueOf(statement) + "\t)";
        return statement;
    }

    public String alterTableAddColumn(Column column, boolean quoteIdentifiers, boolean qualifyNames) {
        Table table = column.getTable();
        if (table instanceof BaseTable) {
            String statement = "ALTER TABLE " + this.getName(table, quoteIdentifiers, qualifyNames) + " ADD COLUMN " + this.getColumnString(column, quoteIdentifiers);
            return statement;
        }
        return null;
    }

    public String createView(ViewTable view, boolean quoteIdentifiers, boolean qualifyNames) {
        String viewDefinition = "CREATE ";
        viewDefinition = String.valueOf(viewDefinition) + "VIEW " + this.getName((Table)view, quoteIdentifiers, qualifyNames) + SPACE;
        String columns = this.getViewColumnList(view);
        if (columns != null) {
            viewDefinition = String.valueOf(viewDefinition) + LEFT_PARENTHESIS + columns + RIGHT_PARENTHESIS + SPACE;
        }
        viewDefinition = String.valueOf(viewDefinition) + AS + NEWLINE;
        if (view.getQueryExpression() == null) {
            return null;
        }
        viewDefinition = String.valueOf(viewDefinition) + view.getQueryExpression().getSQL();
        CheckType checkType = view.getCheckType();
        if (checkType == CheckType.CASCADED_LITERAL) {
            viewDefinition = String.valueOf(viewDefinition) + NEWLINE + WITH + SPACE + CASCADED + SPACE + CHECK + SPACE + OPTION;
        } else if (checkType == CheckType.LOCAL_LITERAL) {
            viewDefinition = String.valueOf(viewDefinition) + NEWLINE + WITH + SPACE + LOCAL + SPACE + CHECK + SPACE + OPTION;
        }
        return viewDefinition;
    }

    public String createIndex(Index index, boolean quoteIdentifiers, boolean qualifyNames) {
        String statement = "CREATE ";
        if (index.isUnique()) {
            statement = String.valueOf(statement) + "UNIQUE ";
        }
        statement = String.valueOf(statement) + "INDEX " + this.getName(index, quoteIdentifiers, qualifyNames) + SPACE + ON + SPACE + this.getName(index.getTable(), quoteIdentifiers, qualifyNames) + SPACE + LEFT_PARENTHESIS + this.getIndexKeyColumns(index, quoteIdentifiers) + RIGHT_PARENTHESIS;
        return statement;
    }

    public String createTrigger(Trigger trigger, boolean quoteIdentifiers, boolean qualifyNames) {
        String statement = "CREATE TRIGGER " + this.getName(trigger, quoteIdentifiers, qualifyNames) + SPACE;
        ActionTimeType actionTime = trigger.getActionTime();
        if (actionTime == ActionTimeType.AFTER_LITERAL) {
            statement = String.valueOf(statement) + NEWLINE + TAB + AFTER;
        } else if (actionTime == ActionTimeType.BEFORE_LITERAL) {
            statement = String.valueOf(statement) + NEWLINE + TAB + BEFORE;
        } else if (actionTime == ActionTimeType.INSTEADOF_LITERAL) {
            statement = String.valueOf(statement) + NEWLINE + TAB + INSTEAD_OF;
        }
        statement = String.valueOf(statement) + SPACE;
        if (trigger.isDeleteType()) {
            statement = String.valueOf(statement) + DELETE;
        } else if (trigger.isInsertType()) {
            statement = String.valueOf(statement) + INSERT;
        } else if (trigger.isUpdateType()) {
            statement = String.valueOf(statement) + UPDATE;
            EList updateColumns = trigger.getTriggerColumn();
            if (!updateColumns.isEmpty()) {
                statement = String.valueOf(statement) + " OF ";
                Iterator it = updateColumns.iterator();
                while (it.hasNext()) {
                    Column column = (Column)it.next();
                    statement = String.valueOf(statement) + column.getName();
                    if (!it.hasNext()) continue;
                    statement = String.valueOf(statement) + ", ";
                }
            }
        }
        statement = String.valueOf(statement) + " ON " + this.getName(trigger.getSubjectTable(), quoteIdentifiers, qualifyNames) + NEWLINE;
        String newRow = trigger.getNewRow();
        String oldRow = trigger.getOldRow();
        trigger.getNewTable();
        trigger.getOldTable();
        if (newRow != null && newRow.length() != 0) {
            statement = String.valueOf(statement) + "\tREFERENCING NEW AS " + newRow + NEWLINE;
        }
        if (oldRow != null && oldRow.length() != 0) {
            statement = String.valueOf(statement) + "\tREFERENCING OLD AS " + oldRow + NEWLINE;
        }
        statement = trigger.getActionGranularity() == ActionGranularityType.ROW_LITERAL ? String.valueOf(statement) + "\tFOR EACH ROW" : String.valueOf(statement) + "\tFOR EACH STATEMENT";
        Iterator it = trigger.getActionStatement().iterator();
        while (it.hasNext()) {
            SQLStatement s = (SQLStatement)it.next();
            statement = String.valueOf(statement) + s.getSQL();
        }
        return statement;
    }

    public String addCheckConstraint(CheckConstraint constraint, boolean quoteIdentifiers, boolean qualifyNames) {
        BaseTable table = constraint.getBaseTable();
        String tableName = table.getName();
        String schemaName = table.getSchema().getName();
        if (quoteIdentifiers) {
            tableName = this.getDoubleQuotedString(tableName);
            schemaName = this.getDoubleQuotedString(schemaName);
        }
        if (qualifyNames) {
            tableName = String.valueOf(schemaName) + DOT + tableName;
        }
        return "ALTER TABLE " + this.getName((Table)constraint.getBaseTable(), quoteIdentifiers, qualifyNames) + SPACE + this.getAddCheckConstraintClause(constraint, quoteIdentifiers);
    }

    public String addUniqueConstraint(UniqueConstraint constraint, boolean quoteIdentifiers, boolean qualifyNames) {
        String statement = "ALTER TABLE " + this.getName((Table)constraint.getBaseTable(), quoteIdentifiers, qualifyNames) + SPACE;
        statement = String.valueOf(statement) + this.getAddUniqueConstraintClause(constraint, quoteIdentifiers);
        return statement;
    }

    public String addForeignKey(ForeignKey foreignKey, boolean quoteIdentifiers, boolean qualifyNames) {
        UniqueConstraint uniqueConstraint = foreignKey.getUniqueConstraint();
        Index index = foreignKey.getUniqueIndex();
        BaseTable parentTable = null;
        String parentKey = null;
        if (uniqueConstraint != null) {
            parentTable = uniqueConstraint.getBaseTable();
            parentKey = this.getKeyColumns((ReferenceConstraint)uniqueConstraint);
        } else if (index != null) {
            index.getTable();
            parentKey = this.getParentKeyColumns(index, quoteIdentifiers);
        }
        if (parentTable == null) {
            return null;
        }
        String statement = "ALTER TABLE " + this.getName((Table)foreignKey.getBaseTable(), quoteIdentifiers, qualifyNames) + SPACE + ADD + SPACE + CONSTRAINT + SPACE + this.getName((TableConstraint)foreignKey, quoteIdentifiers) + SPACE + FOREIGN_KEY + SPACE + LEFT_PARENTHESIS + this.getKeyColumns((ReferenceConstraint)foreignKey) + RIGHT_PARENTHESIS + NEWLINE;
        statement = String.valueOf(statement) + "\tREFERENCES " + this.getName((Table)parentTable, quoteIdentifiers, qualifyNames) + SPACE + LEFT_PARENTHESIS + parentKey + RIGHT_PARENTHESIS;
        ReferentialActionType action = foreignKey.getOnDelete();
        if (action != ReferentialActionType.NO_ACTION_LITERAL) {
            statement = String.valueOf(statement) + NEWLINE + TAB + ON + SPACE + DELETE + SPACE;
        }
        statement = String.valueOf(statement) + this.getReferentialAction(action);
        action = foreignKey.getOnUpdate();
        if (action != ReferentialActionType.NO_ACTION_LITERAL) {
            statement = String.valueOf(statement) + NEWLINE + TAB + ON + SPACE + UPDATE + SPACE;
        }
        statement = String.valueOf(statement) + this.getReferentialAction(action);
        if (foreignKey.isDeferrable()) {
            statement = String.valueOf(statement) + NEWLINE + TAB + this.getDeferrableClause((Constraint)foreignKey);
        }
        return statement;
    }

    protected String getDeferrableClause(Constraint constraint) {
        String clause = null;
        if (constraint.isDeferrable()) {
            clause = DEFERRABLE;
            if (constraint.isInitiallyDeferred()) {
                clause = String.valueOf(clause) + " INITIALLY DEFERRED";
            }
        }
        return clause;
    }

    protected String getReferentialAction(ReferentialActionType action) {
        if (action == ReferentialActionType.CASCADE_LITERAL) {
            return CASCADE;
        }
        if (action == ReferentialActionType.RESTRICT_LITERAL) {
            return RESTRICT;
        }
        if (action == ReferentialActionType.SET_DEFAULT_LITERAL) {
            return "SET DEFAULT";
        }
        if (action == ReferentialActionType.SET_NULL_LITERAL) {
            return "SET NULL";
        }
        return EMPTY_STRING;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getViewColumnList(ViewTable view) {
        String columns = null;
        Iterator it = view.getColumns().iterator();
        if (!it.hasNext()) return null;
        Column c = (Column)it.next();
        columns = c.getName();
        while (it.hasNext()) {
            c = (Column)it.next();
            columns = String.valueOf(columns) + ", " + c.getName();
        }
        return columns;
    }

    protected String getColumnString(Column column, boolean quoteIdentifiers) {
        String columnName = column.getName();
        if (quoteIdentifiers) {
            columnName = this.getDoubleQuotedString(columnName);
        }
        String columnString = String.valueOf(columnName) + SPACE + this.getDataTypeString((TypedElement)column, column.getTable().getSchema());
        String defaultValue = column.getDefaultValue();
        if (defaultValue != null) {
            columnString = String.valueOf(columnString) + SPACE + DEFAULT + SPACE + defaultValue;
        }
        if (!column.isNullable()) {
            columnString = String.valueOf(columnString) + SPACE + NOT + SPACE + NULL;
        }
        return columnString;
    }

    protected String getAddUniqueConstraintClause(UniqueConstraint constraint, boolean quoteIdentifiers) {
        String constraintName = this.getName((TableConstraint)constraint, quoteIdentifiers);
        String text = "ADD CONSTRAINT " + constraintName + SPACE + this.getUniqueConstraintType(constraint) + SPACE + LEFT_PARENTHESIS + this.getKeyColumns((ReferenceConstraint)constraint) + RIGHT_PARENTHESIS;
        if (constraint.isDeferrable()) {
            text = String.valueOf(text) + SPACE + this.getDeferrableClause((Constraint)constraint);
        }
        return text;
    }

    protected String getUniqueConstraintType(UniqueConstraint constraint) {
        if (constraint instanceof PrimaryKey) {
            return PRIMARY_KEY;
        }
        return UNIQUE;
    }

    protected String getAddCheckConstraintClause(CheckConstraint constraint, boolean quoteIdentifiers) {
        String constraintName = this.getName((TableConstraint)constraint, quoteIdentifiers);
        String text = "ADD CONSTRAINT " + constraintName + SPACE + CHECK + SPACE + LEFT_PARENTHESIS + constraint.getSearchCondition().getSQL() + RIGHT_PARENTHESIS;
        if (constraint.isDeferrable()) {
            text = String.valueOf(text) + SPACE + this.getDeferrableClause((Constraint)constraint);
        }
        return text;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getKeyColumns(ReferenceConstraint constraint) {
        String columns = null;
        Iterator it = constraint.getMembers().iterator();
        if (!it.hasNext()) return null;
        Column c = (Column)it.next();
        columns = c.getName();
        while (it.hasNext()) {
            c = (Column)it.next();
            columns = String.valueOf(columns) + ", " + c.getName();
        }
        return columns;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected String getIndexKeyColumns(Index index, boolean quoteIdentifiers) {
        Iterator it = index.getMembers().iterator();
        if (!it.hasNext()) {
            return null;
        }
        IndexMember m = (IndexMember)it.next();
        String columnName = m.getColumn().getName();
        if (quoteIdentifiers) {
            columnName = this.getDoubleQuotedString(columnName);
        }
        String columns = String.valueOf(columnName) + SPACE + m.getIncrementType().getName();
        while (it.hasNext()) {
            m = (IndexMember)it.next();
            columnName = m.getColumn().getName();
            if (quoteIdentifiers) {
                columnName = this.getDoubleQuotedString(columnName);
            }
            columns = String.valueOf(columns) + ", ";
            columns = String.valueOf(columns) + columnName + SPACE + m.getIncrementType().getName();
        }
        return columns;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected String getParentKeyColumns(Index index, boolean quoteIdentifiers) {
        Iterator it = index.getMembers().iterator();
        if (!it.hasNext()) {
            return null;
        }
        IndexMember m = (IndexMember)it.next();
        String columnName = m.getColumn().getName();
        if (quoteIdentifiers) {
            columnName = this.getDoubleQuotedString(columnName);
        }
        String columns = columnName;
        while (it.hasNext()) {
            m = (IndexMember)it.next();
            columnName = m.getColumn().getName();
            if (quoteIdentifiers) {
                columnName = this.getDoubleQuotedString(columnName);
            }
            columns = String.valueOf(columns) + ", " + columnName;
        }
        return columns;
    }

    protected String getDataTypeString(TypedElement typedElement, Schema schema) {
        SQLDataType containedType = typedElement.getContainedType();
        if (containedType != null) {
            EObject root;
            if (containedType instanceof PredefinedDataType && (root = ContainmentServiceImpl.INSTANCE.getRootElement((EObject)typedElement)) instanceof Database) {
                DatabaseDefinition def = DatabaseDefinitionRegistryImpl.INSTANCE.getDefinition((Database)root);
                return def.getPredefinedDataTypeFormattedName((PredefinedDataType)containedType);
            }
        } else {
            UserDefinedType referencedType = typedElement.getReferencedType();
            if (referencedType != null) {
                if (referencedType.getSchema() != schema) {
                    return this.getName(referencedType, false, true);
                }
                return referencedType.getName();
            }
        }
        return null;
    }

    protected String getName(TableConstraint constraint, boolean quoteIdentifiers) {
        String name = constraint.getName();
        if (quoteIdentifiers) {
            name = this.getDoubleQuotedString(name);
        }
        return name;
    }

    protected String getName(Trigger trigger, boolean quoteIdentifiers, boolean qualifyNames) {
        String name = trigger.getName();
        String schemaName = trigger.getSchema().getName();
        if (quoteIdentifiers) {
            name = this.getDoubleQuotedString(name);
            schemaName = this.getDoubleQuotedString(schemaName);
        }
        if (qualifyNames) {
            name = String.valueOf(schemaName) + DOT + name;
        }
        return name;
    }

    protected String getName(Routine routine, boolean quoteIdentifiers, boolean qualifyNames) {
        String name = routine.getName();
        String schemaName = routine.getSchema().getName();
        if (quoteIdentifiers) {
            name = this.getDoubleQuotedString(name);
            schemaName = this.getDoubleQuotedString(schemaName);
        }
        if (qualifyNames) {
            name = String.valueOf(schemaName) + DOT + name;
        }
        return name;
    }

    protected String getName(Index index, boolean quoteIdentifiers, boolean qualifyNames) {
        index.getTable();
        String indexName = index.getName();
        String schemaName = index.getSchema().getName();
        if (quoteIdentifiers) {
            indexName = this.getDoubleQuotedString(indexName);
            schemaName = this.getDoubleQuotedString(schemaName);
        }
        if (qualifyNames) {
            indexName = String.valueOf(schemaName) + DOT + indexName;
        }
        return indexName;
    }

    protected String getName(Table table, boolean quoteIdentifiers, boolean qualifyNames) {
        String tableName = table.getName();
        String schemaName = table.getSchema().getName();
        if (quoteIdentifiers) {
            tableName = this.getDoubleQuotedString(tableName);
            schemaName = this.getDoubleQuotedString(schemaName);
        }
        if (qualifyNames) {
            tableName = String.valueOf(schemaName) + DOT + tableName;
        }
        return tableName;
    }

    protected String getName(Sequence sequence, boolean quoteIdentifiers, boolean qualifyNames) {
        String sequenceName = sequence.getName();
        String schemaName = sequence.getSchema().getName();
        if (quoteIdentifiers) {
            sequenceName = this.getDoubleQuotedString(sequenceName);
            schemaName = this.getDoubleQuotedString(schemaName);
        }
        if (qualifyNames) {
            sequenceName = String.valueOf(schemaName) + DOT + sequenceName;
        }
        return sequenceName;
    }

    protected String getName(UserDefinedType type, boolean quoteIdentifiers, boolean qualifyNames) {
        String typeName = type.getName();
        String schemaName = type.getSchema().getName();
        if (quoteIdentifiers) {
            typeName = this.getDoubleQuotedString(typeName);
            schemaName = this.getDoubleQuotedString(schemaName);
        }
        if (qualifyNames) {
            typeName = String.valueOf(schemaName) + DOT + typeName;
        }
        return typeName;
    }

    protected String getSingleQuotedString(String orignal) {
        StringTokenizer tokenizer = new StringTokenizer(orignal, SINGLE_QUOTE);
        String result = tokenizer.nextToken();
        while (tokenizer.hasMoreTokens()) {
            result = String.valueOf(result) + SINGLE_QUOTE + SINGLE_QUOTE + tokenizer.nextToken();
        }
        return SINGLE_QUOTE + result + SINGLE_QUOTE;
    }

    protected String getDoubleQuotedString(String orignal) {
        StringTokenizer tokenizer = new StringTokenizer(orignal, DOUBLE_QUOTE);
        String result = null;
        if (tokenizer.countTokens() > 1) {
            if (tokenizer.hasMoreTokens()) {
                result = tokenizer.nextToken();
            }
            while (tokenizer.hasMoreTokens()) {
                result = String.valueOf(result) + DOUBLE_QUOTE + DOUBLE_QUOTE + tokenizer.nextToken();
            }
        } else if (tokenizer.hasMoreTokens()) {
            result = tokenizer.nextToken();
        }
        return DOUBLE_QUOTE + result + DOUBLE_QUOTE;
    }
}

