/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.rdb.internal.core.rte.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.wst.rdb.internal.core.RDBCorePlugin;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionFilter;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.core.rte.ICatalogObject;
import org.eclipse.wst.rdb.internal.core.rte.RefreshManager;
import org.eclipse.wst.rdb.internal.core.rte.jdbc.JDBCDatabase;
import org.eclipse.wst.rdb.internal.core.rte.jdbc.JDBCTable;
import org.eclipse.wst.rdb.internal.core.rte.jdbc.JDBCView;
import org.eclipse.wst.rdb.internal.models.sql.schema.Database;
import org.eclipse.wst.rdb.internal.models.sql.schema.SQLObject;
import org.eclipse.wst.rdb.internal.models.sql.schema.Schema;
import org.eclipse.wst.rdb.internal.models.sql.schema.impl.SchemaImpl;
import org.eclipse.wst.rdb.internal.models.sql.tables.SQLTablesPackage;
import org.eclipse.wst.rdb.internal.models.sql.tables.Table;

public class JDBCSchema
extends SchemaImpl
implements ICatalogObject {
    private boolean tablesLoaded = false;

    public synchronized void refresh() {
        this.tablesLoaded = false;
        RefreshManager.getInstance().referesh(this);
    }

    public boolean isSystemObject() {
        return false;
    }

    public Connection getConnection() {
        Database database = this.getDatabase();
        return ((JDBCDatabase)database).getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getDatabase();
    }

    public EList getTables() {
        if (!this.tablesLoaded) {
            this.loadTables();
        }
        return this.tables;
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        int id = this.eDerivedStructuralFeatureID(eFeature);
        if (id == 7) {
            this.getTables();
        }
        return super.eIsSet(eFeature);
    }

    private synchronized void loadTables() {
        if (this.tablesLoaded) {
            return;
        }
        EList tableList = super.getTables();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        Connection connection = this.getConnection();
        try {
            JDBCSchema.loadTables(connection, tableList, (Schema)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.tablesLoaded = true;
        this.eSetDeliver(deliver);
    }

    public static void loadTables(Connection connection, EList tableList, Schema schema) throws SQLException {
        Object[] oldList = tableList.toArray();
        tableList.clear();
        try {
            ConnectionInfo connectionInfo;
            ConnectionFilter filter;
            String catalogName = null;
            DatabaseMetaData metaData = connection.getMetaData();
            if (metaData.supportsCatalogsInTableDefinitions()) {
                catalogName = connection.getCatalog();
            }
            if ((filter = (connectionInfo = RDBCorePlugin.getDefault().getConnectionManager().getConnectionInfo((SQLObject)schema.getDatabase())).getFilter(String.valueOf(schema.getName()) + "::" + "DatatoolsTableFilterPredicate")) == null) {
                filter = connectionInfo.getFilter("DatatoolsTableFilterPredicate");
            }
            String[] tableAry = null;
            String pattern = null;
            if (filter != null) {
                String tableFilter = filter.getPredicate();
                if ((tableFilter = tableFilter.replaceAll(" ", "")).startsWith("IN(")) {
                    tableFilter = tableFilter.substring(3, tableFilter.length() - 1);
                    tableFilter = tableFilter.replaceAll(",", "");
                    tableAry = JDBCSchema.parseINClause(tableFilter);
                }
                if (tableFilter.startsWith("LIKE")) {
                    pattern = JDBCSchema.parseLikeClause(filter.getPredicate());
                }
            }
            ResultSet r = null;
            r = pattern != null ? metaData.getTables(catalogName, schema.getName(), pattern, new String[]{"TABLE", "VIEW", "SYSTEM TABLE"}) : metaData.getTables(catalogName, schema.getName(), null, new String[]{"TABLE", "VIEW", "TABLE_VIEW", "SYSTEM TABLE"});
            while (r.next()) {
                Object table;
                String tableName = r.getString(3);
                String type = r.getString(4);
                String remarks = r.getString(5);
                if (tableAry != null) {
                    boolean found = false;
                    int i = 0;
                    while (i < tableAry.length) {
                        if (tableName.equals(tableAry[i])) {
                            found = true;
                            break;
                        }
                        ++i;
                    }
                    if (!found) continue;
                }
                EClass metaclass = null;
                if (type.equals("TABLE") || type.equals("SYSTEM TABLE")) {
                    metaclass = SQLTablesPackage.eINSTANCE.getPersistentTable();
                } else if (type.equals("VIEW")) {
                    metaclass = SQLTablesPackage.eINSTANCE.getViewTable();
                }
                Object element = JDBCSchema.findElement(oldList, tableName, metaclass);
                if (element != null) {
                    table = (Table)element;
                    ((ICatalogObject)table).refresh();
                } else {
                    if (type.equals("TABLE") || type.equals("SYSTEM TABLE")) {
                        table = new JDBCTable();
                    } else {
                        if (!type.equals("VIEW")) continue;
                        table = new JDBCView();
                    }
                    table.setName(tableName);
                }
                table.setDescription(remarks);
                tableList.add(table);
            }
            r.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Object findElement(Object[] list, String name, EClass metaclass) {
        Object object = null;
        int i = 0;
        while (i < list.length) {
            SQLObject sqlObject = (SQLObject)list[i];
            if (sqlObject.getName().equals(name) && sqlObject.eClass() == metaclass) {
                object = list[i];
                break;
            }
            ++i;
        }
        return object;
    }

    protected static String[] parseINClause(String toParse) {
        StringTokenizer tokenizer = new StringTokenizer(toParse, "'");
        Vector<String> list = new Vector<String>();
        if (tokenizer.countTokens() >= 1) {
            while (tokenizer.hasMoreTokens()) {
                list.add(tokenizer.nextToken());
            }
        }
        String[] retStrList = null;
        if (list.size() > 0) {
            retStrList = new String[list.size()];
            int i = 0;
            while (i < list.size()) {
                retStrList[i] = (String)list.get(i);
                ++i;
            }
        }
        return retStrList;
    }

    protected static String parseLikeClause(String toParse) {
        String retString = toParse.substring(toParse.indexOf("'") + 1, toParse.length() - 1);
        return retString;
    }
}

