/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.ui.editor.IServerEditorPartInput;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.editor.ServerEditorPartInput;
import org.eclipse.wst.server.ui.internal.editor.ServerResourceCommandManager;

public class GlobalCommandManager {
    private static final int MAX_HISTORY = 200;
    protected List undoList = new ArrayList();
    protected List redoList = new ArrayList();
    protected Map commandManagers = new HashMap();
    protected List propertyListeners;
    public static final String PROP_DIRTY = "dirtyState";
    public static final String PROP_UNDO = "undoAction";
    public static final String PROP_REDO = "redoAction";
    public static final String PROP_RELOAD = "reload";
    protected static GlobalCommandManager instance;

    public static GlobalCommandManager getInstance() {
        if (instance == null) {
            instance = new GlobalCommandManager();
        }
        return instance;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyListeners == null) {
            this.propertyListeners = new ArrayList();
        }
        this.propertyListeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.propertyListeners != null) {
            this.propertyListeners.remove(listener);
        }
    }

    protected void firePropertyChangeEvent(String propertyName, Object oldValue, Object newValue) {
        if (this.propertyListeners == null) {
            return;
        }
        PropertyChangeEvent event = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        try {
            int size = this.propertyListeners.size();
            PropertyChangeListener[] pcl = new PropertyChangeListener[size];
            this.propertyListeners.toArray(pcl);
            int i = 0;
            while (i < size) {
                try {
                    pcl[i].propertyChange(event);
                }
                catch (Exception exception) {}
                ++i;
            }
        }
        catch (Exception exception) {}
    }

    public void getCommandManager(String id) {
        CommandManagerInfo info;
        Trace.trace(Trace.FINEST, "Getting command manager for " + id);
        try {
            info = (CommandManagerInfo)this.commandManagers.get(id);
            if (info != null) {
                ++info.count;
                return;
            }
        }
        catch (Exception e) {
            Trace.trace(Trace.WARNING, "Could not find existing command manager", e);
        }
        Trace.trace(Trace.FINEST, "Creating new command manager for " + id);
        try {
            info = new CommandManagerInfo();
            info.count = 1;
            info.id = id;
            IServer server = null;
            if (id != null) {
                server = ServerCore.findServer((String)id);
            }
            if (server != null) {
                info.wc = server.createWorkingCopy();
            }
            info.isDirty = false;
            info.isReadOnly = false;
            this.commandManagers.put(id, info);
            this.updateTimestamps(id);
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Could not obtain command manager", e);
        }
    }

    public void releaseCommandManager(String id) {
        Trace.trace(Trace.FINEST, "Releasing command manager for " + id);
        try {
            CommandManagerInfo info = (CommandManagerInfo)this.commandManagers.get(id);
            if (info != null) {
                --info.count;
                if (info.count == 0) {
                    this.commandManagers.remove(id);
                    this.clearUndoList(id);
                    this.clearRedoList(id);
                }
            }
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Could not release command manager", e);
        }
    }

    public void reload(String id, IProgressMonitor monitor) {
        try {
            CommandManagerInfo info = this.getExistingCommandManagerInfo(id);
            if (info != null) {
                IServer server = null;
                if (id != null) {
                    server = ServerCore.findServer((String)id);
                }
                if (server != null) {
                    info.wc = server.createWorkingCopy();
                }
                this.firePropertyChangeEvent(PROP_RELOAD, id, null);
            }
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "Could not release command manager", e);
        }
    }

    protected CommandManagerInfo getExistingCommandManagerInfo(String id) {
        try {
            return (CommandManagerInfo)this.commandManagers.get(id);
        }
        catch (Exception exception) {
            Trace.trace(Trace.SEVERE, "Could not find existing command manager info");
            return null;
        }
    }

    public boolean isOnlyCommandManager(String id) {
        CommandManagerInfo info = this.getExistingCommandManagerInfo(id);
        return info != null && info.count == 1;
    }

    protected IServerEditorPartInput getPartInput(String serverId, ServerResourceCommandManager serverCommandManager) {
        CommandManagerInfo serverInfo = null;
        IServerWorkingCopy server = null;
        boolean serverReadOnly = false;
        if (serverId != null) {
            serverInfo = this.getExistingCommandManagerInfo(serverId);
            if (serverInfo == null) {
                return null;
            }
            server = serverInfo.wc;
            serverReadOnly = serverInfo.isReadOnly;
        }
        return new ServerEditorPartInput(serverCommandManager, server, serverReadOnly);
    }

    protected IServerWorkingCopy getServerResource(String id) {
        CommandManagerInfo info = this.getExistingCommandManagerInfo(id);
        if (info == null) {
            return null;
        }
        return info.wc;
    }

    public void executeCommand(String id, IUndoableOperation command) {
        if (!command.canUndo() && !this.undoList.isEmpty() && ServerUIPlugin.getPreferences().getPromptBeforeIrreversibleChange()) {
            try {
                Shell shell;
                Display d = Display.getCurrent();
                if (d == null) {
                    d = Display.getDefault();
                }
                if (!MessageDialog.openConfirm((Shell)(shell = d.getActiveShell()), (String)Messages.editorServerEditor, (String)Messages.editorPromptIrreversible)) {
                    return;
                }
            }
            catch (Exception exception) {}
        }
        ServerResourceCommand src = new ServerResourceCommand();
        src.id = id;
        src.command = command;
        try {
            command.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException executionException) {
            return;
        }
        CommandManagerInfo info = this.getExistingCommandManagerInfo(id);
        if (info == null) {
            return;
        }
        if (command.canUndo()) {
            this.addToUndoList(src);
        } else {
            info.canCompletelyUndo = false;
            this.clearUndoList(id);
        }
        this.clearRedoList(id);
        this.setDirtyState(id, true);
    }

    private void addToUndoList(ServerResourceCommand src) {
        this.undoList.add(src);
        if (this.undoList.size() > 200) {
            this.undoList.remove(0);
        }
        this.firePropertyChangeEvent(PROP_UNDO, src.id, null);
    }

    private void clearUndoList(String id) {
        int i = 0;
        boolean modified = false;
        while (i < this.undoList.size()) {
            ServerResourceCommand src = (ServerResourceCommand)this.undoList.get(i);
            if (src.id.equals(id)) {
                modified = true;
                this.undoList.remove(i);
                continue;
            }
            ++i;
        }
        if (modified) {
            this.firePropertyChangeEvent(PROP_UNDO, id, null);
        }
    }

    private void clearRedoList(String id) {
        int i = 0;
        boolean modified = false;
        while (i < this.redoList.size()) {
            ServerResourceCommand src = (ServerResourceCommand)this.redoList.get(i);
            if (src.id.equals(id)) {
                this.redoList.remove(i);
                modified = true;
                continue;
            }
            ++i;
        }
        if (modified) {
            this.firePropertyChangeEvent(PROP_REDO, id, null);
        }
    }

    protected boolean canUndo(String a, String b) {
        Iterator iterator = this.undoList.iterator();
        while (iterator.hasNext()) {
            ServerResourceCommand src = (ServerResourceCommand)iterator.next();
            if (src.id != a && src.id != b) continue;
            return true;
        }
        return false;
    }

    protected boolean canRedo(String a, String b) {
        Iterator iterator = this.redoList.iterator();
        while (iterator.hasNext()) {
            ServerResourceCommand src = (ServerResourceCommand)iterator.next();
            if (src.id != a && src.id != b) continue;
            return true;
        }
        return false;
    }

    public IUndoableOperation getUndoCommand(String a) {
        int size = this.undoList.size();
        int i = size - 1;
        while (i >= 0) {
            ServerResourceCommand src = (ServerResourceCommand)this.undoList.get(i);
            if (src.id == a) {
                return src.command;
            }
            --i;
        }
        return null;
    }

    public IUndoableOperation getRedoCommand(String a) {
        int size = this.redoList.size();
        int i = size - 1;
        while (i >= 0) {
            ServerResourceCommand src = (ServerResourceCommand)this.redoList.get(i);
            if (src.id == a) {
                return src.command;
            }
            --i;
        }
        return null;
    }

    public boolean isDirty(String id) {
        CommandManagerInfo info = this.getExistingCommandManagerInfo(id);
        if (info == null) {
            return false;
        }
        return info.isDirty;
    }

    public boolean isReadOnly(String id) {
        CommandManagerInfo info = this.getExistingCommandManagerInfo(id);
        if (info == null) {
            return false;
        }
        return info.isReadOnly;
    }

    public void setReadOnly(String id, boolean readOnly) {
        CommandManagerInfo info = this.getExistingCommandManagerInfo(id);
        if (info == null) {
            return;
        }
        if (info.isReadOnly == readOnly) {
            return;
        }
        info.isReadOnly = readOnly;
        this.firePropertyChangeEvent(PROP_RELOAD, id, null);
    }

    public boolean areFilesReadOnly(String id) {
        CommandManagerInfo info = this.getExistingCommandManagerInfo(id);
        if (info == null) {
            return false;
        }
        return this.getReadOnlyFiles(id).length > 0;
    }

    private void setDirtyState(String id, boolean dirty) {
        CommandManagerInfo info = this.getExistingCommandManagerInfo(id);
        if (info.isDirty == dirty) {
            return;
        }
        info.isDirty = dirty;
        this.firePropertyChangeEvent(PROP_DIRTY, id, null);
    }

    protected void undo(String a) {
        ServerResourceCommand src = null;
        Iterator iterator = this.undoList.iterator();
        while (iterator.hasNext()) {
            ServerResourceCommand src2 = (ServerResourceCommand)iterator.next();
            if (src2.id != a) continue;
            src = src2;
        }
        if (src == null) {
            return;
        }
        try {
            src.command.undo(null, null);
        }
        catch (ExecutionException executionException) {}
        this.undoList.remove(src);
        this.firePropertyChangeEvent(PROP_UNDO, src.id, null);
        this.redoList.add(src);
        this.firePropertyChangeEvent(PROP_REDO, src.id, null);
        CommandManagerInfo info = this.getExistingCommandManagerInfo(src.id);
        if (info.canCompletelyUndo && this.getUndoCommand(src.id) == null) {
            this.setDirtyState(src.id, false);
        }
    }

    protected void redo(String a) {
        ServerResourceCommand src = null;
        Iterator iterator = this.redoList.iterator();
        while (iterator.hasNext()) {
            ServerResourceCommand src2 = (ServerResourceCommand)iterator.next();
            if (src2.id != a) continue;
            src = src2;
        }
        if (src == null) {
            return;
        }
        try {
            src.command.execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException executionException) {
            return;
        }
        this.redoList.remove(src);
        this.firePropertyChangeEvent(PROP_REDO, src.id, null);
        this.undoList.add(src);
        this.firePropertyChangeEvent(PROP_UNDO, src.id, null);
        this.setDirtyState(src.id, true);
    }

    public void resourceSaved(String id) {
        CommandManagerInfo info = this.getExistingCommandManagerInfo(id);
        info.canCompletelyUndo = true;
        this.setDirtyState(id, false);
    }

    public static IFile[] getReadOnlyFiles(IServerAttributes server) {
        try {
            ArrayList<IFile> list = new ArrayList<IFile>();
            IFile file = ((Server)server).getFile();
            if (file != null) {
                list.add(file);
            }
            IFile[] files = new IFile[list.size()];
            list.toArray(files);
            return files;
        }
        catch (Exception e) {
            Trace.trace(Trace.SEVERE, "getReadOnlyFiles", e);
            return null;
        }
    }

    protected IFile[] getServerResourceFiles(String id) {
        if (id == null) {
            return new IFile[0];
        }
        CommandManagerInfo info = this.getExistingCommandManagerInfo(id);
        if (info == null) {
            return new IFile[0];
        }
        return GlobalCommandManager.getReadOnlyFiles((IServerAttributes)info.wc);
    }

    protected IFile[] getReadOnlyFiles(String id) {
        ArrayList<IFile> list = new ArrayList<IFile>();
        IFile[] files = this.getServerResourceFiles(id);
        int size = files.length;
        int i = 0;
        while (i < size) {
            if (files[i].isReadOnly()) {
                list.add(files[i]);
            }
            ++i;
        }
        IFile[] fileList = new IFile[list.size()];
        list.toArray(fileList);
        return fileList;
    }

    public void updateTimestamps(String id) {
        CommandManagerInfo info = this.getExistingCommandManagerInfo(id);
        if (info == null) {
            return;
        }
        info.fileMap = new HashMap();
        IFile[] files = this.getServerResourceFiles(id);
        if (files != null) {
            int size = files.length;
            int i = 0;
            while (i < size) {
                File f;
                if (files[i] != null && (f = files[i].getLocation().toFile()) != null) {
                    long time = f.lastModified();
                    info.fileMap.put(files[i], new Long(time));
                }
                ++i;
            }
        }
        info.timestamp = GlobalCommandManager.getTimestamp(info);
    }

    protected static int getTimestamp(CommandManagerInfo info) {
        IServer server = info.wc.getOriginal();
        if (server != null) {
            return ((Server)server).getTimestamp();
        }
        return -1;
    }

    protected boolean hasChanged(String id) {
        CommandManagerInfo info = this.getExistingCommandManagerInfo(id);
        if (info == null) {
            return false;
        }
        IFile[] files = this.getServerResourceFiles(id);
        int size = files.length;
        int count = 0;
        int i = 0;
        while (i < size) {
            ++count;
            File f = files[i].getLocation().toFile();
            try {
                Long time = (Long)info.fileMap.get(files[i]);
                if (time.longValue() != f.lastModified()) {
                    return true;
                }
            }
            catch (Exception exception) {
                return true;
            }
            ++i;
        }
        int timestamp = GlobalCommandManager.getTimestamp(info);
        if (info.timestamp != timestamp) {
            return true;
        }
        return count != info.fileMap.size();
    }

    class ServerResourceCommand {
        IUndoableOperation command;
        String id;

        ServerResourceCommand() {
        }
    }

    class CommandManagerInfo {
        int count;
        boolean isDirty;
        boolean isReadOnly;
        boolean canCompletelyUndo = true;
        String id;
        IServerWorkingCopy wc;
        Map fileMap;
        int timestamp;

        CommandManagerInfo() {
        }
    }
}

