/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui;

import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.IUndoManager;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.text.hyperlink.IHyperlinkPresenter;
import org.eclipse.jface.text.information.IInformationPresenter;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.wst.sse.ui.StructuredTextViewerUndoManager;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;
import org.eclipse.wst.sse.ui.internal.StructuredTextAnnotationHover;
import org.eclipse.wst.sse.ui.internal.contentassist.StructuredContentAssistant;
import org.eclipse.wst.sse.ui.internal.derived.HTMLTextPresenter;
import org.eclipse.wst.sse.ui.internal.hyperlink.HighlighterHyperlinkPresenter;
import org.eclipse.wst.sse.ui.internal.provisional.preferences.CommonEditorPreferenceNames;
import org.eclipse.wst.sse.ui.internal.provisional.style.LineStyleProvider;
import org.eclipse.wst.sse.ui.internal.reconcile.StructuredRegionProcessor;
import org.eclipse.wst.sse.ui.internal.taginfo.AnnotationHoverProcessor;
import org.eclipse.wst.sse.ui.internal.taginfo.BestMatchHover;
import org.eclipse.wst.sse.ui.internal.taginfo.ProblemAnnotationHoverProcessor;
import org.eclipse.wst.sse.ui.internal.taginfo.TextHoverManager;

public class StructuredTextViewerConfiguration
extends TextSourceViewerConfiguration {
    private StructuredContentAssistant fContentAssistant = null;
    private IReconciler fReconciler;

    public StructuredTextViewerConfiguration() {
        this.fPreferenceStore = this.createCombinedPreferenceStore();
    }

    private IPreferenceStore createCombinedPreferenceStore() {
        IPreferenceStore sseEditorPrefs = SSEUIPlugin.getDefault().getPreferenceStore();
        IPreferenceStore baseEditorPrefs = EditorsUI.getPreferenceStore();
        return new ChainedPreferenceStore(new IPreferenceStore[]{sseEditorPrefs, baseEditorPrefs});
    }

    public final IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new StructuredTextAnnotationHover();
    }

    public final String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        return "org.eclipse.wst.sse.core.default_structured_text_partitioning";
    }

    public int[] getConfiguredTextHoverStateMasks(ISourceViewer sourceViewer, String contentType) {
        TextHoverManager.TextHoverDescriptor[] hoverDescs = SSEUIPlugin.getDefault().getTextHoverManager().getTextHovers();
        int[] stateMasks = new int[hoverDescs.length];
        int stateMasksLength = 0;
        int i = 0;
        while (i < hoverDescs.length) {
            if (hoverDescs[i].isEnabled()) {
                int j = 0;
                int stateMask = StructuredTextViewerConfiguration.computeStateMask((String)hoverDescs[i].getModifierString());
                while (j < stateMasksLength) {
                    if (stateMasks[j] == stateMask) break;
                    ++j;
                }
                if (j == stateMasksLength) {
                    stateMasks[stateMasksLength++] = stateMask;
                }
            }
            ++i;
        }
        if (stateMasksLength == hoverDescs.length) {
            return stateMasks;
        }
        int[] shortenedStateMasks = new int[stateMasksLength];
        System.arraycopy(stateMasks, 0, shortenedStateMasks, 0, stateMasksLength);
        return shortenedStateMasks;
    }

    public final IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        if (this.fContentAssistant == null) {
            this.fContentAssistant = new StructuredContentAssistant();
            this.fContentAssistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
            this.fContentAssistant.enableAutoActivation(true);
            this.fContentAssistant.setAutoActivationDelay(500);
            this.fContentAssistant.setProposalPopupOrientation(10);
            this.fContentAssistant.setContextInformationPopupOrientation(20);
            this.fContentAssistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
            String[] types = this.getConfiguredContentTypes(sourceViewer);
            int i = 0;
            while (i < types.length) {
                String type = types[i];
                IContentAssistProcessor[] processors = this.getContentAssistProcessors(sourceViewer, type);
                if (processors != null) {
                    int j = 0;
                    while (j < processors.length) {
                        this.fContentAssistant.setContentAssistProcessor(processors[j], type);
                        ++j;
                    }
                }
                ++i;
            }
        }
        return this.fContentAssistant;
    }

    protected IContentAssistProcessor[] getContentAssistProcessors(ISourceViewer sourceViewer, String partitionType) {
        return null;
    }

    public IContentFormatter getContentFormatter(ISourceViewer sourceViewer) {
        return null;
    }

    public final IHyperlinkPresenter getHyperlinkPresenter(ISourceViewer sourceViewer) {
        if (this.fPreferenceStore == null) {
            return super.getHyperlinkPresenter(sourceViewer);
        }
        return new HighlighterHyperlinkPresenter(this.fPreferenceStore);
    }

    public final IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, 0, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(false));
            }
        };
    }

    public final IInformationPresenter getInformationPresenter(ISourceViewer sourceViewer) {
        InformationPresenter presenter = new InformationPresenter(this.getInformationPresenterControlCreator(sourceViewer));
        presenter.setSizeConstraints(60, 10, true, true);
        presenter.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        String[] types = this.getConfiguredContentTypes(sourceViewer);
        int i = 0;
        while (i < types.length) {
            String type = types[i];
            IInformationProvider provider = this.getInformationProvider(sourceViewer, type);
            if (provider != null) {
                presenter.setInformationProvider(provider, type);
            }
            ++i;
        }
        return presenter;
    }

    protected IInformationProvider getInformationProvider(ISourceViewer sourceViewer, String partitionType) {
        return null;
    }

    private IInformationControlCreator getInformationPresenterControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                int shellStyle = 20;
                int style = 768;
                return new DefaultInformationControl(parent, shellStyle, style, (DefaultInformationControl.IInformationPresenter)new HTMLTextPresenter(false));
            }
        };
    }

    public LineStyleProvider[] getLineStyleProviders(ISourceViewer sourceViewer, String partitionType) {
        return null;
    }

    public final IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        return null;
    }

    public final IReconciler getReconciler(ISourceViewer sourceViewer) {
        boolean reconcilingEnabled = this.fPreferenceStore.getBoolean(CommonEditorPreferenceNames.EVALUATE_TEMPORARY_PROBLEMS);
        if (sourceViewer == null || !reconcilingEnabled) {
            return null;
        }
        if (this.fReconciler == null && sourceViewer != null) {
            StructuredRegionProcessor reconciler = new StructuredRegionProcessor();
            reconciler.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
            this.fReconciler = reconciler;
        }
        return this.fReconciler;
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
        Object textHover = null;
        TextHoverManager.TextHoverDescriptor[] hoverDescs = SSEUIPlugin.getDefault().getTextHoverManager().getTextHovers();
        int i = 0;
        while (i < hoverDescs.length && textHover == null) {
            if (hoverDescs[i].isEnabled() && StructuredTextViewerConfiguration.computeStateMask((String)hoverDescs[i].getModifierString()) == stateMask) {
                String hoverType = hoverDescs[i].getId();
                if ("problemHover".equalsIgnoreCase(hoverType)) {
                    textHover = new ProblemAnnotationHoverProcessor();
                } else if ("annotationHover".equalsIgnoreCase(hoverType)) {
                    textHover = new AnnotationHoverProcessor();
                } else if ("combinationHover".equalsIgnoreCase(hoverType)) {
                    textHover = new BestMatchHover(null);
                }
            }
            ++i;
        }
        return textHover;
    }

    public final IUndoManager getUndoManager(ISourceViewer sourceViewer) {
        return new StructuredTextViewerUndoManager();
    }
}

