/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.web.ui.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.eclipse.wst.common.componentcore.datamodel.properties.IFacetProjectCreationDataModelProperties;
import org.eclipse.wst.common.componentcore.internal.operation.FacetProjectCreationOperation;
import org.eclipse.wst.common.frameworks.datamodel.DataModelEvent;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelListener;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectTemplate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.ui.AddRemoveFacetsWizard;
import org.eclipse.wst.common.project.facet.ui.internal.ConflictingFacetsFilter;
import org.eclipse.wst.common.project.facet.ui.internal.FacetsSelectionPanel;
import org.eclipse.wst.web.internal.DelegateConfigurationElement;
import org.eclipse.wst.web.ui.internal.WSTWebUIPlugin;

public abstract class NewProjectDataModelFacetWizard
extends AddRemoveFacetsWizard
implements INewWizard,
IFacetProjectCreationDataModelProperties {
    protected IDataModel model = null;
    private final IFacetedProjectTemplate template;
    private IWizardPage firstPage;
    private IConfigurationElement configurationElement;

    public NewProjectDataModelFacetWizard(IDataModel model) {
        super(null);
        this.model = model;
        this.template = this.getTemplate();
        this.setDefaultPageImageDescriptor(this.getDefaultPageImageDescriptor());
    }

    public NewProjectDataModelFacetWizard() {
        super(null);
        this.model = this.createDataModel();
        this.template = this.getTemplate();
        this.setDefaultPageImageDescriptor(this.getDefaultPageImageDescriptor());
    }

    public IDataModel getDataModel() {
        return this.model;
    }

    protected abstract IDataModel createDataModel();

    protected abstract ImageDescriptor getDefaultPageImageDescriptor();

    protected abstract IFacetedProjectTemplate getTemplate();

    protected abstract IWizardPage createFirstPage();

    public void addPages() {
        this.firstPage = this.createFirstPage();
        this.addPage(this.firstPage);
        super.addPages();
        Set fixed = this.template.getFixedProjectFacets();
        this.facetsSelectionPage.setFixedProjectFacets(fixed);
        this.facetsSelectionPage.addSelectedFacetsChangedListener(new Listener(){

            public void handleEvent(Event event) {
                NewProjectDataModelFacetWizard.this.facetSelectionChangedEvent(event);
            }
        });
        ConflictingFacetsFilter filter = new ConflictingFacetsFilter(fixed);
        this.facetsSelectionPage.setFilters(new FacetsSelectionPanel.IFilter[]{filter});
        IRuntime runtime = (IRuntime)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME");
        if (runtime != null) {
            this.setRuntime(runtime);
        }
        this.synchRuntimes();
    }

    public IWizardPage[] getPages() {
        IWizardPage[] base = super.getPages();
        IWizardPage[] pages = new IWizardPage[base.length + 1];
        pages[0] = this.firstPage;
        System.arraycopy(base, 0, pages, 1, base.length);
        return pages;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    protected void synchRuntimes() {
        this.model.addListener(new IDataModelListener(){

            public void propertyChanged(DataModelEvent event) {
                IRuntime runtime;
                if ((1 == event.getFlag() || 2 == event.getFlag()) && "IFacetProjectCreationDataModelProperties.FACET_RUNTIME".equals(event.getPropertyName()) && (runtime = (IRuntime)event.getProperty()) != NewProjectDataModelFacetWizard.this.getRuntime()) {
                    NewProjectDataModelFacetWizard.this.setRuntime(runtime);
                }
            }
        });
        this.addRuntimeListener(new Listener(){

            public void handleEvent(Event event) {
                NewProjectDataModelFacetWizard.this.model.setProperty("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", (Object)NewProjectDataModelFacetWizard.this.getRuntime());
            }
        });
    }

    public String getProjectName() {
        return this.model.getStringProperty("IFacetDataModelPropeties.FACET_PROJECT_NAME");
    }

    public boolean performFinish() {
        if (!super.performFinish()) {
            return false;
        }
        try {
            this.postPerformFinish();
        }
        catch (InvocationTargetException e) {
            Logger.getLogger().logError((Throwable)e);
        }
        return true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void performFinish(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("", 10);
        this.storeDefaultSettings();
        try {
            FacetProjectCreationOperation operation = new FacetProjectCreationOperation(this.model);
            this.fproj = operation.createProject((IProgressMonitor)new SubProgressMonitor(monitor, 2));
            super.performFinish((IProgressMonitor)new SubProgressMonitor(monitor, 8));
            Set fixed = this.template.getFixedProjectFacets();
            this.fproj.setFixedProjectFacets(fixed);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        monitor.done();
    }

    protected String getFinalPerspectiveID() {
        IProduct product = Platform.getProduct();
        String perspective = null;
        if (product != null) {
            perspective = product.getProperty("j2eeNewProjectFinalPerspective");
        }
        if (perspective == null) {
            perspective = "org.eclipse.jst.j2ee.J2EEPerspective";
        }
        return perspective;
    }

    public final void setInitializationData(IConfigurationElement aConfigurationElement, String aPropertyName, Object theData) throws CoreException {
        this.configurationElement = aConfigurationElement;
        this.doSetInitializeData(aConfigurationElement, aPropertyName, theData);
    }

    protected void doSetInitializeData(IConfigurationElement aConfigurationElement, String aPropertyName, Object theData) {
    }

    public final String getPluginId() {
        return this.configurationElement != null ? this.configurationElement.getDeclaringExtension().getDeclaringPluginDescriptor().getUniqueIdentifier() : "";
    }

    protected void postPerformFinish() throws InvocationTargetException {
        if (this.getFinalPerspectiveID() != null && this.getFinalPerspectiveID().length() > 0) {
            DelegateConfigurationElement element = new DelegateConfigurationElement(this.configurationElement){

                public String getAttribute(String aName) {
                    if (aName.equals("finalPerspective")) {
                        return NewProjectDataModelFacetWizard.this.getFinalPerspectiveID();
                    }
                    return super.getAttribute(aName);
                }
            };
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)element);
        } else {
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.configurationElement);
        }
        String projName = this.getProjectName();
        BasicNewResourceWizard.selectAndReveal((IResource)ProjectUtilities.getProject((String)projName), (IWorkbenchWindow)WSTWebUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow());
    }

    protected void facetSelectionChangedEvent(Event event) {
        String id;
        Set actions = this.facetsSelectionPage.getActions();
        Iterator iterator = actions.iterator();
        HashSet<String> activeIds = new HashSet<String>();
        while (iterator.hasNext()) {
            IFacetedProject.Action action = (IFacetedProject.Action)iterator.next();
            id = action.getProjectFacetVersion().getProjectFacet().getId();
            activeIds.add(id);
        }
        IFacetProjectCreationDataModelProperties.FacetDataModelMap dataModelMap = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        iterator = dataModelMap.keySet().iterator();
        while (iterator.hasNext()) {
            id = (String)iterator.next();
            IDataModel configDM = (IDataModel)dataModelMap.get((Object)id);
            boolean active = activeIds.contains(id);
            configDM.setBooleanProperty("IFacetDataModelProperties.SHOULD_EXECUTE", active);
            activeIds.remove(id);
        }
        IFacetProjectCreationDataModelProperties.FacetActionMap actionMap = (IFacetProjectCreationDataModelProperties.FacetActionMap)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACET_ACTION_MAP");
        actionMap.clear();
        iterator = actions.iterator();
        while (iterator.hasNext()) {
            IFacetedProject.Action action = (IFacetedProject.Action)iterator.next();
            String id2 = action.getProjectFacetVersion().getProjectFacet().getId();
            if (!activeIds.contains(id2)) continue;
            actionMap.add(action);
        }
        this.model.notifyPropertyChange("IFacetProjectCreationDataModelProperties.FACET_RUNTIME", 4);
    }

    public Object getConfig(IProjectFacetVersion fv, IFacetedProject.Action.Type type, String pjname) throws CoreException {
        IFacetProjectCreationDataModelProperties.FacetDataModelMap map = (IFacetProjectCreationDataModelProperties.FacetDataModelMap)this.model.getProperty("IFacetProjectCreationDataModelProperties.FACET_DM_MAP");
        IDataModel configDM = (IDataModel)map.get((Object)fv.getProjectFacet().getId());
        if (configDM == null) {
            Object config = fv.createActionConfig(type, pjname);
            if (config == null || !(config instanceof IDataModel)) {
                return null;
            }
            configDM = (IDataModel)config;
            map.add(configDM);
        }
        configDM.setProperty("IFacetDataModelPropeties.FACET_VERSION", (Object)fv);
        return configDM;
    }

    protected void storeDefaultSettings() {
        IWizardPage[] pages = this.getPages();
        int i = 0;
        while (i < pages.length) {
            this.storeDefaultSettings(pages[i], i);
            ++i;
        }
    }

    protected void storeDefaultSettings(IWizardPage page, int pageIndex) {
        if (page instanceof DataModelWizardPage) {
            ((DataModelWizardPage)page).storeDefaultSettings();
        }
    }
}

