/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.wsfinder;

import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.wst.ws.internal.wsfinder.AbstractWebServiceLocator;
import org.eclipse.wst.ws.internal.wsrt.WebServiceInfo;

public class WorkspaceWSDLLocator
extends AbstractWebServiceLocator {
    protected List wsdlServices = null;
    private static final String PLATFORM_RES = "platform:/resource";
    private static final String WSDL_EXT = "wsdl";

    public List getWebServices() {
        if (this.wsdlServices == null) {
            try {
                IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                WSDLVisitor visitor = new WSDLVisitor();
                root.accept((IResourceVisitor)visitor);
                visitor.visit((IResource)root);
                this.wsdlServices = visitor.getWSDL();
            }
            catch (Exception exception) {}
        }
        return this.wsdlServices;
    }

    private class WSDLVisitor
    implements IResourceVisitor {
        private Vector wsdl = new Vector();

        private WSDLVisitor() {
        }

        public boolean visit(IResource resource) {
            String ext;
            if (resource.getType() == 1 && (ext = resource.getFileExtension()) != null && ext.equalsIgnoreCase(WorkspaceWSDLLocator.WSDL_EXT)) {
                String urlString = resource.getFullPath().toString();
                urlString = WorkspaceWSDLLocator.PLATFORM_RES + urlString;
                WebServiceInfo wsInfo = new WebServiceInfo();
                wsInfo.setWsdlURL(urlString);
                this.wsdl.add(wsInfo);
            }
            return true;
        }

        public Vector getWSDL() {
            return this.wsdl;
        }
    }
}

