/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal;

import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.wst.wsdl.ui.internal.BaseRegistryReader;
import org.eclipse.wst.wsdl.ui.internal.extension.NSKeyedExtensionRegistry;

abstract class NSKeyedExtensionRegistryReader
extends BaseRegistryReader {
    protected static final String ATT_NAME_SPACE = "namespace";
    protected String extensionPointId;
    protected String tagName;
    protected String[] attributeNames;
    protected NSKeyedExtensionRegistry nsKeyedExtensionRegistry;

    private NSKeyedExtensionRegistryReader(String extensionPointId, String tagName, NSKeyedExtensionRegistry nsKeyedExtensionRegistry) {
        this.extensionPointId = extensionPointId;
        this.tagName = tagName;
        this.nsKeyedExtensionRegistry = nsKeyedExtensionRegistry;
    }

    public NSKeyedExtensionRegistryReader(String extensionPointId, String tagName, String attributeName, NSKeyedExtensionRegistry nsKeyedExtensionRegistry) {
        this(extensionPointId, tagName, nsKeyedExtensionRegistry);
        this.attributeNames = new String[1];
        this.attributeNames[0] = attributeName;
    }

    public NSKeyedExtensionRegistryReader(String extensionPointId, String tagName, String[] attributeNames, NSKeyedExtensionRegistry nsKeyedExtensionRegistry) {
        this(extensionPointId, tagName, nsKeyedExtensionRegistry);
        this.attributeNames = attributeNames;
    }

    public void readRegistry() {
        super.readRegistry(this.extensionPointId);
    }

    protected void readElement(IConfigurationElement element) {
        String namespace;
        if (element.getName().equals(this.tagName) && (namespace = element.getAttribute(ATT_NAME_SPACE)) != null) {
            ClassLoader pluginClasssLoader = element.getDeclaringExtension().getDeclaringPluginDescriptor().getPluginClassLoader();
            if (this.attributeNames.length == 1) {
                String className = element.getAttribute(this.attributeNames[0]);
                if (className != null) {
                    this.nsKeyedExtensionRegistry.put(namespace, className, pluginClasssLoader);
                }
            } else {
                HashMap<String, String> map = new HashMap<String, String>();
                int i = 0;
                while (i < this.attributeNames.length) {
                    String attributeName = this.attributeNames[i];
                    String className = element.getAttribute(attributeName);
                    if (className != null && className.length() > 0) {
                        map.put(attributeName, className);
                    }
                    ++i;
                }
                this.nsKeyedExtensionRegistry.put(namespace, map, pluginClasssLoader);
            }
        }
    }
}

