/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.graph;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.WSDLElement;
import org.eclipse.wst.wsdl.XSDSchemaExtensibilityElement;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditor;
import org.eclipse.wst.wsdl.ui.internal.actions.CopyGlobalAction;
import org.eclipse.wst.wsdl.ui.internal.actions.DeleteWSDLAndXSDAction;
import org.eclipse.wst.wsdl.ui.internal.actions.PasteGlobalAction;
import org.eclipse.wst.wsdl.ui.internal.graph.GraphViewToolBar;
import org.eclipse.wst.wsdl.ui.internal.graph.WSDLComponentViewer;
import org.eclipse.wst.wsdl.ui.internal.graph.editparts.ComponentViewerRootEditPart;
import org.eclipse.wst.wsdl.ui.internal.graph.editparts.GroupEditPart;
import org.eclipse.wst.wsdl.ui.internal.graph.editparts.TreeNodeEditPart;
import org.eclipse.wst.wsdl.ui.internal.model.WSDLGroupObject;
import org.eclipse.wst.wsdl.ui.internal.util.SelectionAdapter;
import org.eclipse.wst.wsdl.ui.internal.util.WSDLEditorUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSDLGraphViewer
implements ISelectionChangedListener {
    protected Control componentViewerControl;
    protected WSDLComponentViewer componentViewer;
    protected Definition definition;
    protected WSDLEditor editor;
    protected InternalSelectionAdapter internalSelectionAdapter = new InternalSelectionAdapter();
    GraphViewToolBar form;
    Node inputNode;

    public WSDLGraphViewer(WSDLEditor editor) {
        this.editor = editor;
    }

    public void setDefinition(Definition definition) {
        this.definition = definition;
    }

    public ISelectionProvider getSelectionProvider() {
        return this.internalSelectionAdapter;
    }

    public Control createControl(Composite parent) {
        this.componentViewer = new WSDLComponentViewer(this.editor, this.editor.getSelectionManager());
        this.componentViewer.addSelectionChangedListener(this.internalSelectionAdapter);
        this.internalSelectionAdapter.addSelectionChangedListener(this.editor.getSelectionManager());
        this.form = new GraphViewToolBar(this.editor, parent, 0);
        this.componentViewerControl = this.componentViewer.createControl((Composite)this.form);
        this.form.setContent(this.componentViewerControl);
        this.editor.getSelectionManager().addSelectionChangedListener(this);
        this.componentViewerControl.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u007f') {
                    List selections = ((IStructuredSelection)WSDLGraphViewer.this.editor.getSelectionManager().getSelection()).toList();
                    DeleteWSDLAndXSDAction deleteAction = new DeleteWSDLAndXSDAction(selections, WSDLGraphViewer.this.editor.getDefinition().getElement(), WSDLGraphViewer.this.editor);
                    deleteAction.run();
                }
            }
        });
        return this.componentViewerControl;
    }

    public WSDLComponentViewer getComponentViewer() {
        return this.componentViewer;
    }

    public void setInput(Object object) {
        this.componentViewer.setInput(object);
    }

    public void setBackButtonEnabled(boolean state) {
        this.form.setBackButtonEnabled(state);
    }

    protected Object getInputComponentForNode(Node node) {
        return null;
    }

    protected Object getSelectionComponentForNode(Node node) {
        return null;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selectionObject = (IStructuredSelection)event.getSelection();
        Object modelObject = selectionObject.getFirstElement();
        if (modelObject instanceof WSDLElement) {
            Element node = ((WSDLElement)modelObject).getElement();
            boolean isEditable = node instanceof IDOMNode;
            CopyGlobalAction copyAction = new CopyGlobalAction((WSDLElement)modelObject, (IEditorPart)this.editor);
            PasteGlobalAction pasteAction = new PasteGlobalAction((WSDLElement)modelObject, (IEditorPart)this.editor);
            IActionBars actionBars = this.editor.getEditorSite().getActionBars();
            actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)copyAction);
            actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)pasteAction);
            actionBars.updateActionBars();
            if (!isEditable) {
                copyAction.setEnabled(false);
                pasteAction.setEnabled(false);
            }
        }
        if (event.getSource() != this.internalSelectionAdapter && event.getSource() != this.editor.getTextEditor().getSelectionProvider()) {
            IStructuredSelection selection;
            Object model;
            boolean isEmptySelectionRequired = true;
            if (event.getSelection() instanceof IStructuredSelection && (model = (selection = (IStructuredSelection)event.getSelection()).getFirstElement()) != null) {
                EditPart editPart = this.getEditPart((EditPart)this.componentViewer.getRootEditPart(), model);
                if (editPart == null) {
                    editPart = this.expandToReveal((EditPart)this.componentViewer.getRootEditPart(), model);
                }
                if (editPart == null) {
                    if (model instanceof XSDConcreteComponent) {
                        if ((model = this.getTopLevelComponent((XSDConcreteComponent)model)) instanceof XSDElementDeclaration || model instanceof XSDComplexTypeDefinition || model instanceof XSDModelGroupDefinition || model instanceof XSDSchema) {
                            this.componentViewer.setInput(model);
                        }
                    } else if (model instanceof WSDLElement || model instanceof WSDLGroupObject) {
                        this.componentViewer.setInput(this.editor.getDefinition());
                        editPart = this.getEditPart((EditPart)this.componentViewer.getRootEditPart(), model);
                        if (editPart == null) {
                            editPart = this.expandToReveal((EditPart)this.componentViewer.getRootEditPart(), model);
                        }
                    } else {
                        Node node = WSDLEditorUtil.getInstance().getNodeForObject(model);
                        Object o = WSDLEditorUtil.getInstance().findModelObjectForElement(this.editor.getDefinition(), (Element)node);
                        if (o instanceof XSDSchemaExtensibilityElement) {
                            XSDSchema obj = ((XSDSchemaExtensibilityElement)o).getSchema();
                            this.componentViewer.setInput(obj);
                        }
                    }
                }
                if (editPart != null) {
                    isEmptySelectionRequired = false;
                    this.componentViewer.setSelection((ISelection)new StructuredSelection((Object)editPart));
                    this.scrollIntoView(editPart);
                }
            }
            if (isEmptySelectionRequired) {
                this.componentViewer.setSelection((ISelection)new StructuredSelection());
            }
        }
    }

    protected XSDConcreteComponent getTopLevelComponent(XSDConcreteComponent component) {
        XSDConcreteComponent prev = component;
        XSDConcreteComponent container = component;
        while (container != null && !(container instanceof XSDSchema)) {
            prev = container;
            container = container.getContainer();
        }
        return container != null ? prev : null;
    }

    protected EditPart getEditPart(EditPart editPart, Object model) {
        EditPart result = null;
        if (editPart.getModel() == model) {
            result = editPart;
        } else {
            Iterator i = editPart.getChildren().iterator();
            while (i.hasNext()) {
                result = this.getEditPart((EditPart)i.next(), model);
                if (result != null) break;
            }
        }
        return result;
    }

    public EditPart expandToReveal(EditPart editPart, Object model) {
        ArrayList<Object> parentList = new ArrayList<Object>();
        Object o = model;
        while (o != null) {
            parentList.add(0, o);
            o = this.getParent(o);
        }
        EditPart result = this.expandToRevealHelper(editPart, parentList, 0);
        return result;
    }

    public EditPart expandToRevealHelper(EditPart editPart, List parentList, int index) {
        Object model;
        EditPart result = null;
        int parentListSize = parentList.size();
        Object v0 = model = index < parentListSize ? parentList.get(index) : null;
        if (model != null && editPart != null) {
            result = this.getEditPart(editPart, model);
        }
        if (result != null && index < parentListSize - 1) {
            if (result instanceof TreeNodeEditPart) {
                ((TreeNodeEditPart)result).setExpanded(true);
            }
            result = this.expandToRevealHelper(result, parentList, index + 1);
        }
        return result;
    }

    protected Object getParent(Object model) {
        EObject parent = null;
        if (model instanceof EObject) {
            parent = ((EObject)model).eContainer();
        }
        return parent;
    }

    public void scrollIntoView(EditPart editPart) {
        EditPart parent = editPart.getParent();
        while (parent != null) {
            if (parent instanceof GroupEditPart) {
                GroupEditPart groupEditPart = (GroupEditPart)parent;
                groupEditPart.scrollToRevealEditPart(editPart);
                break;
            }
            parent = parent.getParent();
        }
    }

    protected class InternalSelectionAdapter
    extends SelectionAdapter
    implements ISelectionChangedListener {
        protected InternalSelectionAdapter() {
        }

        public Object getObjectForOtherModel(Object object) {
            Object result = null;
            if (object instanceof EditPart && !(object instanceof ComponentViewerRootEditPart)) {
                EditPart editPart = (EditPart)object;
                result = editPart.getModel();
            }
            return result;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            this.setSelection(event.getSelection());
        }
    }
}

