/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.graph.editparts;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Import;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.gef.util.figures.RoundedLineBorder;
import org.eclipse.wst.wsdl.ui.internal.graph.editparts.GroupEditPart;
import org.eclipse.wst.wsdl.ui.internal.graph.editparts.PartReferenceSectionEditPart;
import org.eclipse.wst.wsdl.ui.internal.graph.editparts.TreeNodeEditPart;
import org.eclipse.wst.wsdl.ui.internal.graph.editparts.WSDLEditPart;
import org.eclipse.wst.wsdl.ui.internal.model.WSDLGroupObject;
import org.eclipse.wst.wsdl.ui.internal.util.OpenOnSelectionHelper;
import org.eclipse.wst.xsd.ui.internal.gef.util.figures.ContainerFigure;
import org.eclipse.wst.xsd.ui.internal.gef.util.figures.ContainerLayout;
import org.eclipse.wst.xsd.ui.internal.gef.util.figures.FillLayout;

public class DefinitionEditPart
extends WSDLEditPart
implements ISelectionChangedListener {
    protected Label label;
    protected ContainerFigure outlined;
    protected ContainerFigure rightContentPane;
    protected ContainerFigure topContentPane;
    protected ContainerFigure middleContentPane;
    protected ContainerFigure bottomContentPane;
    protected static final String SELECTED_EDIT_PART_REFERENCE = "SELECTED_EDIT_PART_REFERENCE";

    public void activate() {
        super.activate();
        this.getViewer().addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void deactivate() {
        this.getViewer().removeSelectionChangedListener((ISelectionChangedListener)this);
        super.deactivate();
    }

    protected IFigure[] initContentPanes() {
        IFigure[] contentPanes = new IFigure[]{this.rightContentPane, this.topContentPane, this.middleContentPane, this.bottomContentPane};
        return contentPanes;
    }

    protected int getContentPane(Object model) {
        int result = 0;
        if (model == SELECTED_EDIT_PART_REFERENCE) {
            result = 0;
        } else if (model instanceof WSDLGroupObject) {
            WSDLGroupObject groupObject = (WSDLGroupObject)model;
            switch (groupObject.getType()) {
                case 1: 
                case 6: {
                    result = 1;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    result = 2;
                    break;
                }
                case 7: {
                    result = 3;
                }
            }
        }
        return result;
    }

    protected EditPart createChild(Object model) {
        PartReferenceSectionEditPart editPart = null;
        if (model == SELECTED_EDIT_PART_REFERENCE) {
            editPart = new PartReferenceSectionEditPart();
            editPart.setModel(model);
            editPart.setParent((EditPart)this);
        } else {
            editPart = super.createChild(model);
        }
        return editPart;
    }

    protected IFigure createFigure() {
        ContainerFigure outer = new ContainerFigure();
        ContainerLayout anchoredLayout = new ContainerLayout(){

            protected int alignFigure(IFigure parent, IFigure child) {
                return child == DefinitionEditPart.this.outlined ? 0 : -1;
            }
        };
        outer.setLayoutManager((LayoutManager)anchoredLayout);
        outer.getContainerLayout().setHorizontal(true);
        this.outlined = new ContainerFigure();
        outer.add((IFigure)this.outlined);
        this.outlined.setLayoutManager((LayoutManager)new FillLayout());
        this.outlined.setBorder((Border)new RoundedLineBorder(1, 6));
        this.outlined.setForegroundColor(groupBorderColor);
        ContainerFigure rightPane = new ContainerFigure();
        rightPane.setBorder((Border)new MarginBorder(0, 0, 0, 300));
        rightPane.getContainerLayout().setHorizontal(false);
        outer.add((IFigure)rightPane);
        this.rightContentPane = new ContainerFigure();
        rightPane.add((IFigure)this.rightContentPane);
        this.rightContentPane.setBorder((Border)new MarginBorder(15, 20, 15, 15));
        ContainerFigure labelHolder = new ContainerFigure();
        this.outlined.add((IFigure)labelHolder);
        this.label = new Label();
        labelHolder.add((IFigure)this.label);
        this.label.setBorder((Border)new MarginBorder(2, 5, 0, 5));
        this.label.setFont(mediumFont);
        this.label.setText(WSDLEditorPlugin.getWSDLString("_UI_LABEL_DEFINITION"));
        this.label.setForegroundColor(ColorConstants.black);
        this.topContentPane = new ContainerFigure();
        this.outlined.add((IFigure)this.topContentPane);
        FillLayout fillLayout = new FillLayout(15);
        fillLayout.setHorizontal(true);
        this.topContentPane.setLayoutManager((LayoutManager)fillLayout);
        this.topContentPane.setBorder((Border)new MarginBorder(10, 10, 10, 10));
        this.middleContentPane = new ContainerFigure();
        this.outlined.add((IFigure)this.middleContentPane);
        fillLayout = new FillLayout(15);
        fillLayout.setHorizontal(true);
        this.middleContentPane.setLayoutManager((LayoutManager)fillLayout);
        this.middleContentPane.setBorder((Border)new MarginBorder(0, 10, 10, 10));
        this.bottomContentPane = new ContainerFigure();
        this.outlined.add((IFigure)this.bottomContentPane);
        this.bottomContentPane.setLayoutManager((LayoutManager)new FillLayout());
        this.bottomContentPane.setBorder((Border)new MarginBorder(0, 10, 10, 10));
        return outer;
    }

    public PartReferenceSectionEditPart getPartReferenceSectionEditPart() {
        PartReferenceSectionEditPart result = null;
        Iterator i = this.getChildren().iterator();
        while (i.hasNext()) {
            EditPart editPart = (EditPart)i.next();
            if (editPart.getModel() != SELECTED_EDIT_PART_REFERENCE) continue;
            result = (PartReferenceSectionEditPart)editPart;
            break;
        }
        return result;
    }

    public GroupEditPart getGroupEditPart(int type) {
        GroupEditPart result = null;
        Iterator i = this.getChildren().iterator();
        while (i.hasNext()) {
            GroupEditPart groupEditPart;
            Object o = i.next();
            if (!(o instanceof GroupEditPart) || (groupEditPart = (GroupEditPart)o).getType() != type) continue;
            result = groupEditPart;
            break;
        }
        return result;
    }

    public List getModelChildren() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(SELECTED_EDIT_PART_REFERENCE);
        list.addAll(super.getModelChildren());
        return list;
    }

    public void handleOpenRequest(EditPart editPart) {
        GroupEditPart groupEditPart = null;
        if (editPart.getModel() instanceof Import) {
            Import theImport = (Import)editPart.getModel();
            Definition definition = (Definition)this.getModel();
            OpenOnSelectionHelper helper = new OpenOnSelectionHelper(definition);
            helper.openEditor((EObject)theImport);
        } else {
            EditPart parent = editPart.getParent();
            while (parent != null) {
                if (parent instanceof GroupEditPart) {
                    groupEditPart = (GroupEditPart)parent;
                    break;
                }
                parent = parent.getParent();
            }
            if (groupEditPart != null) {
                GroupEditPart prevGroupEditPart;
                GroupEditPart nextGroupEditPart = groupEditPart.getNext();
                if (nextGroupEditPart != null && nextGroupEditPart.inputConnection instanceof TreeNodeEditPart) {
                    ((TreeNodeEditPart)nextGroupEditPart.inputConnection).setExpanded(true);
                }
                if ((prevGroupEditPart = groupEditPart.getPrevious()) != null && prevGroupEditPart.outputConnection instanceof TreeNodeEditPart) {
                    ((TreeNodeEditPart)prevGroupEditPart.outputConnection).setExpanded(true);
                }
            }
            this.updateConnections();
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateConnections();
    }

    public void updateConnections() {
        if (this.isActive()) {
            try {
                AbstractGraphicalEditPart selectedEditPart = this.getSelectedEditPart(this.getViewer().getSelection());
                GroupEditPart group = this.getContainingGroup(selectedEditPart);
                if (group != null && group.getConnectionManager() != null) {
                    group.getConnectionManager().setSelectedModelObject(selectedEditPart.getModel());
                } else if (!this.isAncestor((EditPart)this.getPartReferenceSectionEditPart(), (EditPart)selectedEditPart)) {
                    group = this.getGroupEditPart(4);
                    group.getConnectionManager().setSelectedModelObject(null);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public GroupEditPart getContainingGroup(AbstractGraphicalEditPart editPart) {
        GroupEditPart result = null;
        EditPart parent = editPart.getParent();
        while (parent != null) {
            if (parent instanceof GroupEditPart) {
                result = (GroupEditPart)parent;
                break;
            }
            parent = parent.getParent();
        }
        return result;
    }

    public GroupEditPart getNextGroupEditPart(GroupEditPart groupEditPart) {
        GroupEditPart result = null;
        GroupEditPart prev = null;
        Iterator i = this.getChildren().iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof GroupEditPart)) continue;
            GroupEditPart editPart = (GroupEditPart)o;
            if (prev == groupEditPart) {
                result = editPart;
                break;
            }
            prev = editPart;
        }
        return result;
    }

    public GroupEditPart getPreviousGroupEditPart(GroupEditPart groupEditPart) {
        GroupEditPart prev = null;
        Iterator i = this.getChildren().iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof GroupEditPart)) continue;
            GroupEditPart editPart = (GroupEditPart)o;
            if (editPart == groupEditPart) break;
            prev = editPart;
        }
        return prev;
    }

    protected AbstractGraphicalEditPart getSelectedEditPart(ISelection selection) {
        IStructuredSelection s;
        Object first;
        AbstractGraphicalEditPart editPart = null;
        if (selection instanceof IStructuredSelection && (first = (s = (IStructuredSelection)selection).getFirstElement()) instanceof AbstractGraphicalEditPart) {
            editPart = (AbstractGraphicalEditPart)first;
        }
        return editPart;
    }

    public void refreshChildren() {
        super.refreshChildren();
        this.updateConnections();
    }

    public boolean isAncestor(EditPart ancestor, EditPart child) {
        boolean result = false;
        if (ancestor != null && child != null) {
            EditPart editPart = child;
            while (editPart != null) {
                if (editPart == ancestor) {
                    result = true;
                    break;
                }
                editPart = editPart.getParent();
            }
        }
        return result;
    }
}

