/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.reconciler;

import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.internal.impl.DefinitionImpl;
import org.eclipse.wst.wsdl.internal.impl.WSDLElementImpl;
import org.eclipse.wst.wsdl.internal.impl.XSDSchemaExtensibilityElementImpl;
import org.eclipse.wst.wsdl.ui.internal.reconciler.ExtensibleNodeReconciler;
import org.eclipse.wst.wsdl.ui.internal.util.WSDLEditorUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.impl.XSDSchemaImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SEDDocumentAdapter {
    protected Document document;
    protected Definition definition;
    protected ExtensibleNodeReconciler extensibleNodeReconciler;

    public SEDDocumentAdapter(IStructuredModel model, Definition definition) {
        this.document = model instanceof IDOMModel ? ((IDOMModel)model).getDocument() : null;
        this.definition = definition;
        this.extensibleNodeReconciler = new ExtensibleNodeReconciler();
        new MyDocumentAdapter(this.document);
    }

    class MyDocumentAdapter
    extends DocumentAdapter {
        MyDocumentAdapter(Document document) {
            super(document);
        }

        public void notifyChanged(INodeNotifier notifier, int eventType, Object feature, Object oldValue, Object newValue, int index) {
            if (eventType == 2 && newValue instanceof Element) {
                String ns;
                this.adapt((Element)newValue);
                Element newDocumentElement = (Element)newValue;
                String wsdlPrefix = newDocumentElement.getPrefix();
                if (wsdlPrefix == null) {
                    wsdlPrefix = "";
                }
                if ((ns = SEDDocumentAdapter.this.definition.getNamespace(wsdlPrefix)) != null && ns.equals("http://schemas.xmlsoap.org/wsdl/") && newDocumentElement.getLocalName().equals("definitions")) {
                    SEDDocumentAdapter.this.definition.setElement(newDocumentElement);
                }
            }
            switch (eventType) {
                case 1: 
                case 4: 
                case 5: {
                    if (notifier instanceof Element) {
                        this.reconcileModelObjectForElement((Element)notifier, eventType, feature, oldValue, newValue, index);
                        break;
                    }
                    if (!(notifier instanceof Document)) break;
                    Document document = (Document)notifier;
                    Element definitionElement = null;
                    Node node = document.getFirstChild();
                    while (node != null) {
                        if (node.getNodeType() == 1) {
                            Element element = (Element)node;
                            if (WSDLEditorUtil.getInstance().getWSDLType(element) == 1) {
                                definitionElement = element;
                                break;
                            }
                        }
                        node = node.getNextSibling();
                    }
                    if (definitionElement != null) {
                        ((DefinitionImpl)SEDDocumentAdapter.this.definition).elementChanged(definitionElement);
                        break;
                    }
                    ((DefinitionImpl)SEDDocumentAdapter.this.definition).removeAll();
                }
            }
        }

        protected void reconcileModelObjectForElement(Element element, int eventType, Object feature, Object oldValue, Object newValue, int index) {
            Object modelObject = WSDLEditorUtil.getInstance().findModelObjectForElement(SEDDocumentAdapter.this.definition, element);
            if (modelObject != null) {
                if (modelObject instanceof XSDSchemaExtensibilityElementImpl) {
                    XSDSchemaExtensibilityElementImpl ee = (XSDSchemaExtensibilityElementImpl)modelObject;
                    ((XSDSchemaImpl)ee.getSchema()).elementChanged(element);
                    ee.elementChanged(element);
                } else if (modelObject instanceof WSDLElementImpl) {
                    ((WSDLElementImpl)modelObject).elementChanged(element);
                } else if (modelObject instanceof XSDConcreteComponent) {
                    ((XSDConcreteComponent)modelObject).elementChanged(element);
                    SEDDocumentAdapter.this.extensibleNodeReconciler.notifyChanged(modelObject, element, eventType, feature, oldValue, newValue, index);
                }
            }
        }
    }

    abstract class DocumentAdapter
    implements INodeAdapter {
        public DocumentAdapter(Document document) {
            ((INodeNotifier)document).addAdapter((INodeAdapter)this);
            Node child = document.getFirstChild();
            while (child != null) {
                if (child.getNodeType() == 1) {
                    this.adapt((Element)child);
                }
                child = child.getNextSibling();
            }
        }

        public void adapt(Element element) {
            if (element != null && ((INodeNotifier)element).getExistingAdapter((Object)this) == null) {
                ((INodeNotifier)element).addAdapter((INodeAdapter)this);
                Node child = element.getFirstChild();
                while (child != null) {
                    if (child.getNodeType() == 1) {
                        this.adapt((Element)child);
                    }
                    child = child.getNextSibling();
                }
            }
        }

        public boolean isAdapterForType(Object type) {
            return type == this;
        }

        public abstract void notifyChanged(INodeNotifier var1, int var2, Object var3, Object var4, Object var5, int var6);
    }
}

