/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.wizards;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Vector;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.PageBook;
import org.eclipse.wst.wsdl.ui.internal.WSDLEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.util.ValidateHelper;
import org.eclipse.wst.wsdl.ui.internal.wizards.NewWSDLWizard;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceInfo;
import org.eclipse.wst.xml.ui.internal.dialogs.UpdateListener;

public class WSDLNewFileOptionsPage
extends WizardPage
implements ModifyListener,
UpdateListener,
SelectionListener {
    protected Text targetNamespaceText;
    protected Text prefixText;
    protected boolean updatePortOpFieldBoolean = true;
    protected PageBook protocolPageBook;
    protected Combo protocolCombo;
    protected Composite soapPage;
    protected Composite httpPage;
    protected Button docLitRadio;
    protected Button rpcLitRadio;
    protected Button rpcEncRadio;
    protected Button httpGetRadio;
    protected Button httpPostRadio;
    protected DelayedEvent delayedTask;
    private static final String SOAP_PROTOCOL = "SOAP";
    private static final String HTTP_PROTOCOL = "HTTP";
    private static final String SOAP_RPC_ENCODED = WSDLEditorPlugin.getWSDLString("_UI_RADIO_RPC_ENCODED");
    private static final String SOAP_RPC_LITERAL = WSDLEditorPlugin.getWSDLString("_UI_RADIO_RPC_LITERAL");
    private static final String SOAP_DOCUMENT_LITERAL = WSDLEditorPlugin.getWSDLString("_UI_RADIO_DOCUMENT_LITERAL");
    private static final String HTTP_POST = "HTTP POST";
    private static final String HTTP_GET = "HTTP GET";
    Composite wsdlSkeletonGroup;
    Button createSkeletonCheckBox;
    Label sepLabel;

    public WSDLNewFileOptionsPage(String pageName) {
        super(pageName);
    }

    public WSDLNewFileOptionsPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setDescription(WSDLEditorPlugin.getWSDLString("_UI_DESCRIPTION_NEW_WSDL_FILE"));
    }

    public void createControl(Composite parent) {
        Composite base = new Composite(parent, 0);
        WorkbenchHelp.setHelp((Control)base, (String)WSDLEditorPlugin.getWSDLString("_UI_HELP"));
        base.setLayout((Layout)new GridLayout());
        Composite wsdlGroup = new Composite(base, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        wsdlGroup.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        wsdlGroup.setLayoutData((Object)data);
        GridData gd = (GridData)wsdlGroup.getLayoutData();
        gd.grabExcessHorizontalSpace = true;
        Label targetNamespace = new Label(wsdlGroup, 16384);
        targetNamespace.setText(WSDLEditorPlugin.getWSDLString("_UI_LABEL_TARGET_NAMESPACE"));
        GridData nsData = new GridData();
        nsData.horizontalAlignment = 4;
        targetNamespace.setLayoutData((Object)nsData);
        this.targetNamespaceText = new Text(wsdlGroup, 2052);
        GridData textData = new GridData();
        textData.horizontalAlignment = 4;
        textData.grabExcessHorizontalSpace = true;
        textData.widthHint = 10;
        this.targetNamespaceText.setLayoutData((Object)textData);
        this.targetNamespaceText.addModifyListener((ModifyListener)this);
        Label prefix = new Label(wsdlGroup, 16384);
        prefix.setText(WSDLEditorPlugin.getWSDLString("_UI_LABEL_PREFIX_WITH_COLON"));
        GridData prefixData = new GridData();
        prefixData.horizontalAlignment = 4;
        prefix.setLayoutData((Object)prefixData);
        this.prefixText = new Text(wsdlGroup, 2052);
        GridData prefixTextData = new GridData();
        prefixTextData.horizontalAlignment = 4;
        prefixTextData.grabExcessHorizontalSpace = true;
        prefixTextData.widthHint = 10;
        this.prefixText.setLayoutData((Object)prefixTextData);
        this.prefixText.addModifyListener((ModifyListener)this);
        this.createSkeletonCheckBox = new Button(base, 32);
        this.createSkeletonCheckBox.setText(WSDLEditorPlugin.getWSDLString("_UI_LABEL_CREATE_WSDL_SKELETON"));
        this.createSkeletonCheckBox.setSelection(true);
        this.wsdlSkeletonGroup = new Composite(base, 0);
        GridLayout layout2 = new GridLayout();
        layout2.numColumns = 2;
        this.wsdlSkeletonGroup.setLayout((Layout)layout2);
        GridData data2 = new GridData();
        data2.verticalAlignment = 4;
        data2.horizontalAlignment = 4;
        this.wsdlSkeletonGroup.setLayoutData((Object)data2);
        this.createLabel(this.wsdlSkeletonGroup, WSDLEditorPlugin.getWSDLString("_UI_LABEL_BINDING_PROTOCOL"));
        this.protocolCombo = new Combo(this.wsdlSkeletonGroup, 8);
        GridData dataC = new GridData();
        dataC.horizontalAlignment = 4;
        dataC.grabExcessHorizontalSpace = true;
        this.protocolCombo.setLayoutData((Object)dataC);
        this.protocolCombo.add(SOAP_PROTOCOL);
        this.protocolCombo.add(HTTP_PROTOCOL);
        this.protocolCombo.select(0);
        this.protocolCombo.addModifyListener((ModifyListener)this);
        this.sepLabel = new Label(base, 258);
        GridData sepData = new GridData();
        sepData.horizontalAlignment = 4;
        sepData.grabExcessHorizontalSpace = true;
        this.sepLabel.setLayoutData((Object)sepData);
        this.protocolPageBook = new PageBook(base, 0);
        this.soapPage = new Composite((Composite)this.protocolPageBook, 0);
        GridLayout pbLayout = new GridLayout();
        this.soapPage.setLayout((Layout)pbLayout);
        GridData pbData = new GridData();
        pbData.verticalAlignment = 4;
        pbData.horizontalAlignment = 4;
        this.soapPage.setLayoutData((Object)pbData);
        this.createLabel(this.soapPage, WSDLEditorPlugin.getWSDLString("_UI_LABEL_SOAP_BINDING_OPTIONS"));
        this.docLitRadio = new Button(this.soapPage, 16);
        this.rpcLitRadio = new Button(this.soapPage, 16);
        this.rpcEncRadio = new Button(this.soapPage, 16);
        this.docLitRadio.setText(SOAP_DOCUMENT_LITERAL);
        this.rpcLitRadio.setText(SOAP_RPC_LITERAL);
        this.rpcEncRadio.setText(SOAP_RPC_ENCODED);
        this.docLitRadio.setSelection(true);
        this.httpPage = new Composite((Composite)this.protocolPageBook, 0);
        pbLayout = new GridLayout();
        this.httpPage.setLayout((Layout)pbLayout);
        pbData = new GridData();
        pbData.verticalAlignment = 4;
        pbData.horizontalAlignment = 4;
        this.httpPage.setLayoutData((Object)pbData);
        this.createLabel(this.httpPage, WSDLEditorPlugin.getWSDLString("_UI_LABEL_HTTP_BINDING_OPTIONS"));
        this.httpGetRadio = new Button(this.httpPage, 16);
        this.httpPostRadio = new Button(this.httpPage, 16);
        this.httpGetRadio.setText(HTTP_GET);
        this.httpPostRadio.setText(HTTP_POST);
        this.httpGetRadio.setSelection(true);
        this.wsdlSkeletonGroup.setVisible(true);
        this.sepLabel.setVisible(true);
        this.protocolPageBook.showPage((Control)this.soapPage);
        this.protocolPageBook.setVisible(true);
        this.createSkeletonCheckBox.addSelectionListener((SelectionListener)this);
        this.setControl((Control)base);
    }

    private NewWSDLWizard getNewWSDLWizard() {
        return (NewWSDLWizard)this.getWizard();
    }

    private String computeDefaultDefinitionName() {
        String name = "DefaultName";
        IPath path = this.getNewWSDLWizard().getNewFilePath();
        if (path != null) {
            name = path.removeFileExtension().lastSegment().toString();
        }
        return name;
    }

    private String computeDefaultNamespaceName() {
        IPath path;
        String namespace = WSDLEditorPlugin.getInstance().getPreferenceStore().getString(WSDLEditorPlugin.getWSDLString("_UI_PREF_PAGE_DEFAULT_TARGET_NAMESPACE"));
        if (!namespace.endsWith("/")) {
            namespace = namespace.concat("/");
        }
        if ((path = this.getNewWSDLWizard().getNewFilePath()) != null) {
            namespace = String.valueOf(namespace) + path.removeFileExtension().toString() + "/";
        }
        return namespace;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.targetNamespaceText.setText(this.computeDefaultNamespaceName());
            this.prefixText.setText("tns");
        }
    }

    public String getTargetNamespace() {
        return this.targetNamespaceText.getText();
    }

    public String getPrefix() {
        return this.prefixText.getText().trim();
    }

    public String getDefinitionName() {
        return this.computeDefaultDefinitionName();
    }

    public void modifyText(ModifyEvent e) {
        if (e.widget == this.targetNamespaceText) {
            this.startDelayedEvent(e);
        } else if (e.widget == this.prefixText) {
            this.setPageComplete(this.isPageComplete());
        } else if (e.widget == this.protocolCombo) {
            if (this.protocolCombo.getText().equals(SOAP_PROTOCOL)) {
                this.protocolPageBook.showPage((Control)this.soapPage);
            } else if (this.protocolCombo.getText().equals(HTTP_PROTOCOL)) {
                this.protocolPageBook.showPage((Control)this.httpPage);
            }
        }
    }

    public void updateOccured(Object arg1, Object arg2) {
        this.setPageComplete(this.isPageComplete());
    }

    public boolean isPageComplete() {
        boolean ready = true;
        this.setErrorMessage(null);
        if (this.targetNamespaceText.getText().trim().equals("")) {
            if (ready) {
                this.setErrorMessage(null);
            }
            return false;
        }
        if (!this.validateTargetNamespace(this.targetNamespaceText.getText())) {
            ready = false;
        }
        return ready;
    }

    protected boolean validatePrefix(String prefix) {
        String errorMessage = ValidateHelper.checkXMLPrefix(prefix);
        return errorMessage == null || errorMessage.length() == 0;
    }

    protected boolean validateXMLName(String xmlName) {
        String errorMessage = ValidateHelper.checkXMLName(xmlName);
        if (errorMessage == null || errorMessage.length() == 0) {
            return true;
        }
        this.setErrorMessage(errorMessage);
        return false;
    }

    protected boolean validateTargetNamespace(String ns) {
        boolean test = true;
        try {
            new URI(ns);
        }
        catch (URISyntaxException uRISyntaxException) {
            this.setErrorMessage(WSDLEditorPlugin.getWSDLString("_UI_ERROR_NAMESPACE_INVALID"));
            test = false;
        }
        return test;
    }

    protected void startDelayedEvent(ModifyEvent e) {
        if (this.delayedTask == null || this.delayedTask.getEvent() == null) {
            this.delayedTask = new DelayedEvent();
            this.delayedTask.setEvent(e);
            Display.getDefault().timerExec(500, (Runnable)this.delayedTask);
        } else {
            ModifyEvent delayedEvent = this.delayedTask.getEvent();
            if (e.widget == delayedEvent.widget) {
                this.delayedTask.setEvent(null);
            }
            this.delayedTask = new DelayedEvent();
            this.delayedTask.setEvent(e);
            Display.getDefault().timerExec(500, (Runnable)this.delayedTask);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.createSkeletonCheckBox) {
            if (this.createSkeletonCheckBox.getSelection()) {
                this.wsdlSkeletonGroup.setVisible(true);
                this.sepLabel.setVisible(true);
                this.protocolPageBook.setVisible(true);
            } else {
                this.wsdlSkeletonGroup.setVisible(false);
                this.sepLabel.setVisible(false);
                this.protocolPageBook.setVisible(false);
            }
        }
    }

    private Label createLabel(Composite comp, String labelString) {
        Label label = new Label(comp, 16384);
        label.setText(labelString);
        GridData nsData = new GridData();
        nsData.horizontalAlignment = 4;
        label.setLayoutData((Object)nsData);
        return label;
    }

    public Vector getNamespaceInfo() {
        Vector<NamespaceInfo> namespaces = new Vector<NamespaceInfo>();
        NamespaceInfo info1 = new NamespaceInfo();
        info1.prefix = "wsdl";
        info1.uri = "http://schemas.xmlsoap.org/wsdl/";
        namespaces.addElement(info1);
        NamespaceInfo info8 = new NamespaceInfo();
        info8.prefix = "xsd";
        info8.uri = "http://www.w3.org/2001/XMLSchema";
        namespaces.addElement(info8);
        return namespaces;
    }

    public boolean getCreateSkeletonBoolean() {
        return this.createSkeletonCheckBox.getSelection();
    }

    public String getProtocol() {
        return this.protocolCombo.getText();
    }

    public Object[] getProtocolOptions() {
        Object[] bool = new Boolean[3];
        if (this.protocolCombo.getText().equals(SOAP_PROTOCOL)) {
            bool[0] = this.docLitRadio.getSelection() ? new Boolean(true) : new Boolean(false);
            bool[2] = this.rpcLitRadio.getSelection() ? new Boolean(true) : new Boolean(false);
        } else if (this.protocolCombo.getText().equals(HTTP_PROTOCOL)) {
            bool[0] = this.httpGetRadio.getSelection() ? new Boolean(false) : new Boolean(true);
        }
        return bool;
    }

    public boolean isSoapDocLiteralProtocol() {
        return this.getProtocol().equals(SOAP_PROTOCOL) && this.docLitRadio.getSelection();
    }

    class DelayedEvent
    implements Runnable {
        protected ModifyEvent event;

        DelayedEvent() {
        }

        public void run() {
            if (this.event != null) {
                WSDLNewFileOptionsPage.this.setPageComplete(WSDLNewFileOptionsPage.this.isPageComplete());
                this.event = null;
            }
        }

        public ModifyEvent getEvent() {
            return this.event;
        }

        public void setEvent(ModifyEvent event) {
            this.event = event;
        }
    }
}

