/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.validation.internal;

import java.util.Locale;
import java.util.ResourceBundle;
import org.eclipse.wst.wsdl.validation.internal.IWSDLValidator;

public class WSDLValidatorDelegate {
    private String validatorClassname = null;
    private String resourceBundle = null;
    private ClassLoader classLoader = null;
    private IWSDLValidator validator = null;

    public WSDLValidatorDelegate(String validatorClassname, String resourceBundle) {
        this.validatorClassname = validatorClassname;
        this.resourceBundle = resourceBundle;
    }

    public WSDLValidatorDelegate(String validatorClassname, String resourceBundle, ClassLoader classLoader) {
        this(validatorClassname, resourceBundle);
        this.classLoader = classLoader;
    }

    public IWSDLValidator getValidator() {
        if (this.validator == null) {
            if (this.classLoader == null) {
                this.classLoader = this.getClass().getClassLoader();
            }
            try {
                Class<?> validatorClass = this.classLoader != null ? this.classLoader.loadClass(this.validatorClassname) : Class.forName(this.validatorClassname);
                this.validator = (IWSDLValidator)validatorClass.newInstance();
                if (this.resourceBundle != null) {
                    ResourceBundle validatorBundle = ResourceBundle.getBundle(this.resourceBundle, Locale.getDefault(), this.classLoader);
                    this.validator.setResourceBundle(validatorBundle);
                }
            }
            catch (Exception e) {
                System.err.println(e);
            }
            catch (Throwable t) {
                System.err.println(t);
            }
        }
        return this.validator;
    }

    public String getValidatorClassName() {
        return this.validatorClassname;
    }
}

