/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.internal.generator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.wst.wsdl.Binding;
import org.eclipse.wst.wsdl.Port;
import org.eclipse.wst.wsdl.Service;
import org.eclipse.wst.wsdl.WSDLFactory;
import org.eclipse.wst.wsdl.internal.generator.BaseGenerator;

public class PortGenerator
extends BaseGenerator {
    private Service service;

    public PortGenerator(Service service) {
        this.service = service;
        this.definition = service.getEnclosingDefinition();
    }

    public Port generatePort() {
        this.getName();
        this.getRefName();
        Port port = WSDLFactory.eINSTANCE.createPort();
        port.setName(this.getName());
        port.setEnclosingDefinition(this.service.getEnclosingDefinition());
        port.setBinding(this.getBinding(this.getRefName()));
        this.service.addPort(port);
        if (this.getContentGenerator() != null) {
            this.getContentGenerator().generatePortContent(port);
        }
        return port;
    }

    private Binding getBinding(String bindingName) {
        Iterator bindingIt = this.definition.getEBindings().iterator();
        while (bindingIt.hasNext()) {
            Binding binding = (Binding)bindingIt.next();
            binding.getQName().getLocalPart();
            binding.getQName().getNamespaceURI();
            List prefixedNames = this.getPrefixedNames(binding);
            if (!prefixedNames.contains(bindingName)) continue;
            return binding;
        }
        return null;
    }

    private List getPrefixedNames(Binding binding) {
        ArrayList<String> prefixedNames = new ArrayList<String>();
        String currentBindingName = binding.getQName().getLocalPart();
        String currentNamespace = binding.getQName().getNamespaceURI();
        Map namespaceMap = this.definition.getNamespaces();
        Iterator keys = namespaceMap.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            Object value = namespaceMap.get(key);
            if (!currentNamespace.equals(value)) continue;
            prefixedNames.add(key + ":" + currentBindingName);
        }
        return prefixedNames;
    }

    public Service getService() {
        return this.service;
    }
}

