/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.validate.wsdl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import org.eclipse.wst.wsdl.validation.internal.IValidationInfo;
import org.eclipse.wst.wsdl.validation.internal.IWSDLValidator;
import org.eclipse.wst.wsdl.validation.internal.ValidationInfoImpl;
import org.eclipse.wst.wsdl.validation.internal.exception.ValidateWSDLException;
import org.eclipse.wst.wsdl.validation.internal.util.MessageGenerator;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.IWSDL11ValidationInfo;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.WSDL11ValidationInfoImpl;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.WSDLDocument;
import org.eclipse.wst.wsdl.validation.internal.wsdl11.WSDLReaderImpl;
import org.eclipse.wst.wsi.internal.WSIPreferences;
import org.eclipse.wst.wsi.internal.WSITestToolsEclipseProperties;
import org.eclipse.wst.wsi.internal.WSITestToolsProperties;
import org.eclipse.wst.wsi.internal.analyzer.WSDLAnalyzer;
import org.eclipse.wst.wsi.internal.analyzer.WSIAnalyzerException;
import org.eclipse.wst.wsi.internal.report.AssertionError;
import org.w3c.dom.Document;

public class WSDLValidator
implements IWSDLValidator {
    protected final String _EXC_UNABLE_TO_VALIDATE_WSI = "_EXC_UNABLE_TO_VALIDATE_WSI";
    protected final int ERROR = 2;
    protected final int WARNING = 1;
    protected MessageGenerator messagegenerator = null;
    protected boolean wsiValid = false;

    public void validate(Document domModel, IValidationInfo valInfo) throws ValidateWSDLException {
        boolean withAttachments = false;
        boolean withBasic = false;
        Object attValue = valInfo.getAttribute("http://ws-i.org/profiles/BasicWithAttachments/ComplianceLevel");
        if (attValue == null) {
            attValue = valInfo.getAttribute("http://ws-i.org/profiles/Basic/ComplianceLevel");
            if (attValue != null) {
                withBasic = true;
            }
        } else {
            withAttachments = true;
        }
        String wsiLevel = "1";
        if (attValue != null) {
            String value = (String)attValue;
            if (value.equals("IGNORE")) {
                wsiLevel = "2";
            } else if (value.equals("REQUIRE")) {
                wsiLevel = "0";
            }
        } else {
            wsiLevel = WSITestToolsProperties.getEclipseContext() ? WSITestToolsEclipseProperties.checkWSIPreferences(valInfo.getFileURI()).getComplianceLevel() : WSITestToolsProperties.checkWSIPreferences(valInfo.getFileURI()).getComplianceLevel();
        }
        if (wsiLevel.equals("2")) {
            return;
        }
        this.wsiValid = true;
        Definition definition = null;
        boolean hasAnalyzerConfig = false;
        String uri = valInfo.getFileURI();
        try {
            ValidationInfoImpl vali = new ValidationInfoImpl(valInfo.getFileURI(), this.messagegenerator);
            vali.setURIResolver(valInfo.getURIResolver());
            WSDLReaderImpl reader = new WSDLReaderImpl((IWSDL11ValidationInfo)new WSDL11ValidationInfoImpl((IValidationInfo)vali));
            WSDLDocument[] docs = reader.readWSDL(uri, domModel);
            int numdocs = docs.length;
            int i = 0;
            while (i < numdocs) {
                WSDLDocument tempDoc = docs[i];
                if (tempDoc.getDefinition().getDocumentBaseURI().equals(valInfo.getFileURI())) {
                    definition = tempDoc.getDefinition();
                    break;
                }
                ++i;
            }
        }
        catch (WSDLException wSDLException) {
            throw new ValidateWSDLException(this.messagegenerator.getString("_EXC_UNABLE_TO_VALIDATE_WSI", (Object)uri));
        }
        if (definition != null && valInfo != null) {
            WSDLAnalyzer wsdlAnalyzer;
            WSIPreferences preferences;
            String namespace = definition.getTargetNamespace();
            Collection services = definition.getServices().values();
            Collection bindings = definition.getBindings().values();
            Collection portTypes = definition.getPortTypes().values();
            Collection messages = definition.getMessages().values();
            if (withAttachments) {
                preferences = new WSIPreferences();
                preferences.setComplianceLevel(wsiLevel);
                preferences.setTADFile(WSITestToolsProperties.AP_ASSERTION_FILE);
                wsdlAnalyzer = new WSDLAnalyzer(uri, preferences);
            } else if (withBasic) {
                preferences = new WSIPreferences();
                preferences.setComplianceLevel(wsiLevel);
                preferences.setTADFile(WSITestToolsProperties.SSBP_ASSERTION_FILE);
                wsdlAnalyzer = new WSDLAnalyzer(uri, preferences);
            } else {
                wsdlAnalyzer = new WSDLAnalyzer(uri);
            }
            if (services != null && !services.isEmpty()) {
                Iterator serviceIterator = services.iterator();
                while (serviceIterator.hasNext()) {
                    Service service = (Service)serviceIterator.next();
                    String servicename = service.getQName().getLocalPart();
                    Collection ports = service.getPorts().values();
                    if (ports == null || ports.isEmpty()) continue;
                    Iterator portIterator = ports.iterator();
                    while (portIterator.hasNext()) {
                        Port port = (Port)portIterator.next();
                        try {
                            wsdlAnalyzer.addConfigurationToTest(servicename, namespace, port.getName(), "port");
                            hasAnalyzerConfig = true;
                        }
                        catch (WSIAnalyzerException wSIAnalyzerException) {}
                    }
                }
            } else if (bindings != null && !bindings.isEmpty()) {
                Iterator bindingIterator = bindings.iterator();
                while (bindingIterator.hasNext()) {
                    Binding binding = (Binding)bindingIterator.next();
                    String bindingname = binding.getQName().getLocalPart();
                    try {
                        wsdlAnalyzer.addConfigurationToTest(null, namespace, bindingname, "binding");
                        hasAnalyzerConfig = true;
                    }
                    catch (WSIAnalyzerException wSIAnalyzerException) {}
                }
            } else if (portTypes != null && !portTypes.isEmpty()) {
                Iterator portTypeIterator = portTypes.iterator();
                while (portTypeIterator.hasNext()) {
                    PortType portType = (PortType)portTypeIterator.next();
                    String portTypename = portType.getQName().getLocalPart();
                    try {
                        wsdlAnalyzer.addConfigurationToTest(null, namespace, portTypename, "portType");
                        hasAnalyzerConfig = true;
                    }
                    catch (WSIAnalyzerException wSIAnalyzerException) {}
                }
            } else if (messages != null && !messages.isEmpty()) {
                Iterator messageIterator = messages.iterator();
                while (messageIterator.hasNext()) {
                    Message message = (Message)messageIterator.next();
                    String messagename = message.getQName().getLocalPart();
                    try {
                        wsdlAnalyzer.addConfigurationToTest(null, namespace, messagename, "message");
                        hasAnalyzerConfig = true;
                    }
                    catch (WSIAnalyzerException wSIAnalyzerException) {}
                }
            }
            try {
                if (hasAnalyzerConfig) {
                    wsdlAnalyzer.validateConformance();
                    if (wsdlAnalyzer.getWSIPreferences().getComplianceLevel().equals("1")) {
                        this.addWarnings(wsdlAnalyzer.getAssertionErrors(), valInfo);
                    } else {
                        this.addErrors(wsdlAnalyzer.getAssertionErrors(), valInfo);
                    }
                    this.addWarnings(wsdlAnalyzer.getAssertionWarnings(), valInfo);
                }
            }
            catch (WSIAnalyzerException e) {
                valInfo.addWarning("WS-I: A problem occured while running the WS-I WSDL conformance check: " + e, 1, 0, valInfo.getFileURI());
            }
        }
    }

    protected void addErrors(List errors, IValidationInfo valInfo) {
        this.reportProblems(errors, valInfo, 2);
    }

    protected void addWarnings(List warnings, IValidationInfo valInfo) {
        this.reportProblems(warnings, valInfo, 1);
    }

    protected void reportProblems(List problems, IValidationInfo valInfo, int type) {
        if (problems == null) {
            return;
        }
        Iterator problemsIterator = problems.iterator();
        while (problemsIterator.hasNext()) {
            AssertionError assertionerror = (AssertionError)problemsIterator.next();
            if (type == 2) {
                this.wsiValid = false;
                valInfo.addError("WS-I: (" + assertionerror.getAssertionID() + ") " + assertionerror.getErrorMessage(), assertionerror.getLine(), assertionerror.getColumn(), valInfo.getFileURI());
                continue;
            }
            if (type != 1) continue;
            valInfo.addWarning("WS-I: (" + assertionerror.getAssertionID() + ") " + assertionerror.getErrorMessage(), assertionerror.getLine(), assertionerror.getColumn(), valInfo.getFileURI());
        }
    }

    public void setResourceBundle(ResourceBundle rb) {
        this.messagegenerator = new MessageGenerator(rb);
    }

    public boolean isValid() {
        return this.wsiValid;
    }
}

