/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.xsd.ui.internal.Logger;
import org.eclipse.wst.xsd.ui.internal.XSDEditor;
import org.eclipse.xsd.XSDConcreteComponent;

public class XSDHyperlink
implements IHyperlink {
    private IRegion fRegion;
    private XSDConcreteComponent fComponent;

    public XSDHyperlink(IRegion region, XSDConcreteComponent component) {
        this.fRegion = region;
        this.fComponent = component;
    }

    public IRegion getHyperlinkRegion() {
        return this.fRegion;
    }

    public String getTypeLabel() {
        return null;
    }

    public String getHyperlinkText() {
        return null;
    }

    public void open() {
        if (this.fComponent.getSchema() != null) {
            IWorkbenchWindow workbenchWindow;
            String schemaLocation = URIHelper.removePlatformResourceProtocol((String)this.fComponent.getSchema().getSchemaLocation());
            Path schemaPath = new Path(schemaLocation);
            IFile schemaFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)schemaPath);
            if (schemaFile != null && schemaFile.exists() && (workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null) {
                IWorkbenchPage page = workbenchWindow.getActivePage();
                try {
                    IEditorPart editorPart = IDE.openEditor((IWorkbenchPage)page, (IFile)schemaFile, (boolean)true);
                    if (editorPart instanceof XSDEditor) {
                        ((XSDEditor)editorPart).openOnGlobalReference(this.fComponent);
                    }
                }
                catch (PartInitException pie) {
                    Logger.log(202, pie.getMessage(), pie);
                }
            }
        }
    }
}

