/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.dialogs.types.xml;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.wst.xsd.ui.internal.dialogs.types.common.IComponentList;
import org.eclipse.wst.xsd.ui.internal.dialogs.types.common.IComponentSelectionProvider;
import org.eclipse.wst.xsd.ui.internal.dialogs.types.xml.XMLComponentSpecification;

public abstract class XMLComponentSelectionProvider
implements IComponentSelectionProvider {
    public List getQualifiers(Object component) {
        ArrayList<String> qualifiers = new ArrayList<String>();
        if (component != null) {
            XMLComponentTreeObject specification = (XMLComponentTreeObject)component;
            Iterator it = specification.getXMLComponentSpecification().iterator();
            while (it.hasNext()) {
                XMLComponentSpecification spec = (XMLComponentSpecification)it.next();
                qualifiers.add(this.createQualifierText(spec));
            }
        }
        return qualifiers;
    }

    protected String createQualifierText(XMLComponentSpecification spec) {
        Path path = new Path(spec.getFileLocation());
        return String.valueOf(spec.getTargetNamespace()) + " - " + path.lastSegment();
    }

    protected void addDataItemToTreeNode(IComponentList comps, XMLComponentSpecification dataItem) {
        boolean foundMatch = false;
        Iterator it = comps.iterator();
        XMLComponentTreeObject containingTreeObject = null;
        while (it.hasNext()) {
            String existingPath;
            XMLComponentTreeObject treeObject = (XMLComponentTreeObject)it.next();
            if (!treeObject.getName().equals(dataItem.getAttributeInfo("name")) || treeObject.getXMLComponentSpecification().size() <= 0 || !(existingPath = ((XMLComponentSpecification)treeObject.getXMLComponentSpecification().get(0)).getTagPath()).equals(dataItem.getTagPath())) continue;
            containingTreeObject = treeObject;
            foundMatch = true;
            break;
        }
        if (!foundMatch) {
            containingTreeObject = new XMLComponentTreeObject(dataItem);
            comps.addComponent(containingTreeObject);
        } else {
            Iterator existingQualifiers = this.getQualifiers(containingTreeObject).iterator();
            boolean alreadyExists = false;
            while (existingQualifiers.hasNext()) {
                String newItemText;
                String existingText = (String)existingQualifiers.next();
                if (!existingText.equals(newItemText = this.createQualifierText(dataItem))) continue;
                alreadyExists = true;
                break;
            }
            if (!alreadyExists) {
                containingTreeObject.addXMLComponentSpecification(dataItem);
            }
        }
    }

    protected String getNormalizedLocation(String location) {
        try {
            URL url = new URL(location);
            URL resolvedURL = Platform.resolve((URL)url);
            location = resolvedURL.getPath();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return location;
    }

    public class XMLComponentTreeObject {
        private String name;
        private List xmlComponentSpecifications = new ArrayList();

        public XMLComponentTreeObject(XMLComponentSpecification spec) {
            this.xmlComponentSpecifications.add(spec);
            this.name = (String)spec.getAttributeInfo("name");
        }

        public String getName() {
            return this.name;
        }

        public void addXMLComponentSpecification(XMLComponentSpecification spec) {
            this.xmlComponentSpecifications.add(spec);
        }

        public List getXMLComponentSpecification() {
            return this.xmlComponentSpecifications;
        }
    }

    public class XMLComponentSelectionLabelProvider
    extends LabelProvider {
        public String getText(Object element) {
            XMLComponentTreeObject specification = (XMLComponentTreeObject)element;
            return specification.getName();
        }
    }
}

