/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.gef.util.figures;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.wst.xsd.ui.internal.gef.util.figures.ContainerFigure;
import org.eclipse.wst.xsd.ui.internal.gef.util.figures.IConnectedEditPartFigure;

public class ConnectedEditPartFigure
extends ContainerFigure
implements IConnectedEditPartFigure {
    protected EditPart editPart;
    protected boolean childConnectionsEnabled = true;
    protected List connectedFigures = new ArrayList();
    protected int connectionType = 4;

    public ConnectedEditPartFigure(EditPart editPart) {
        this.editPart = editPart;
    }

    public void setChildConnectionsEnabled(boolean enabled) {
        this.childConnectionsEnabled = enabled;
    }

    protected IConnectedEditPartFigure getParentGraphNodeFigure() {
        IConnectedEditPartFigure result = null;
        EditPart parentEditPart = this.editPart.getParent();
        while (parentEditPart != null) {
            IConnectedEditPartFigure graphNodeFigure;
            IFigure figure = ((AbstractGraphicalEditPart)parentEditPart).getFigure();
            if (figure instanceof IConnectedEditPartFigure && (graphNodeFigure = (IConnectedEditPartFigure)figure).getConnectionFigure() != null) {
                result = graphNodeFigure;
                break;
            }
            parentEditPart = parentEditPart.getParent();
        }
        return result;
    }

    public void addNotify() {
        IConnectedEditPartFigure parentGraphNodeFigure;
        super.addNotify();
        if (this.getConnectionFigure() != null && (parentGraphNodeFigure = this.getParentGraphNodeFigure()) != null) {
            parentGraphNodeFigure.addConnectedFigure(this);
        }
    }

    public void removeNotify() {
        IConnectedEditPartFigure parentGraphNodeFigure;
        super.removeNotify();
        if (this.getConnectionFigure() != null && (parentGraphNodeFigure = this.getParentGraphNodeFigure()) != null) {
            parentGraphNodeFigure.removeConnectedFigure(this);
        }
    }

    public void addConnectedFigure(IConnectedEditPartFigure figure) {
        if (this.childConnectionsEnabled && !this.connectedFigures.contains(figure)) {
            this.connectedFigures.add(figure);
        }
    }

    public void removeConnectedFigure(IConnectedEditPartFigure figure) {
        if (this.childConnectionsEnabled) {
            this.connectedFigures.remove(figure);
        }
    }

    public IFigure getSelectionFigure() {
        return this;
    }

    public IFigure getConnectionFigure() {
        return this;
    }

    public List getConnectedFigures(int type) {
        ArrayList<IConnectedEditPartFigure> list = new ArrayList<IConnectedEditPartFigure>();
        Iterator i = this.connectedFigures.iterator();
        while (i.hasNext()) {
            IConnectedEditPartFigure figure = (IConnectedEditPartFigure)i.next();
            list.add(figure);
        }
        return list;
    }

    public int getConnectionType() {
        return this.connectionType;
    }

    public void setConnectionType(int type) {
        this.connectionType = type;
    }
}

