/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.properties.section;

import java.util.Iterator;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wst.common.ui.internal.viewers.NavigableTableViewer;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.actions.DOMAttribute;
import org.eclipse.wst.xsd.ui.internal.properties.XSDComboBoxPropertyDescriptor;
import org.eclipse.wst.xsd.ui.internal.properties.section.FacetsSection;
import org.eclipse.wst.xsd.ui.internal.properties.section.WindowUtility;
import org.eclipse.wst.xsd.ui.internal.util.XSDDOMHelper;
import org.eclipse.xsd.XSDConstrainingFacet;
import org.eclipse.xsd.XSDLengthFacet;
import org.eclipse.xsd.XSDMaxExclusiveFacet;
import org.eclipse.xsd.XSDMaxFacet;
import org.eclipse.xsd.XSDMaxInclusiveFacet;
import org.eclipse.xsd.XSDMinExclusiveFacet;
import org.eclipse.xsd.XSDMinFacet;
import org.eclipse.xsd.XSDMinInclusiveFacet;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.impl.XSDFactoryImpl;
import org.w3c.dom.Element;

public class FacetViewer
extends NavigableTableViewer
implements ICellModifier {
    public static final String FACET_NAME = XSDEditorPlugin.getXSDString("_UI_FACET_NAME");
    public static final String FACET_VALUE = XSDEditorPlugin.getXSDString("_UI_FACET_VALUE");
    public static final String FACET_OTHER = XSDEditorPlugin.getXSDString("_UI_FACET_FIXED");
    protected FacetsTableLabelProvider facetsTableLabelProvider = new FacetsTableLabelProvider();
    protected FacetsTableContentProvider facetsTableContentProvider = new FacetsTableContentProvider();
    protected String[] columnProperties = new String[]{FACET_NAME, FACET_VALUE, FACET_OTHER};
    protected CellEditor[] cellEditors;
    protected CellEditor[] altCellEditors;
    protected String[] whiteSpaceValues = new String[]{"", "preserve", "replace", "collapse"};
    protected String[] trueFalseValues = new String[]{"", "false", "true"};
    protected FacetsSection facetsSection;

    public FacetViewer(Composite parent, FacetsSection facetsSection) {
        super(new Table(parent, 65540));
        this.facetsSection = facetsSection;
        this.getTable().setLinesVisible(true);
        this.getTable().setHeaderVisible(true);
        this.addSelectionChangedListener(new SelectionChangedListener());
        this.getTable().addMouseTrackListener((MouseTrackListener)new MyMouseTrackListener());
        this.setContentProvider((IContentProvider)this.facetsTableContentProvider);
        this.setLabelProvider((IBaseLabelProvider)this.facetsTableLabelProvider);
        this.setColumnProperties(this.columnProperties);
        this.setCellModifier(this);
        int i = 0;
        while (i < 3) {
            TableColumn column = new TableColumn(this.getTable(), 0, i);
            column.setText(this.columnProperties[i]);
            column.setAlignment(16384);
            column.setResizable(true);
            ++i;
        }
        this.cellEditors = new CellEditor[3];
        this.altCellEditors = new CellEditor[3];
        TableLayout layout = new TableLayout();
        ColumnWeightData data = new ColumnWeightData(60, 120, true);
        layout.addColumnData((ColumnLayoutData)data);
        this.cellEditors[0] = null;
        ColumnWeightData data2 = new ColumnWeightData(120, 100, true);
        layout.addColumnData((ColumnLayoutData)data2);
        this.cellEditors[1] = new TextCellEditor((Composite)this.getTable());
        XSDComboBoxPropertyDescriptor pd = new XSDComboBoxPropertyDescriptor("combo", "whitespace", this.whiteSpaceValues);
        this.altCellEditors[1] = pd.createPropertyEditor((Composite)this.getTable());
        ColumnWeightData data3 = new ColumnWeightData(60, 80, true);
        layout.addColumnData((ColumnLayoutData)data3);
        XSDComboBoxPropertyDescriptor pd2 = new XSDComboBoxPropertyDescriptor("combo", "other", this.trueFalseValues);
        this.cellEditors[2] = pd2.createPropertyEditor((Composite)this.getTable());
        this.altCellEditors[2] = pd2.createPropertyEditor((Composite)this.getTable());
        this.getTable().setLayout((Layout)layout);
        this.setCellEditors(this.cellEditors);
    }

    public boolean canModify(Object element, String property) {
        return property.equals(FACET_VALUE) || property.equals(FACET_OTHER);
    }

    public Object getValue(Object element, String property) {
        int column = 0;
        if (property.equals(this.columnProperties[0])) {
            column = 0;
        } else if (property.equals(this.columnProperties[1])) {
            column = 1;
        } else if (property.equals(this.columnProperties[2])) {
            column = 2;
        }
        return this.facetsTableLabelProvider.getColumnText(element, column);
    }

    public void modify(Object element, String property, Object value) {
        Object o;
        XSDSimpleTypeDefinition xsdSimpleType = (XSDSimpleTypeDefinition)this.getInput();
        TableItem item = (TableItem)element;
        if (item != null && (o = item.getData()) != null && o instanceof String) {
            String facet = (String)o;
            Element simpleTypeElement = xsdSimpleType.getElement();
            XSDDOMHelper xsdDOMHelper = new XSDDOMHelper();
            Element derivedByElement = xsdDOMHelper.getDerivedByElement(simpleTypeElement);
            this.facetsSection.beginRecording(XSDEditorPlugin.getXSDString("_UI_FACET_CHANGE"), simpleTypeElement);
            String prefix = simpleTypeElement.getPrefix();
            prefix = prefix == null ? "" : String.valueOf(prefix) + ":";
            Element childNodeElement = null;
            DOMAttribute valueAttr = null;
            XSDConstrainingFacet targetFacet = this.getXSDConstrainingFacet(facet);
            String newValue = "";
            if (value != null && value instanceof String) {
                newValue = (String)value;
            }
            if (property.equals(this.columnProperties[1])) {
                if (targetFacet == null && newValue.length() > 0) {
                    targetFacet = this.createFacet(facet);
                    childNodeElement = derivedByElement.getOwnerDocument().createElementNS("http://www.w3.org/2001/XMLSchema", String.valueOf(prefix) + facet);
                    valueAttr = new DOMAttribute("value", newValue);
                    childNodeElement.setAttribute(valueAttr.getName(), valueAttr.getValue());
                    derivedByElement.appendChild(childNodeElement);
                    targetFacet.setElement(childNodeElement);
                    XSDDOMHelper.formatChild(childNodeElement);
                }
                if (targetFacet == null) {
                    this.facetsSection.endRecording(simpleTypeElement);
                    return;
                }
                if (newValue.length() > 0) {
                    targetFacet.setLexicalValue(newValue);
                    if (targetFacet instanceof XSDMaxFacet || targetFacet instanceof XSDMinFacet) {
                        if (targetFacet instanceof XSDMaxFacet) {
                            XSDMaxExclusiveFacet xsdMaxExclusiveFacet;
                            if (targetFacet instanceof XSDMaxExclusiveFacet) {
                                XSDMaxInclusiveFacet xsdMaxInclusiveFacet = xsdSimpleType.getMaxInclusiveFacet();
                                if (xsdMaxInclusiveFacet != null) {
                                    Element xsdMaxInclusiveFacetElement = xsdMaxInclusiveFacet.getElement();
                                    XSDDOMHelper.removeNodeAndWhitespace(xsdMaxInclusiveFacetElement);
                                }
                            } else if (targetFacet instanceof XSDMaxInclusiveFacet && (xsdMaxExclusiveFacet = xsdSimpleType.getMaxExclusiveFacet()) != null) {
                                Element xsdMaxExclusiveFacetElement = xsdMaxExclusiveFacet.getElement();
                                XSDDOMHelper.removeNodeAndWhitespace(xsdMaxExclusiveFacetElement);
                            }
                        } else if (targetFacet instanceof XSDMinFacet) {
                            XSDMinExclusiveFacet xsdMinExclusiveFacet;
                            if (targetFacet instanceof XSDMinExclusiveFacet) {
                                XSDMinInclusiveFacet xsdMinInclusiveFacet = xsdSimpleType.getMinInclusiveFacet();
                                if (xsdMinInclusiveFacet != null) {
                                    Element xsdMinInclusiveFacetElement = xsdMinInclusiveFacet.getElement();
                                    XSDDOMHelper.removeNodeAndWhitespace(xsdMinInclusiveFacetElement);
                                }
                            } else if (targetFacet instanceof XSDMinInclusiveFacet && (xsdMinExclusiveFacet = xsdSimpleType.getMinExclusiveFacet()) != null) {
                                Element xsdMinExclusiveFacetElement = xsdMinExclusiveFacet.getElement();
                                XSDDOMHelper.removeNodeAndWhitespace(xsdMinExclusiveFacetElement);
                            }
                        }
                    }
                } else {
                    Element targetFacetElement = targetFacet.getElement();
                    XSDDOMHelper.removeNodeAndWhitespace(targetFacetElement);
                }
            } else if (property.equals(this.columnProperties[2]) && targetFacet != null) {
                if (newValue.length() > 0) {
                    targetFacet.getElement().setAttribute("fixed", newValue);
                } else {
                    targetFacet.getElement().removeAttribute("fixed");
                }
            }
            xsdSimpleType.setElement(simpleTypeElement);
            this.facetsSection.endRecording(simpleTypeElement);
            this.refresh();
        }
    }

    private XSDConstrainingFacet getXSDConstrainingFacet(String facetString) {
        XSDSimpleTypeDefinition xsdSimpleType = (XSDSimpleTypeDefinition)this.getInput();
        EList list = xsdSimpleType.getFacetContents();
        if (list == null) {
            return null;
        }
        Iterator iter = list.iterator();
        XSDConstrainingFacet targetFacet = null;
        while (iter.hasNext()) {
            XSDConstrainingFacet xsdConstrainingFacet = (XSDConstrainingFacet)iter.next();
            if (!xsdConstrainingFacet.getFacetName().equals(facetString)) continue;
            targetFacet = xsdConstrainingFacet;
            break;
        }
        return targetFacet;
    }

    private XSDConstrainingFacet createFacet(String facet) {
        XSDFactoryImpl factory = new XSDFactoryImpl();
        XSDLengthFacet xsdFacet = null;
        if (facet.equals("length")) {
            xsdFacet = factory.createXSDLengthFacet();
        } else if (facet.equals("minLength")) {
            xsdFacet = factory.createXSDMinLengthFacet();
        } else if (facet.equals("maxLength")) {
            xsdFacet = factory.createXSDMaxLengthFacet();
        } else if (facet.equals("minInclusive")) {
            xsdFacet = factory.createXSDMinInclusiveFacet();
        } else if (facet.equals("minExclusive")) {
            xsdFacet = factory.createXSDMinExclusiveFacet();
        } else if (facet.equals("maxInclusive")) {
            xsdFacet = factory.createXSDMaxInclusiveFacet();
        } else if (facet.equals("maxExclusive")) {
            xsdFacet = factory.createXSDMaxExclusiveFacet();
        } else if (facet.equals("totalDigits")) {
            xsdFacet = factory.createXSDTotalDigitsFacet();
        } else if (facet.equals("fractionDigits")) {
            xsdFacet = factory.createXSDFractionDigitsFacet();
        } else if (facet.equals("whiteSpace")) {
            xsdFacet = factory.createXSDWhiteSpaceFacet();
        }
        return xsdFacet;
    }

    public String getToolTip(String facet) {
        String key = "";
        if (facet.equals("length")) {
            key = "_UI_TOOLTIP_LENGTH";
        } else if (facet.equals("minLength")) {
            key = "_UI_TOOLTIP_MIN_LEN";
        } else if (facet.equals("maxLength")) {
            key = "_UI_TOOLTIP_MAX_LEN";
        } else if (facet.equals("minInclusive")) {
            key = "_UI_TOOLTIP_MIN_INCLUSIVE";
        } else if (facet.equals("minExclusive")) {
            key = "_UI_TOOLTIP_MIN_EXCLUSIVE";
        } else if (facet.equals("maxInclusive")) {
            key = "_UI_TOOLTIP_MAX_INCLUSIVE";
        } else if (facet.equals("maxExclusive")) {
            key = "_UI_TOOLTIP_MAX_EXCLUSIVE";
        } else if (facet.equals("totalDigits")) {
            key = "_UI_TOOLTIP_TOTAL_DIGITS";
        } else if (facet.equals("fractionDigits")) {
            key = "_UI_TOOLTIP_FRACTION_DIGITS";
        } else if (facet.equals("whiteSpace")) {
            key = "_UI_TOOLTIP_WHITE_SPACE";
        }
        return key != null ? XSDEditorPlugin.getXSDString(key) : "";
    }

    public class MyMouseTrackListener
    extends MouseTrackAdapter {
        public void mouseHover(MouseEvent e) {
            Object o;
            TableItem item = FacetViewer.this.getTable().getItem(new Point(e.x, e.y));
            if (item != null && (o = item.getData()) != null) {
                String facetName = (String)o;
                FacetViewer.this.getTable().setToolTipText(FacetViewer.this.getToolTip(facetName));
            }
        }
    }

    public class SelectionChangedListener
    implements ISelectionChangedListener {
        public void selectionChanged(SelectionChangedEvent event) {
            Object o = WindowUtility.getSelection(event.getSelection());
            if (o != null) {
                String facet = (String)o;
                if (facet.equals("whiteSpace")) {
                    FacetViewer.this.setCellEditors(FacetViewer.this.altCellEditors);
                } else {
                    FacetViewer.this.setCellEditors(FacetViewer.this.cellEditors);
                }
            }
        }
    }

    class FacetsTableContentProvider
    implements IStructuredContentProvider {
        protected String facet;

        FacetsTableContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            Vector<String> v = new Vector<String>();
            XSDSimpleTypeDefinition inputXSDSimpleType = (XSDSimpleTypeDefinition)inputElement;
            XSDSimpleTypeDefinition base = inputXSDSimpleType.getBaseTypeDefinition();
            if (base != null) {
                Iterator validFacets = base.getValidFacets().iterator();
                while (validFacets.hasNext()) {
                    String aValidFacet = (String)validFacets.next();
                    if (aValidFacet.equals("pattern") || aValidFacet.equals("enumeration")) continue;
                    v.add(aValidFacet);
                }
            }
            return v.toArray();
        }

        public void dispose() {
        }
    }

    class FacetsTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        FacetsTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof String) {
                String value = null;
                XSDConstrainingFacet targetFacet = FacetViewer.this.getXSDConstrainingFacet((String)element);
                switch (columnIndex) {
                    case 0: {
                        value = (String)element;
                        break;
                    }
                    case 1: {
                        if (targetFacet == null) {
                            value = "";
                            break;
                        }
                        value = targetFacet.getLexicalValue();
                        break;
                    }
                    case 2: {
                        if (targetFacet == null) {
                            value = "";
                            break;
                        }
                        Element elem = targetFacet.getElement();
                        value = elem.getAttribute("fixed");
                        if (value != null) break;
                        value = "";
                    }
                }
                return value;
            }
            return "";
        }
    }
}

