/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.properties.section;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.wst.common.ui.properties.internal.provisional.ITabbedPropertySheetPageContributor;
import org.eclipse.wst.common.ui.properties.internal.provisional.TabbedPropertySheetPage;
import org.eclipse.wst.xsd.ui.internal.XSDSelectionManager;
import org.eclipse.wst.xsd.ui.internal.graph.model.Category;
import org.eclipse.wst.xsd.ui.internal.provider.CategoryAdapter;
import org.eclipse.wst.xsd.ui.internal.provider.XSDModelAdapterFactoryImpl;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class XSDTabbedPropertySheetPage
extends TabbedPropertySheetPage
implements ISelectionChangedListener,
INotifyChangedListener {
    XSDSchema xsdSchema;
    private XSDSelectionManager selectionManager;
    private XSDModelAdapterFactoryImpl adapterFactory;

    public XSDTabbedPropertySheetPage(ITabbedPropertySheetPageContributor tabbedPropertySheetPageContributor) {
        super(tabbedPropertySheetPageContributor);
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        this.getSite().getWorkbenchWindow().getSelectionService().addPostSelectionListener((ISelectionListener)this);
    }

    public void setXSDSchema(XSDSchema xsdSchema) {
        this.xsdSchema = xsdSchema;
    }

    public void setXSDModelAdapterFactory(XSDModelAdapterFactoryImpl adapterFactory) {
        if (adapterFactory != null) {
            adapterFactory.removeListener(this);
        }
        this.adapterFactory = adapterFactory;
        if (adapterFactory != null) {
            adapterFactory.addListener(this);
        }
    }

    public void setSelectionManager(XSDSelectionManager newSelectionManager) {
        if (this.selectionManager != null) {
            this.selectionManager.removeSelectionChangedListener(this);
        }
        this.selectionManager = newSelectionManager;
        if (this.selectionManager != null) {
            this.selectionManager.addSelectionChangedListener(this);
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection != null) {
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                if (structuredSelection.isEmpty()) {
                    return;
                }
                Object obj = structuredSelection.getFirstElement();
                if (obj instanceof Element) {
                    try {
                        XSDConcreteComponent modelObject = this.xsdSchema.getCorrespondingComponent((Node)((Element)obj));
                        if (modelObject != null) {
                            obj = modelObject;
                            selection = new StructuredSelection(obj);
                        }
                    }
                    catch (Exception exception) {}
                } else if (obj instanceof Text) {
                    Node parent = ((Text)obj).getParentNode();
                    XSDConcreteComponent modelObject = this.xsdSchema.getCorrespondingComponent(parent);
                    if (modelObject != null) {
                        obj = modelObject;
                        selection = new StructuredSelection(obj);
                    }
                } else if (obj instanceof CategoryAdapter) {
                    selection = new StructuredSelection((Object)((CategoryAdapter)obj).getXSDSchema());
                } else if (obj instanceof Category) {
                    selection = new StructuredSelection((Object)((Category)obj).getXSDSchema());
                } else if (obj instanceof ProcessingInstruction) {
                    selection = new StructuredSelection((Object)this.xsdSchema);
                }
            } else if (selection instanceof TextSelection) {
                return;
            }
        }
        super.selectionChanged(part, selection);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (!event.getSelection().isEmpty()) {
            this.selectionChanged(this.getSite().getWorkbenchWindow().getActivePage().getActivePart(), event.getSelection());
        }
    }

    public void dispose() {
        if (this.selectionManager != null) {
            this.selectionManager.removeSelectionChangedListener(this);
        }
        if (this.adapterFactory != null) {
            this.adapterFactory.removeListener(this);
        }
        this.getSite().getWorkbenchWindow().getSelectionService().removePostSelectionListener((ISelectionListener)this);
        super.dispose();
    }

    public void notifyChanged(Notification notification) {
        if (this.getCurrentTab() != null) {
            this.refresh();
        }
    }
}

