/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.refactor.delete;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.wst.xsd.ui.internal.refactor.XSDVisitor;
import org.eclipse.wst.xsd.ui.internal.util.XSDDOMHelper;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Element;

public abstract class BaseCleanup
extends XSDVisitor {
    protected ArrayList messages = new ArrayList();
    protected ArrayList childrenToRemove = new ArrayList();

    public void visitSchema(XSDSchema schema) {
        super.visitSchema(schema);
        Iterator iter = this.childrenToRemove.iterator();
        while (iter.hasNext()) {
            Element domElement = (Element)iter.next();
            XSDDOMHelper.removeNodeAndWhitespace(domElement);
        }
    }

    public ArrayList getMessages() {
        return this.messages;
    }

    protected void addMessage(String msg, XSDConcreteComponent component) {
    }

    protected String getNamedComponentName(XSDConcreteComponent concrete) {
        String name = null;
        if (concrete instanceof XSDNamedComponent) {
            name = ((XSDNamedComponent)concrete).getName();
        }
        XSDConcreteComponent comp = concrete;
        while (comp != null && name == null) {
            if (!((comp = comp.getContainer()) instanceof XSDNamedComponent)) continue;
            name = ((XSDNamedComponent)comp).getName();
        }
        return name != null ? name : "";
    }
}

