/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.generic.core.internal.publishers;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.jst.server.core.PublishUtil;
import org.eclipse.jst.server.generic.core.internal.GenericServer;
import org.eclipse.jst.server.generic.core.internal.publishers.DefaultModuleAssembler;
import org.eclipse.jst.server.generic.core.internal.publishers.EarModuleAssembler;
import org.eclipse.jst.server.generic.core.internal.publishers.ModulePackager;
import org.eclipse.jst.server.generic.core.internal.publishers.WarModuleAssembler;
import org.eclipse.jst.server.generic.servertype.definition.ServerRuntime;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.util.ProjectModule;

public abstract class AbstractModuleAssembler {
    protected ServerRuntime fServerdefinition;
    protected IModule fModule;
    protected GenericServer fServer;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    protected abstract void assemble(IProgressMonitor var1) throws CoreException;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void packModule(IModule module, IPath destination) throws CoreException {
        String name = this.getDUName(module);
        String dest = destination.append(name).toString();
        ModulePackager packager = null;
        try {
            try {
                packager = new ModulePackager(dest, false);
                Class<?> clazz = class$0;
                if (clazz == null) {
                    Class<?> clazz2;
                    try {
                        clazz2 = Class.forName("org.eclipse.wst.server.core.util.ProjectModule");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz = class$0 = clazz2;
                }
                ProjectModule pm = (ProjectModule)module.loadAdapter((Class)clazz, null);
                IModuleResource[] resources = pm.members();
                int i = 0;
                while (i < resources.length) {
                    this.doPackModule(resources[i], packager);
                    ++i;
                }
            }
            catch (IOException e) {
                Status status = new Status(4, "org.eclipse.jst.server.generic.core", 0, "unable to assemble module", (Throwable)e);
                throw new CoreException((IStatus)status);
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            try {
                packager.finished();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var9_13 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        packager.finished();
    }

    private String getDUName(IModule module) {
        IModuleType moduleType = module.getModuleType();
        if (moduleType == null) {
            return String.valueOf(module.getName()) + ".jar";
        }
        if ("jst.web".equals(moduleType.getId())) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.jst.server.core.IWebModule");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IWebModule webmodule = (IWebModule)module.loadAdapter((Class)clazz, null);
            return webmodule.getURI(module);
        }
        if ("jst.ear".equals(moduleType.getId())) {
            return String.valueOf(module.getName()) + ".ear";
        }
        if ("jst.connector".equals(moduleType.getId())) {
            return String.valueOf(module.getName()) + ".rar";
        }
        return String.valueOf(module.getName()) + ".jar";
    }

    private void doPackModule(IModuleResource resource, ModulePackager packager) throws CoreException, IOException {
        if (resource instanceof IModuleFolder) {
            IModuleFolder mFolder = (IModuleFolder)resource;
            IModuleResource[] resources = mFolder.members();
            if (resources == null || resources.length == 0) {
                packager.writeFolder(resource.getModuleRelativePath().append(resource.getName()).toPortableString());
            }
            int i = 0;
            while (resources != null && i < resources.length) {
                this.doPackModule(resources[i], packager);
                ++i;
            }
        } else {
            IFile file;
            String destination = resource.getModuleRelativePath().append(resource.getName()).toPortableString();
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.core.resources.IFile");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((file = (IFile)resource.getAdapter((Class)clazz)) != null) {
                packager.write(file, destination);
            } else {
                Class<?> clazz2 = class$3;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$3 = Class.forName("java.io.File");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                File file2 = (File)resource.getAdapter((Class)clazz2);
                packager.write(file2, destination);
            }
        }
    }

    protected IPath copyModule(IModule module, IProgressMonitor monitor) throws CoreException {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.server.core.util.ProjectModule");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ProjectModule pm = (ProjectModule)module.loadAdapter((Class)clazz, monitor);
        IPath to = this.getProjectWorkingLocation().append(pm.getId());
        PublishUtil.smartCopy((IModuleResource[])pm.members(), (IPath)to, (IProgressMonitor)monitor);
        return to;
    }

    private IPath getProjectWorkingLocation() {
        return ServerPlugin.getInstance().getTempDirectory(this.fServer.getServer().getId());
    }

    public static class Factory {
        public static AbstractModuleAssembler getModuleAssembler(IModule module, GenericServer server) {
            if (Factory.isModuleType(module, "jst.web")) {
                return new WarModuleAssembler(module, server);
            }
            if (Factory.isModuleType(module, "jst.ear")) {
                return new EarModuleAssembler(module, server);
            }
            return new DefaultModuleAssembler(module, server);
        }

        private static boolean isModuleType(IModule module, String moduleTypeId) {
            return module.getModuleType() != null && moduleTypeId.equals(module.getModuleType().getId());
        }
    }
}

