/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.tasks;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.sse.core.internal.Logger;
import org.eclipse.wst.sse.core.internal.SSECorePlugin;
import org.eclipse.wst.sse.core.internal.tasks.TaskScanningJob;
import org.eclipse.wst.sse.core.internal.util.StringUtils;

public class TaskScanningScheduler {
    private static TaskScanningScheduler scheduler;
    TaskScanningJob fJob = new TaskScanningJob();
    ListenerVisitor visitor = new ListenerVisitor();

    public static void refresh() {
        SSECorePlugin.getDefault().getPluginPreferences().setValue("task-tag-projects-already-scanned", "");
        scheduler.enqueue(ResourcesPlugin.getWorkspace().getRoot());
    }

    public static void refresh(IProject project) {
        String[] projectNames = StringUtils.unpack(SSECorePlugin.getDefault().getPluginPreferences().getString("task-tag-projects-already-scanned"));
        ArrayList<String> freshProjectList = new ArrayList<String>();
        int i = 0;
        while (i < projectNames.length) {
            if (!projectNames[i].equals(project.getName())) {
                freshProjectList.add(projectNames[i]);
            }
            ++i;
        }
        String freshProjects = StringUtils.pack(freshProjectList.toArray(new String[freshProjectList.size()]));
        SSECorePlugin.getDefault().getPluginPreferences().setValue("task-tag-projects-already-scanned", freshProjects);
        scheduler.enqueue(project);
    }

    public static void shutdown() {
        if (scheduler != null) {
            TaskScanningScheduler.scheduler.fJob.cancel();
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)TaskScanningScheduler.scheduler.visitor);
        }
    }

    public static void startup() {
        scheduler = new TaskScanningScheduler();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)TaskScanningScheduler.scheduler.visitor, 1);
        scheduler.enqueue(ResourcesPlugin.getWorkspace().getRoot());
    }

    private TaskScanningScheduler() {
    }

    void enqueue(IProject project) {
        this.fJob.addProject(project);
    }

    void enqueue(IWorkspaceRoot root) {
        IProject[] allProjects = root.getProjects();
        int i = 0;
        while (i < allProjects.length) {
            this.fJob.addProject(allProjects[i]);
            ++i;
        }
    }

    private class ListenerVisitor
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        private ListenerVisitor() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            int resourceType;
            IResourceDelta delta = event.getDelta();
            if (delta.getResource() != null && ((resourceType = delta.getResource().getType()) == 4 || resourceType == 8)) {
                try {
                    delta.accept((IResourceDeltaVisitor)this);
                }
                catch (CoreException e) {
                    Logger.logException("Exception handling resource change", e);
                }
            }
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            block7: {
                block6: {
                    if ((delta.getKind() & 0x20000) > 0 || (delta.getKind() & 0x100000) > 0) break block6;
                    delta.getKind();
                    if (0 <= 0) break block7;
                }
                return false;
            }
            IResource resource = delta.getResource();
            if (resource != null) {
                if (resource.getType() == 8) {
                    return true;
                }
                if (resource.getType() == 4) {
                    TaskScanningScheduler.this.fJob.addDelta(delta);
                    return false;
                }
            }
            return false;
        }
    }
}

