/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.wsrt;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jst.ws.internal.consumption.common.FacetMatcher;
import org.eclipse.jst.ws.internal.consumption.common.FacetSetsByTemplateCache;
import org.eclipse.jst.ws.internal.consumption.common.FacetUtils;
import org.eclipse.jst.ws.internal.consumption.common.RequiredFacetVersion;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.ClientRuntimeDescriptor;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.ServiceRuntimeDescriptor;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceRuntimeExtensionUtils2;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectTemplate;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class FacetMatchCache
implements IResourceChangeListener {
    private static FacetMatchCache instance_;
    private Hashtable serviceFacetMatchTable_;
    private Hashtable serviceTableKeysByProjectName_;
    private Hashtable clientFacetMatchTable_;
    private Hashtable clientTableKeysByProjectName_;
    private List projectEntriesToDelete_;
    private Hashtable templatesByServiceRuntimeId_;
    private Hashtable templatesByClientRuntimeId_;

    public static synchronized FacetMatchCache getInstance() {
        if (instance_ == null) {
            instance_ = new FacetMatchCache();
            instance_.load();
        }
        return instance_;
    }

    private void load() {
        this.serviceFacetMatchTable_ = new Hashtable();
        this.serviceTableKeysByProjectName_ = new Hashtable();
        this.clientFacetMatchTable_ = new Hashtable();
        this.clientTableKeysByProjectName_ = new Hashtable();
        this.projectEntriesToDelete_ = new ArrayList();
        this.templatesByClientRuntimeId_ = new Hashtable();
        this.templatesByServiceRuntimeId_ = new Hashtable();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 4);
    }

    public synchronized FacetMatcher getMatchForProject(boolean isClient, String runtimeId, String projectName) {
        if (this.projectEntriesToDelete_.size() > 0) {
            Iterator projectItr = this.projectEntriesToDelete_.iterator();
            while (projectItr.hasNext()) {
                String projectNameToDelete = (String)projectItr.next();
                this.removeTableEntriesForProject(true, projectNameToDelete);
                this.removeTableEntriesForProject(false, projectNameToDelete);
            }
            this.projectEntriesToDelete_.clear();
        }
        IProject project = ProjectUtilities.getProject((String)projectName);
        FacetMatcher fm = null;
        if (project != null && project.exists()) {
            String key = this.getKey(runtimeId, projectName);
            fm = isClient ? (FacetMatcher)this.clientFacetMatchTable_.get(key) : (FacetMatcher)this.serviceFacetMatchTable_.get(key);
            if (fm == null) {
                fm = this.calculateFacetMatcher(isClient, runtimeId, projectName);
                if (isClient) {
                    this.clientFacetMatchTable_.put(key, fm);
                } else {
                    this.serviceFacetMatchTable_.put(key, fm);
                }
                this.updateTableOfKeys(isClient, key, projectName);
            } else {
                Set previousFacetVersions;
                Set currentFacetVersions = FacetUtils.getFacetsForProject((String)projectName);
                if (!currentFacetVersions.equals(previousFacetVersions = fm.getFacetsTested())) {
                    fm = this.calculateFacetMatcher(isClient, runtimeId, projectName);
                    if (isClient) {
                        this.clientFacetMatchTable_.put(key, fm);
                    } else {
                        this.serviceFacetMatchTable_.put(key, fm);
                    }
                }
            }
        }
        return fm;
    }

    private void updateTableOfKeys(boolean isClient, String key, String projectName) {
        Set setOfKeysForProjectName = null;
        setOfKeysForProjectName = isClient ? (Set)this.clientTableKeysByProjectName_.get(projectName) : (Set)this.serviceTableKeysByProjectName_.get(projectName);
        if (setOfKeysForProjectName == null) {
            HashSet<String> keys = new HashSet<String>();
            keys.add(key);
            if (isClient) {
                this.clientTableKeysByProjectName_.put(projectName, keys);
            } else {
                this.serviceTableKeysByProjectName_.put(projectName, keys);
            }
        } else {
            setOfKeysForProjectName.add(key);
        }
    }

    private FacetMatcher calculateFacetMatcher(boolean isClient, String runtimeId, String projectName) {
        Object desc;
        FacetMatcher fm = null;
        RequiredFacetVersion[] rfvs = null;
        if (isClient) {
            desc = WebServiceRuntimeExtensionUtils2.getClientRuntimeDescriptorById(runtimeId);
            rfvs = ((ClientRuntimeDescriptor)desc).getRequiredFacetVersions();
        } else {
            desc = WebServiceRuntimeExtensionUtils2.getServiceRuntimeDescriptorById(runtimeId);
            rfvs = ((ServiceRuntimeDescriptor)desc).getRequiredFacetVersions();
        }
        Set facetVersions = FacetUtils.getFacetsForProject((String)projectName);
        if (facetVersions != null) {
            fm = FacetUtils.match((RequiredFacetVersion[])rfvs, (Set)facetVersions);
        } else {
            fm = new FacetMatcher();
            fm.setMatch(false);
        }
        return fm;
    }

    private String getKey(String a, String b) {
        StringBuffer keysb = new StringBuffer();
        keysb.append(a);
        keysb.append("/");
        keysb.append(b);
        return keysb.toString();
    }

    private void removeTableEntriesForProject(boolean isClient, String projectName) {
        Set setOfKeysForProjectName = null;
        setOfKeysForProjectName = isClient ? (Set)this.clientTableKeysByProjectName_.get(projectName) : (Set)this.serviceTableKeysByProjectName_.get(projectName);
        if (setOfKeysForProjectName != null) {
            Iterator keysItr = setOfKeysForProjectName.iterator();
            while (keysItr.hasNext()) {
                String key = (String)keysItr.next();
                if (isClient) {
                    this.clientFacetMatchTable_.remove(key);
                    continue;
                }
                this.serviceFacetMatchTable_.remove(key);
            }
            if (isClient) {
                this.clientTableKeysByProjectName_.remove(projectName);
            } else {
                this.serviceTableKeysByProjectName_.remove(projectName);
            }
        }
    }

    public synchronized Set getTemplatesForClientRuntime(String clientRuntimeId) {
        Set templates = (Set)this.templatesByClientRuntimeId_.get(clientRuntimeId);
        if (templates != null) {
            return templates;
        }
        ClientRuntimeDescriptor desc = WebServiceRuntimeExtensionUtils2.getClientRuntimeDescriptorById(clientRuntimeId);
        Set validTemplates = this.getTemplates(desc.getRequiredFacetVersions());
        this.templatesByClientRuntimeId_.put(clientRuntimeId, validTemplates);
        return validTemplates;
    }

    public synchronized Set getTemplatesForServiceRuntime(String serviceRuntimeId) {
        Set templates = (Set)this.templatesByServiceRuntimeId_.get(serviceRuntimeId);
        if (templates != null) {
            return templates;
        }
        ServiceRuntimeDescriptor desc = WebServiceRuntimeExtensionUtils2.getServiceRuntimeDescriptorById(serviceRuntimeId);
        Set validTemplates = this.getTemplates(desc.getRequiredFacetVersions());
        this.templatesByServiceRuntimeId_.put(serviceRuntimeId, validTemplates);
        return validTemplates;
    }

    private Set getTemplates(RequiredFacetVersion[] requiredFacetVersions) {
        HashSet<IFacetedProjectTemplate> templates = new HashSet<IFacetedProjectTemplate>();
        Iterator itr = ProjectFacetsManager.getTemplates().iterator();
        block0: while (itr.hasNext()) {
            IFacetedProjectTemplate template = (IFacetedProjectTemplate)itr.next();
            String templateId = template.getId();
            if (templateId.indexOf("ear") != -1 || templateId.indexOf("wst.web") != -1) continue;
            Set[] combinations = FacetSetsByTemplateCache.getInstance().getFacetVersionCombinationsFromTemplate(templateId);
            int i = 0;
            while (i < combinations.length) {
                FacetMatcher fm = FacetUtils.match((RequiredFacetVersion[])requiredFacetVersions, (Set)combinations[i]);
                if (fm.isMatch()) {
                    templates.add(template);
                    continue block0;
                }
                ++i;
            }
        }
        return templates;
    }

    public synchronized void resourceChanged(IResourceChangeEvent event) {
        IResource projectResource;
        if (event.getType() == 4 && (projectResource = event.getResource()) != null) {
            String projectName = projectResource.getName();
            this.projectEntriesToDelete_.add(projectName);
        }
    }
}

