/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.indexing;

import java.io.IOException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.index.Index;
import org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.eclipse.jdt.internal.core.search.indexing.IndexRequest;
import org.eclipse.jdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.jdt.internal.core.search.indexing.SaveIndex;
import org.eclipse.jdt.internal.core.search.processing.JobManager;

public class IndexBinaryFolder
extends IndexRequest {
    IContainer folder;

    public IndexBinaryFolder(IContainer folder, IndexManager manager) {
        super(folder.getFullPath(), manager);
        this.folder = folder;
    }

    public boolean equals(Object o) {
        if (o instanceof IndexBinaryFolder) {
            return this.folder.equals((Object)((IndexBinaryFolder)o).folder);
        }
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean execute(IProgressMonitor progressMonitor) {
        if (this.isCancelled) return true;
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            return true;
        }
        if (!this.folder.isAccessible()) {
            return true;
        }
        Index index = this.manager.getIndexForUpdate(this.containerPath, true, true);
        if (index == null) {
            return true;
        }
        ReadWriteMonitor monitor = index.monitor;
        if (monitor == null) {
            return true;
        }
        try {
            try {
                monitor.enterRead();
                String[] paths = index.queryDocumentNames("");
                int max = paths == null ? 0 : paths.length;
                final SimpleLookupTable indexedFileNames = new SimpleLookupTable(max == 0 ? 33 : max + 11);
                if (max == 0) {
                    this.folder.accept(new IResourceProxyVisitor(){

                        public boolean visit(IResourceProxy proxy) {
                            if (IndexBinaryFolder.this.isCancelled) {
                                return false;
                            }
                            if (proxy.getType() == 1) {
                                IFile file;
                                if (Util.isClassFileName(proxy.getName()) && (file = (IFile)proxy.requestResource()).getLocation() != null) {
                                    String containerRelativePath = org.eclipse.jdt.internal.core.util.Util.relativePath(file.getFullPath(), IndexBinaryFolder.this.containerPath.segmentCount());
                                    indexedFileNames.put(containerRelativePath, file);
                                }
                                return false;
                            }
                            return true;
                        }
                    }, 0);
                } else {
                    int i = 0;
                    while (true) {
                        if (i >= max) {
                            final long indexLastModified = index.getIndexFile().lastModified();
                            this.folder.accept(new IResourceProxyVisitor(){

                                public boolean visit(IResourceProxy proxy) {
                                    if (IndexBinaryFolder.this.isCancelled) {
                                        return false;
                                    }
                                    if (proxy.getType() == 1) {
                                        IFile file;
                                        IPath location;
                                        if (Util.isClassFileName(proxy.getName()) && (location = (file = (IFile)proxy.requestResource()).getLocation()) != null) {
                                            String containerRelativePath;
                                            indexedFileNames.put(containerRelativePath, indexedFileNames.get(containerRelativePath = org.eclipse.jdt.internal.core.util.Util.relativePath(file.getFullPath(), IndexBinaryFolder.this.containerPath.segmentCount())) == null || indexLastModified < location.toFile().lastModified() ? file : "OK");
                                        }
                                        return false;
                                    }
                                    return true;
                                }
                            }, 0);
                            break;
                        }
                        indexedFileNames.put(paths[i], "DELETED");
                        ++i;
                    }
                }
                Object[] names = indexedFileNames.keyTable;
                Object[] values = indexedFileNames.valueTable;
                int i = 0;
                int length = names.length;
                while (true) {
                    block22: {
                        if (i < length) break block22;
                        this.manager.request(new SaveIndex(this.containerPath, this.manager));
                        break;
                    }
                    String name = (String)names[i];
                    if (name != null) {
                        if (this.isCancelled) {
                            Object var13_17 = null;
                            monitor.exitRead();
                            return false;
                        }
                        Object value = values[i];
                        if (value != "OK") {
                            if (value == "DELETED") {
                                this.manager.remove(name, this.containerPath);
                            } else {
                                this.manager.addBinary((IFile)value, this.containerPath);
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                if (JobManager.VERBOSE) {
                    org.eclipse.jdt.internal.core.util.Util.verbose("-> failed to index " + this.folder + " because of the following exception:", System.err);
                    e.printStackTrace();
                }
                this.manager.removeIndex(this.containerPath);
                Object var13_18 = null;
                monitor.exitRead();
                return false;
            }
            catch (IOException e) {
                if (JobManager.VERBOSE) {
                    org.eclipse.jdt.internal.core.util.Util.verbose("-> failed to index " + this.folder + " because of the following exception:", System.err);
                    e.printStackTrace();
                }
                this.manager.removeIndex(this.containerPath);
                Object var13_19 = null;
                monitor.exitRead();
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var13_20 = null;
            monitor.exitRead();
            throw throwable;
        }
        {
            Object var13_21 = null;
            monitor.exitRead();
            return true;
        }
    }

    public int hashCode() {
        return this.folder.hashCode();
    }

    protected Integer updatedIndexState() {
        return IndexManager.REBUILDING_STATE;
    }

    public String toString() {
        return "indexing binary folder " + this.folder.getFullPath();
    }
}

