/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.datatransfer;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IRegion;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IFileEditorInput;
import org.w3c.dom.Document;

public class ExportUtil {
    private static Comparator javaProjectComparator;
    public static final String NEWLINE;
    static /* synthetic */ Class class$0;

    static {
        NEWLINE = System.getProperty("line.separator");
    }

    private ExportUtil() {
    }

    public static IResource getResource(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            Iterator iter = ((IStructuredSelection)selection).iterator();
            if (iter.hasNext()) {
                IAdaptable adaptable = (IAdaptable)iter.next();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return (IResource)adaptable.getAdapter((Class)clazz);
            }
        }
        return null;
    }

    public static IJavaProject getJavaProjectByName(String name) {
        IJavaProject[] javaProjects;
        IWorkspaceRoot rootWorkspace = ResourcesPlugin.getWorkspace().getRoot();
        IJavaModel javaModel = JavaCore.create((IWorkspaceRoot)rootWorkspace);
        try {
            javaProjects = javaModel.getJavaProjects();
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        int i = 0;
        while (i < javaProjects.length) {
            IJavaProject javaProject = javaProjects[i];
            if (name.equals(javaProject.getProject().getName())) {
                return javaProject;
            }
            ++i;
        }
        return null;
    }

    public static String getProjectRoot(IJavaProject project) {
        return project.getResource().getLocation().toString();
    }

    public static String resolve(IPath path) {
        if (path == null) {
            return null;
        }
        IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
        if (folder.exists()) {
            return folder.getLocation().toString();
        }
        return null;
    }

    public static IJavaProject getJavaProject(String root) {
        IJavaProject[] javaProjects;
        IWorkspaceRoot rootWorkspace = ResourcesPlugin.getWorkspace().getRoot();
        IJavaModel javaModel = JavaCore.create((IWorkspaceRoot)rootWorkspace);
        try {
            javaProjects = javaModel.getJavaProjects();
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        int i = 0;
        while (i < javaProjects.length) {
            IJavaProject javaProject = javaProjects[i];
            if (root.equals(javaProject.getPath().toString())) {
                return javaProject;
            }
            ++i;
        }
        return null;
    }

    public static String removeProjectRoot(String file, IProject project) {
        String res = ExportUtil.removePrefix(file, String.valueOf('/') + project.getName() + '/');
        if (res.equals(String.valueOf('/') + project.getName())) {
            return ".";
        }
        return res;
    }

    public static String replaceProjectRoot(String file, IProject project, String newProjectRoot) {
        String res = ExportUtil.removeProjectRoot(file, project);
        if (res.equals(".")) {
            return newProjectRoot;
        }
        if (!res.equals(file)) {
            return String.valueOf(newProjectRoot) + '/' + res;
        }
        return res;
    }

    public static Set getClasspathProjects(IJavaProject project) throws JavaModelException {
        TreeSet projects = new TreeSet(ExportUtil.getJavaProjectComparator());
        IClasspathEntry[] entries = project.getRawClasspath();
        ExportUtil.addClasspathProjects(projects, project, entries);
        return projects;
    }

    private static void addClasspathProjects(Set projects, IJavaProject project, IClasspathEntry[] entries) throws JavaModelException {
        int i = 0;
        while (i < entries.length) {
            IClasspathEntry classpathEntry = entries[i];
            if (classpathEntry.getContentKind() == 1) {
                if (classpathEntry.getEntryKind() == 2) {
                    String subProjectRoot = classpathEntry.getPath().toString();
                    IJavaProject subProject = ExportUtil.getJavaProject(subProjectRoot);
                    projects.add(subProject);
                } else if (classpathEntry.getEntryKind() == 5) {
                    IClasspathContainer container = JavaCore.getClasspathContainer((IPath)classpathEntry.getPath(), (IJavaProject)project);
                    IClasspathEntry[] containerEntries = container.getClasspathEntries();
                    ExportUtil.addClasspathProjects(projects, project, containerEntries);
                }
            }
            ++i;
        }
    }

    public static Set getClasspathProjectsRecursive(IJavaProject project) throws JavaModelException {
        TreeSet result = new TreeSet(ExportUtil.getJavaProjectComparator());
        ExportUtil.getClasspathProjectsRecursive(project, result);
        return result;
    }

    private static void getClasspathProjectsRecursive(IJavaProject project, Set result) throws JavaModelException {
        Set projects = ExportUtil.getClasspathProjects(project);
        Iterator iter = projects.iterator();
        while (iter.hasNext()) {
            IJavaProject javaProject = (IJavaProject)iter.next();
            if (!result.add(javaProject)) continue;
            ExportUtil.getClasspathProjectsRecursive(javaProject, result);
        }
    }

    public static boolean hasCyclicDependency(IJavaProject javaProject) throws CoreException {
        IMarker[] markers = javaProject.getProject().findMarkers("org.eclipse.jdt.core.buildpath_problem", false, 1);
        int i = 0;
        while (i < markers.length) {
            IMarker marker = markers[i];
            String cycleAttr = (String)marker.getAttribute("cycleDetected");
            if (cycleAttr != null && cycleAttr.equals("true")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static IType[] findTestsInContainer(String containerHandle) {
        IJavaElement container = JavaCore.create((String)containerHandle);
        if (container == null) {
            return new IType[0];
        }
        Object[] elements = new Object[]{container};
        HashSet result = new HashSet();
        if (elements.length > 0) {
            ExportUtil.doFindTests(elements, result);
        }
        return result.toArray(new IType[result.size()]);
    }

    private static List searchMethod(IJavaSearchScope scope) throws CoreException {
        ArrayList typesFound = new ArrayList(200);
        ExportUtil.searchMethod(typesFound, scope);
        return typesFound;
    }

    private static List searchMethod(List v, IJavaSearchScope scope) throws CoreException {
        JUnitSearchResultCollector requestor = new JUnitSearchResultCollector(v);
        int matchRule = 24;
        SearchPattern suitePattern = SearchPattern.createPattern((String)"suite() Test", (int)1, (int)0, (int)matchRule);
        SearchParticipant[] participants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
        new SearchEngine().search(suitePattern, participants, scope, (SearchRequestor)requestor, null);
        return v;
    }

    private static void doFindTests(Object[] elements, Set result) {
        int nElements = elements.length;
        int i = 0;
        while (i < nElements) {
            try {
                ExportUtil.collectTypes(elements[i], result);
            }
            catch (CoreException e) {
                AntUIPlugin.log(e.getStatus());
            }
            ++i;
        }
    }

    private static void collectTypes(Object element, Set result) throws CoreException {
        element = ExportUtil.computeScope(element);
        while (element instanceof ISourceReference && !(element instanceof ICompilationUnit)) {
            if (element instanceof IType && (ExportUtil.hasSuiteMethod((IType)element) || ExportUtil.isTestType((IType)element))) {
                result.add(element);
                return;
            }
            element = ((IJavaElement)element).getParent();
        }
        if (element instanceof ICompilationUnit) {
            ICompilationUnit cu = (ICompilationUnit)element;
            IType[] types = cu.getAllTypes();
            int i = 0;
            while (i < types.length) {
                if (ExportUtil.hasSuiteMethod(types[i]) || ExportUtil.isTestType(types[i])) {
                    result.add(types[i]);
                }
                ++i;
            }
        } else if (element instanceof IJavaElement) {
            List testCases = ExportUtil.findTestCases((IJavaElement)element);
            List suiteMethods = ExportUtil.searchSuiteMethods((IJavaElement)element);
            while (!suiteMethods.isEmpty()) {
                if (!testCases.contains(suiteMethods.get(0))) {
                    testCases.add(suiteMethods.get(0));
                }
                suiteMethods.remove(0);
            }
            result.addAll(testCases);
        }
    }

    private static List findTestCases(IJavaElement element) throws JavaModelException {
        ArrayList<IType> found = new ArrayList<IType>();
        IJavaProject javaProject = element.getJavaProject();
        IType testCaseType = ExportUtil.testCaseType(javaProject);
        if (testCaseType == null) {
            return found;
        }
        IType[] subtypes = javaProject.newTypeHierarchy(testCaseType, ExportUtil.getRegion(javaProject), null).getAllSubtypes(testCaseType);
        if (subtypes == null) {
            throw new JavaModelException(new CoreException((IStatus)new Status(4, "org.eclipse.ant.ui", 101, null, null)));
        }
        int i = 0;
        while (i < subtypes.length) {
            try {
                if (element.equals(subtypes[i].getAncestor(element.getElementType())) && ExportUtil.hasValidModifiers(subtypes[i])) {
                    found.add(subtypes[i]);
                }
            }
            catch (JavaModelException e) {
                AntUIPlugin.log(e.getStatus());
            }
            ++i;
        }
        return found;
    }

    private static IType testCaseType(IJavaProject javaProject) {
        try {
            return javaProject.findType("junit.framework.TestCase");
        }
        catch (JavaModelException e) {
            AntUIPlugin.log(e.getStatus());
            return null;
        }
    }

    private static IRegion getRegion(IJavaProject javaProject) throws JavaModelException {
        IRegion region = JavaCore.newRegion();
        IJavaElement[] elements = javaProject.getChildren();
        int i = 0;
        while (i < elements.length) {
            if (!((IPackageFragmentRoot)elements[i]).isArchive()) {
                region.add(elements[i]);
            }
            ++i;
        }
        return region;
    }

    private static Object computeScope(Object element) throws JavaModelException {
        if (element instanceof IFileEditorInput) {
            element = ((IFileEditorInput)element).getFile();
        }
        if (element instanceof IResource) {
            element = JavaCore.create((IResource)((IResource)element));
        }
        if (element instanceof IClassFile) {
            IClassFile cf = (IClassFile)element;
            element = cf.getType();
        }
        return element;
    }

    private static List searchSuiteMethods(IJavaElement element) throws CoreException {
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{element}, (int)1);
        return ExportUtil.searchMethod(scope);
    }

    private static boolean hasSuiteMethod(IType type) throws JavaModelException {
        IMethod method = type.getMethod("suite", new String[0]);
        if (method == null || !method.exists()) {
            return false;
        }
        if (!(Flags.isStatic((int)method.getFlags()) && Flags.isPublic((int)method.getFlags()) && Flags.isPublic((int)method.getDeclaringType().getFlags()))) {
            return false;
        }
        return Signature.getSimpleName((String)Signature.toString((String)method.getReturnType())).equals("Test");
    }

    private static boolean isTestType(IType type) throws JavaModelException {
        if (!ExportUtil.hasValidModifiers(type)) {
            return false;
        }
        IType[] interfaces = type.newSupertypeHierarchy(null).getAllSuperInterfaces(type);
        int i = 0;
        while (i < interfaces.length) {
            if (interfaces[i].getFullyQualifiedName('.').equals("junit.framework.Test")) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean hasValidModifiers(IType type) throws JavaModelException {
        if (Flags.isAbstract((int)type.getFlags())) {
            return false;
        }
        return Flags.isPublic((int)type.getFlags());
    }

    public static Comparator getJavaProjectComparator() {
        if (javaProjectComparator == null) {
            javaProjectComparator = new JavaProjectComparator();
        }
        return javaProjectComparator;
    }

    public static String removePrefix(String s, String prefix) {
        if (s == null) {
            return null;
        }
        if (s.startsWith(prefix)) {
            return s.substring(prefix.length());
        }
        return s;
    }

    public static String removeSuffix(String s, String suffix) {
        if (s == null) {
            return null;
        }
        if (s.endsWith(suffix)) {
            return s.substring(0, s.length() - suffix.length());
        }
        return s;
    }

    public static String removePrefixAndSuffix(String s, String prefix, String suffix) {
        return ExportUtil.removePrefix(ExportUtil.removeSuffix(s, suffix), prefix);
    }

    public static String toString(Document doc) throws TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException {
        StringWriter writer = new StringWriter();
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(writer);
        TransformerFactory factory = TransformerFactory.newInstance();
        boolean indentFallback = false;
        try {
            factory.setAttribute("indent-number", "4");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            indentFallback = true;
        }
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        if (indentFallback) {
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        }
        transformer.transform(source, result);
        return writer.toString();
    }

    public static String addEntity(Document doc, String name, String file) throws TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException {
        String xml = ExportUtil.toString(doc);
        return ExportUtil.addEntity(xml, name, file);
    }

    public static String addEntity(String xml, String name, String file) {
        StringBuffer xmlBuffer = new StringBuffer(xml);
        int index = xmlBuffer.indexOf(NEWLINE) != -1 ? xmlBuffer.indexOf(NEWLINE) : 0;
        StringBuffer entity = new StringBuffer();
        entity.append(NEWLINE);
        entity.append("<!DOCTYPE project [<!ENTITY ");
        entity.append(name);
        entity.append(" SYSTEM \"file:");
        entity.append(file);
        entity.append("\">]>");
        xmlBuffer.insert(index, entity.toString());
        index = xmlBuffer.indexOf("basedir") != -1 ? xmlBuffer.indexOf("basedir") : 0;
        index = xmlBuffer.indexOf(NEWLINE, index);
        if (index != -1) {
            xmlBuffer.insert(index, String.valueOf(NEWLINE) + "    &" + name + ';');
        }
        return xmlBuffer.toString();
    }

    private static class JUnitSearchResultCollector
    extends SearchRequestor {
        List fList;
        Set fFailed = new HashSet();
        Set fMatches = new HashSet();

        public JUnitSearchResultCollector(List list) {
            this.fList = list;
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            Object enclosingElement = match.getElement();
            if (!(enclosingElement instanceof IMethod)) {
                return;
            }
            IMethod method = (IMethod)enclosingElement;
            IType declaringType = method.getDeclaringType();
            if (this.fMatches.contains(declaringType) || this.fFailed.contains(declaringType)) {
                return;
            }
            if (!ExportUtil.hasSuiteMethod(declaringType) && !ExportUtil.isTestType(declaringType)) {
                this.fFailed.add(declaringType);
                return;
            }
            this.fMatches.add(declaringType);
        }

        public void endReporting() {
            this.fList.addAll(this.fMatches);
        }
    }

    private static class JavaProjectComparator
    implements Comparator {
        JavaProjectComparator() {
        }

        public int compare(Object o1, Object o2) {
            IJavaProject j1 = (IJavaProject)o1;
            IJavaProject j2 = (IJavaProject)o2;
            return j1.getProject().getName().compareTo(j2.getProject().getName());
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            return this.compare(this, obj) == 0;
        }
    }
}

