/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.launchConfigurations;

import org.eclipse.ant.internal.ui.launchConfigurations.AntLaunchConfigurationMessages;
import org.eclipse.ant.internal.ui.launchConfigurations.AntTargetsTab;
import org.eclipse.ant.internal.ui.preferences.DialogSettingsHelper;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class SetTargetsDialog
extends Dialog {
    private static String DIALOG_SETTINGS_SECTION = "SetTargetsDialogSettings";
    private ILaunchConfigurationWorkingCopy fConfiguration;
    private AntTargetsTab fTargetsTab;

    public SetTargetsDialog(Shell parentShell, ILaunchConfigurationWorkingCopy config) {
        super(parentShell);
        this.setShellStyle(0x10 | this.getShellStyle());
        this.fConfiguration = config;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(AntLaunchConfigurationMessages.SetTargetsDialog_0);
        Composite composite = (Composite)super.createDialogArea(parent);
        this.fTargetsTab = new AntTargetsTab();
        this.fTargetsTab.createControl(composite);
        this.fTargetsTab.initializeFrom((ILaunchConfiguration)this.fConfiguration);
        SetTargetsDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void okPressed() {
        this.fTargetsTab.performApply(this.fConfiguration);
        super.okPressed();
    }

    protected String getTargetsSelected() {
        String defaultValue = null;
        if (!this.fTargetsTab.isTargetSelected()) {
            defaultValue = "";
        }
        try {
            return this.fConfiguration.getAttribute("org.eclipse.ui.externaltools.ATTR_ANT_TARGETS", defaultValue);
        }
        catch (CoreException coreException) {
            return defaultValue;
        }
    }

    public boolean close() {
        DialogSettingsHelper.persistShellGeometry(this.getShell(), DIALOG_SETTINGS_SECTION);
        return super.close();
    }

    protected Point getInitialLocation(Point initialSize) {
        Point p = DialogSettingsHelper.getInitialLocation(DIALOG_SETTINGS_SECTION);
        return p != null ? p : super.getInitialLocation(initialSize);
    }

    protected Point getInitialSize() {
        Point p = super.getInitialSize();
        return DialogSettingsHelper.getInitialSize(DIALOG_SETTINGS_SECTION, p);
    }
}

