/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.model.internal.validation;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jem.java.ArrayType;
import org.eclipse.jem.java.Field;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaPackage;
import org.eclipse.jem.java.JavaParameter;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jem.java.JavaVisibilityKind;
import org.eclipse.jem.java.Method;
import org.eclipse.jem.util.logger.LogEntry;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jst.j2ee.core.internal.plugin.J2EECorePlugin;
import org.eclipse.jst.j2ee.ejb.CMPAttribute;
import org.eclipse.jst.j2ee.ejb.CMRField;
import org.eclipse.jst.j2ee.ejb.ContainerManagedEntity;
import org.eclipse.jst.j2ee.ejb.EJBRelationshipRole;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Query;
import org.eclipse.jst.j2ee.ejb.QueryMethod;
import org.eclipse.jst.j2ee.ejb.Session;
import org.eclipse.jst.j2ee.ejb.internal.impl.LocalModelledPersistentAttributeFilter;
import org.eclipse.jst.j2ee.model.internal.validation.IEJBValidationContext;
import org.eclipse.jst.j2ee.model.internal.validation.InvalidInputException;

public final class ValidationRuleUtility {
    public static long method_and_field_counter = 1L;
    private static final String[] _reservedWords = new String[]{"SELECT", "FROM", "WHERE", "DISTINCT", "OBJECT", "NULL", "TRUE", "FALSE", "NOT", "AND", "OR", "BETWEEN", "LIKE", "IN", "AS", "UNKNOWN", "EMPTY", "MEMBER", "OF", "IS"};
    private static final String COMMA = ", ";
    private static LogEntry logEntry = null;
    private static Logger logger = null;
    public static HashMap helperMap = null;
    private static HashSet commonClassNames = null;

    public static JavaClass getCMRFieldType(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, CMRField field) {
        EJBRelationshipRole role = field.getRole();
        if (!role.isMany()) {
            ContainerManagedEntity cmp = role.getTypeEntity();
            if (cmp == null) {
                return null;
            }
            JavaClass local = cmp.getLocalInterface();
            try {
                ValidationRuleUtility.isValidTypeHierarchy(cmp, (JavaHelpers)local);
            }
            catch (InvalidInputException invalidInputException) {
                return null;
            }
            return local;
        }
        return field.getCollectionType();
    }

    public static final boolean followsFinderExceptionRules(EnterpriseBean bean, Method method) throws InvalidInputException {
        return ValidationRuleUtility.throwsFinderException(bean, method);
    }

    public static final boolean followsObjectNotFoundExceptionRules(EnterpriseBean bean, Method method) throws InvalidInputException {
        JavaHelpers javaUtilEnumeration = ValidationRuleUtility.getType("java.util.Enumeration", bean);
        if (ValidationRuleUtility.isAssignableFrom(method.getReturnType(), javaUtilEnumeration)) {
            return !ValidationRuleUtility.throwsObjectNotFoundException(bean, method);
        }
        JavaHelpers javaUtilCollection = ValidationRuleUtility.getType("java.util.Collection", bean);
        if (ValidationRuleUtility.isAssignableFrom(method.getReturnType(), javaUtilCollection)) {
            return !ValidationRuleUtility.throwsObjectNotFoundException(bean, method);
        }
        return true;
    }

    private static Method getMethod(String name, JavaParameter[] parameterTypes, List methodList) {
        if (methodList == null) {
            return null;
        }
        Method method = null;
        JavaParameter[] params = null;
        boolean found = false;
        Iterator iterator = methodList.iterator();
        while (iterator.hasNext()) {
            method = (Method)iterator.next();
            if (!method.getName().equals(name) || (params = method.listParametersWithoutReturn()).length != parameterTypes.length) continue;
            found = true;
            int j = 0;
            while (j < params.length) {
                JavaHelpers type;
                JavaHelpers parm = (JavaHelpers)params[j].getEType();
                if (!ValidationRuleUtility.isSameType(parm, type = (JavaHelpers)parameterTypes[j].getEType())) {
                    found = false;
                    break;
                }
                ++j;
            }
            if (!found) continue;
            return method;
        }
        return null;
    }

    private static Method getMethod(String name, JavaHelpers[] parameterTypes, List methodList) {
        if (methodList == null) {
            return null;
        }
        Method method = null;
        JavaParameter[] params = null;
        boolean found = false;
        Iterator iterator = methodList.iterator();
        while (iterator.hasNext()) {
            method = (Method)iterator.next();
            if (!method.getName().equals(name) || (params = method.listParametersWithoutReturn()).length != parameterTypes.length) continue;
            found = true;
            int j = 0;
            while (j < params.length) {
                JavaHelpers type;
                JavaHelpers parm = (JavaHelpers)params[j].getEType();
                if (!ValidationRuleUtility.isSameType(parm, type = parameterTypes[j])) {
                    found = false;
                    break;
                }
                ++j;
            }
            if (!found) continue;
            return method;
        }
        return null;
    }

    public static Method getMethod(Method methodToMatch, String methodNameToFind, List methodsExtendedList) {
        if (methodsExtendedList == null) {
            return null;
        }
        return ValidationRuleUtility.getMethod(methodNameToFind, methodToMatch.listParametersWithoutReturn(), methodsExtendedList);
    }

    public static Method getMethodExtended(JavaClass clazz, Method methodToMatch, String methodNameToFind) throws InvalidInputException {
        if (clazz == null || methodToMatch == null || methodNameToFind == null) {
            return null;
        }
        return ValidationRuleUtility.getMethodExtended(clazz, methodNameToFind, methodToMatch.listParametersWithoutReturn());
    }

    public static Method getMethodExtended(JavaClass clazz, String methodName, JavaParameter[] parameterTypes) {
        if (clazz.isInterface()) {
            return ValidationRuleUtility.getMethodInterfaceExtended(clazz, methodName, parameterTypes);
        }
        Method method = null;
        EList methods = null;
        do {
            if ((method = ValidationRuleUtility.getMethod(methodName, parameterTypes, (List)(methods = clazz.getMethods()))) != null) {
                return method;
            }
            clazz = clazz.getSupertype();
        } while (method == null && clazz != null);
        return null;
    }

    public static Method getMethodExtended(JavaClass clazz, String methodName, JavaHelpers[] parameterTypes) {
        return ValidationRuleUtility.getMethodExtended(clazz, methodName, parameterTypes, null);
    }

    public static Method getMethodExtended(JavaClass clazz, String methodName, JavaHelpers[] parameterTypes, JavaHelpers retType) {
        if (clazz.isInterface()) {
            return ValidationRuleUtility.getMethodInterfaceExtended(clazz, methodName, parameterTypes);
        }
        Method method = null;
        EList methods = null;
        do {
            if ((method = ValidationRuleUtility.getMethod(methodName, parameterTypes, (List)(methods = clazz.getMethods()))) != null) {
                if (retType != null) {
                    JavaHelpers methRetType = method.getReturnType();
                    if (ValidationRuleUtility.isAssignableFrom(methRetType, retType)) {
                        return method;
                    }
                } else {
                    return method;
                }
            }
            clazz = clazz.getSupertype();
        } while (method == null && clazz != null);
        return null;
    }

    public static Method getMethodInterfaceExtended(JavaClass clazz, String methodName, JavaParameter[] parameterTypes) {
        if (clazz == null) {
            return null;
        }
        Method method = ValidationRuleUtility.getMethod(methodName, parameterTypes, (List)clazz.getMethods());
        if (method != null) {
            return method;
        }
        EList classesToCheck = clazz.getImplementsInterfaces();
        Iterator clazzIterator = classesToCheck.iterator();
        while (clazzIterator.hasNext()) {
            clazz = (JavaClass)clazzIterator.next();
            method = ValidationRuleUtility.getMethodInterfaceExtended(clazz, methodName, parameterTypes);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    public static Method getMethodInterfaceExtended(JavaClass clazz, String methodName, JavaHelpers[] parameterTypes) {
        if (clazz == null) {
            return null;
        }
        Method method = ValidationRuleUtility.getMethod(methodName, parameterTypes, (List)clazz.getMethods());
        if (method != null) {
            return method;
        }
        EList classesToCheck = clazz.getImplementsInterfaces();
        Iterator clazzIterator = classesToCheck.iterator();
        while (clazzIterator.hasNext()) {
            clazz = (JavaClass)clazzIterator.next();
            method = ValidationRuleUtility.getMethodInterfaceExtended(clazz, methodName, parameterTypes);
            if (method == null) continue;
            return method;
        }
        return null;
    }

    public static final Set getNotSubsetExceptions(EnterpriseBean bean, Method method, Method methodToMatch) {
        if (methodToMatch == null || method == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<JavaClass> exceptions = new HashSet<JavaClass>();
        EList methToMatchExceptions = methodToMatch.getJavaExceptions();
        EList foundMethExceptions = method.getJavaExceptions();
        int i = 0;
        while (i < foundMethExceptions.size()) {
            JavaClass exc = (JavaClass)foundMethExceptions.get(i);
            if (!(ValidationRuleUtility.isRuntimeException(exc, bean) || ValidationRuleUtility.isRemoteException(exc, bean) || ValidationRuleUtility.isExceptionInList(exc, (List)methToMatchExceptions))) {
                exceptions.add(exc);
            }
            ++i;
        }
        return exceptions;
    }

    public static final Set getNotSubsetSubtypeExceptions(EnterpriseBean bean, Method method, Method methodToMatch) {
        if (methodToMatch == null || method == null) {
            return Collections.EMPTY_SET;
        }
        HashSet<JavaClass> exceptions = new HashSet<JavaClass>();
        EList methToMatchExceptions = methodToMatch.getJavaExceptions();
        EList foundMethExceptions = method.getJavaExceptions();
        int i = 0;
        while (i < foundMethExceptions.size()) {
            JavaClass exc = (JavaClass)foundMethExceptions.get(i);
            if (!(ValidationRuleUtility.isRuntimeException(exc, bean) || ValidationRuleUtility.isRemoteException(exc, bean) || ValidationRuleUtility.isSubtypeExceptionInList(exc, (List)methToMatchExceptions))) {
                exceptions.add(exc);
            }
            ++i;
        }
        return exceptions;
    }

    public static boolean isEJBHomeMethod(EnterpriseBean bean, Method method) {
        return ValidationRuleUtility.isSameType(bean, method.getContainingJavaClass(), "javax.ejb.EJBHome");
    }

    public static boolean isEJBObjectMethod(EnterpriseBean bean, Method method) {
        return ValidationRuleUtility.isSameType(bean, method.getContainingJavaClass(), "javax.ejb.EJBObject");
    }

    public static final boolean isExceptionInList(JavaClass exc, List exceptionList) {
        if (exc == null || exceptionList == null) {
            return false;
        }
        if (!exc.isExistingType()) {
            return false;
        }
        Iterator iterator = exceptionList.iterator();
        while (iterator.hasNext()) {
            JavaClass exception = (JavaClass)iterator.next();
            if (!ValidationRuleUtility.isAssignableFrom((JavaHelpers)exc, (JavaHelpers)exception)) continue;
            return true;
        }
        return false;
    }

    public static final boolean isSubtypeExceptionInList(JavaClass exc, List exceptionList) {
        if (exc == null || exceptionList == null) {
            return false;
        }
        if (!exc.isExistingType()) {
            return false;
        }
        Iterator iterator = exceptionList.iterator();
        while (iterator.hasNext()) {
            JavaClass exception = (JavaClass)iterator.next();
            if (!ValidationRuleUtility.isAssignableFrom((JavaHelpers)exception, (JavaHelpers)exc)) continue;
            return true;
        }
        return false;
    }

    public static final String getQualifiedName(JavaHelpers helper) {
        if (helper == null) {
            return "";
        }
        return helper.getJavaName();
    }

    public static final String getParmsAsString(Method method) {
        if (method == null) {
            return "";
        }
        return ValidationRuleUtility.getParmsAsString(method.listParametersWithoutReturn());
    }

    public static final String getParmsAsString(JavaParameter[] parm) {
        if (parm.length == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < parm.length) {
            JavaHelpers type = parm[i].getJavaType();
            buffer.append(type == null ? "null" : type.getJavaName());
            buffer.append(COMMA);
            ++i;
        }
        return buffer.substring(0, buffer.length() - 2);
    }

    public static final String getParmsAsString(JavaHelpers[] parm) {
        if (parm.length == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < parm.length) {
            JavaHelpers type = parm[i];
            buffer.append(type == null ? "null" : type.getJavaName());
            buffer.append(COMMA);
            ++i;
        }
        return buffer.substring(0, buffer.length() - 2);
    }

    public static final JavaHelpers getType(EClassifier classifier) {
        if (classifier == null) {
            return null;
        }
        JavaHelpers type = (JavaHelpers)classifier;
        return type;
    }

    public static JavaHelpers getType(String javaClassName, EnterpriseBean ejb) throws InvalidInputException {
        if (javaClassName == null || javaClassName.equals("") || ejb == null) {
            throw new InvalidInputException();
        }
        Resource resource = ejb.eResource();
        if (resource == null) {
            throw new InvalidInputException();
        }
        JavaHelpers helper = null;
        if (commonClassNames == null || commonClassNames.isEmpty()) {
            ValidationRuleUtility.initializeCommonClassNames();
        }
        if (commonClassNames.contains(javaClassName)) {
            if (helperMap == null) {
                helperMap = new HashMap();
            }
            ResourceSet rSet = resource.getResourceSet();
            Object obj = helperMap.get(javaClassName);
            if (obj != null) {
                return (JavaHelpers)obj;
            }
            helper = ValidationRuleUtility.getType(javaClassName, rSet);
            helperMap.put(javaClassName, helper);
        } else {
            helper = ValidationRuleUtility.getType(javaClassName, resource.getResourceSet());
        }
        return helper;
    }

    private static void initializeCommonClassNames() {
        if (commonClassNames == null) {
            commonClassNames = new HashSet();
        }
        commonClassNames.add("java.io.IOException");
        commonClassNames.add("java.io.Serializable");
        commonClassNames.add("java.lang.Object");
        commonClassNames.add("java.lang.Exception");
        commonClassNames.add("java.lang.RuntimeException");
        commonClassNames.add("java.rmi.Remote");
        commonClassNames.add("java.rmi.RemoteException");
        commonClassNames.add("java.util.Collection");
        commonClassNames.add("java.util.Enumeration");
        commonClassNames.add("java.util.Set");
        commonClassNames.add("javax.ejb.CreateException");
        commonClassNames.add("javax.ejb.EntityBean");
        commonClassNames.add("javax.ejb.EJBException");
        commonClassNames.add("javax.ejb.EJBHome");
        commonClassNames.add("javax.ejb.EJBLocalHome");
        commonClassNames.add("javax.ejb.EJBObject");
        commonClassNames.add("javax.ejb.EJBLocalObject");
        commonClassNames.add("javax.ejb.EntityContext");
        commonClassNames.add("javax.ejb.FinderException");
        commonClassNames.add("javax.ejb.MessageDrivenBean");
        commonClassNames.add("javax.ejb.ObjectNotFoundException");
        commonClassNames.add("javax.ejb.SessionBean");
        commonClassNames.add("javax.ejb.SessionContext");
        commonClassNames.add("javax.ejb.SessionSynchronization");
        commonClassNames.add("javax.jms.Message");
        commonClassNames.add("javax.jms.MessageListener");
        commonClassNames.add("javax.transaction.UserTransaction");
    }

    public static JavaHelpers getType(String javaClassName, ResourceSet resourceSet) throws InvalidInputException {
        return ValidationRuleUtility.getType(javaClassName, resourceSet, true);
    }

    public static JavaHelpers getType(String javaClassName, ResourceSet resourceSet, boolean throwExcIfNotValid) throws InvalidInputException {
        if (javaClassName == null || javaClassName.equals("") || resourceSet == null) {
            Logger aLogger = ValidationRuleUtility.getMsgLogger();
            if (aLogger.isLoggingLevel(Level.FINEST)) {
                LogEntry entry = ValidationRuleUtility.getLogEntry();
                entry.setSourceID("ValidationRuleUtility.getType(String, ResourceSet, boolean)");
                String text = "invalid parameter; javaClassName = {0} and resourceSet = {1}";
                String result = MessageFormat.format(text, javaClassName, String.valueOf(resourceSet));
                entry.setText(result);
                entry.appendStackTrace();
                aLogger.write(Level.FINEST, (Object)entry);
            }
            throw new InvalidInputException();
        }
        JavaHelpers helper = JavaRefFactory.eINSTANCE.reflectType(javaClassName, resourceSet);
        if (throwExcIfNotValid) {
            ValidationRuleUtility.isValidType(helper);
        }
        return helper;
    }

    private static LogEntry getLogEntry() {
        if (logEntry == null) {
            logEntry = new LogEntry("ejbvalidator");
        }
        logEntry.reset();
        return logEntry;
    }

    private static Logger getMsgLogger() {
        if (logger == null) {
            logger = J2EECorePlugin.getPlugin().getMsgLogger();
        }
        return logger;
    }

    public static final JavaHelpers getType(Field field) {
        if (field == null) {
            return null;
        }
        return (JavaHelpers)field.getEType();
    }

    public static final boolean onClass(JavaClass clazz, Method method) {
        if (clazz == null || method == null) {
            return false;
        }
        return clazz.equals(method.getJavaClass());
    }

    public static final boolean onClass(JavaClass clazz, Field field) {
        if (clazz == null || field == null) {
            return false;
        }
        return clazz.equals(field.getJavaClass());
    }

    public static final boolean isApplicationException(JavaClass exception, EnterpriseBean bean) {
        if (exception == null) {
            return false;
        }
        try {
            if (ValidationRuleUtility.isSameType((JavaHelpers)exception, ValidationRuleUtility.getType("javax.ejb.EJBException", bean))) {
                return false;
            }
        }
        catch (InvalidInputException invalidInputException) {}
        return !ValidationRuleUtility.isRemoteException(exception, bean);
    }

    public static final boolean isRemoteMethod(IEJBValidationContext vc, EnterpriseBean bean, JavaClass clazz, Method method) {
        try {
            JavaHelpers javaRmiRemote = ValidationRuleUtility.getType("java.rmi.Remote", bean);
            return ValidationRuleUtility.isAssignableFrom((JavaHelpers)clazz, javaRmiRemote);
        }
        catch (InvalidInputException invalidInputException) {
            return false;
        }
    }

    public static final boolean isReservedWord(String name) {
        if (name == null) {
            return false;
        }
        String upperName = name.toUpperCase();
        int i = 0;
        while (i < _reservedWords.length) {
            if (upperName.equals(_reservedWords[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static final boolean isRuntimeException(JavaClass clazz, EnterpriseBean bean) {
        if (clazz == null) {
            return false;
        }
        try {
            JavaHelpers runtimeExc = ValidationRuleUtility.getType("java.lang.RuntimeException", bean);
            return ValidationRuleUtility.isException(clazz, runtimeExc.getWrapper());
        }
        catch (InvalidInputException invalidInputException) {
            return false;
        }
    }

    public static final boolean isRemoteException(JavaClass clazz, EnterpriseBean bean) {
        if (clazz == null) {
            return false;
        }
        try {
            JavaHelpers remoteExc = ValidationRuleUtility.getType("java.rmi.RemoteException", bean);
            return ValidationRuleUtility.isException(clazz, remoteExc.getWrapper());
        }
        catch (InvalidInputException invalidInputException) {
            return false;
        }
    }

    public static final boolean isException(JavaClass clazz, JavaClass exception) {
        if (clazz == null || exception == null) {
            return false;
        }
        return ValidationRuleUtility.isAssignableFrom((JavaHelpers)clazz, (JavaHelpers)exception);
    }

    public static boolean isAssignableFromCollection(JavaHelpers type, EnterpriseBean bean) throws InvalidInputException {
        JavaHelpers javaUtilCollection = ValidationRuleUtility.getType("java.util.Collection", bean);
        return ValidationRuleUtility.isAssignableFrom(type, javaUtilCollection);
    }

    public static boolean isAssignableFromEnumeration(JavaHelpers type, EnterpriseBean bean) throws InvalidInputException {
        JavaHelpers javaUtilEnumeration = ValidationRuleUtility.getType("java.util.Enumeration", bean);
        return ValidationRuleUtility.isAssignableFrom(type, javaUtilEnumeration);
    }

    public static boolean isAssignableFromSet(JavaHelpers type, EnterpriseBean bean) throws InvalidInputException {
        JavaHelpers javaUtilSet = ValidationRuleUtility.getType("java.util.Set", bean);
        return ValidationRuleUtility.isAssignableFrom(type, javaUtilSet);
    }

    public static boolean isAssignableFrom(JavaHelpers type, JavaHelpers compareType) {
        if (type == null || compareType == null) {
            return false;
        }
        if (type.isPrimitive() || compareType.isPrimitive()) {
            if (type.isPrimitive() && compareType.isPrimitive()) {
                return type.getPrimitive().equals(compareType.getPrimitive());
            }
            return false;
        }
        if (type.isArray() && compareType.isArray()) {
            JavaClass classType = type.getWrapper();
            JavaClass classCompareType = compareType.getWrapper();
            if (classType == null || compareType == null) {
                return false;
            }
            JavaHelpers finalType = ((ArrayType)classType).getFinalComponentType();
            JavaHelpers finalCompareType = ((ArrayType)classCompareType).getFinalComponentType();
            return ValidationRuleUtility.isAssignableFrom(finalType, finalCompareType);
        }
        return compareType.getWrapper().isAssignableFrom((EClassifier)type.getWrapper());
    }

    public static final boolean isAssociatedWithQuery(ContainerManagedEntity cmp, Method method) {
        EList queries = cmp.getQueries();
        Iterator iterator = queries.iterator();
        boolean found = false;
        while (iterator.hasNext()) {
            Query query = (Query)iterator.next();
            QueryMethod queryMethod = query.getQueryMethod();
            if (queryMethod == null || queryMethod.getName() == null || queryMethod.getName().equals("") || !queryMethod.getName().equals(method.getName())) continue;
            found = true;
            break;
        }
        return found;
    }

    public static final boolean isBeanManagedSession(EnterpriseBean bean) {
        if (bean == null) {
            return false;
        }
        if (bean.isEntity()) {
            return false;
        }
        return ((Session)bean).getTransactionType().getValue() == 0;
    }

    public static boolean isClinitMethod(EnterpriseBean bean, Method method) {
        if (method == null) {
            return false;
        }
        return method.getName().equals("<clinit>");
    }

    public static final boolean isJNDINamingContext(Field field) {
        return true;
    }

    public static boolean isJavaLangObjectField(EnterpriseBean bean, Field field) {
        return ValidationRuleUtility.isSameType(bean, field.getContainingJavaClass(), "java.lang.Object");
    }

    public static boolean isOwnedBy(EnterpriseBean bean, Method method, String className) {
        return ValidationRuleUtility.isSameType(bean, method.getContainingJavaClass(), className);
    }

    public static boolean isSameType(EnterpriseBean bean, JavaClass owner, String className) {
        JavaHelpers helper;
        block3: {
            try {
                helper = ValidationRuleUtility.getType(className, bean);
                if (helper != null) break block3;
                return false;
            }
            catch (InvalidInputException invalidInputException) {
                return false;
            }
        }
        JavaClass object = helper.getWrapper();
        return ValidationRuleUtility.isSameType((JavaHelpers)owner, (JavaHelpers)object);
    }

    public static boolean isSameType(JavaHelpers owner, JavaHelpers object) {
        if (owner == null) {
            return false;
        }
        if (object == null) {
            return false;
        }
        if (owner.isPrimitive() && object.isPrimitive()) {
            return owner.getPrimitive().equals(object.getPrimitive());
        }
        if (owner.isArray() && object.isArray()) {
            ArrayType ownerArray = (ArrayType)owner;
            ArrayType objectArray = (ArrayType)object;
            return ValidationRuleUtility.isSameType(ownerArray.getFinalComponentType(), objectArray.getFinalComponentType());
        }
        if (owner.getWrapper() != null && object.getWrapper() != null) {
            return owner.getWrapper().equals(object.getWrapper());
        }
        return false;
    }

    public static boolean isJavaLangObjectMethod(EnterpriseBean bean, Method method) {
        return ValidationRuleUtility.isSameType(bean, method.getContainingJavaClass(), "java.lang.Object");
    }

    public static final boolean isLegalRMI_IIOPInheritance(JavaClass clazz) {
        return true;
    }

    public static final boolean isLegalRMI_IIOPType(EnterpriseBean bean, JavaHelpers helper) throws InvalidInputException {
        if (helper == null) {
            return false;
        }
        return ValidationRuleUtility.isSerializable(helper, bean);
    }

    public static final boolean isLocalType(EnterpriseBean bean, JavaHelpers type) {
        try {
            if (ValidationRuleUtility.isSameType(type, ValidationRuleUtility.getType("java.lang.Object", bean))) {
                return false;
            }
        }
        catch (InvalidInputException invalidInputException) {
            return false;
        }
        if (ValidationRuleUtility.isAssignableFrom((JavaHelpers)bean.getLocalInterface(), type)) {
            return true;
        }
        if (ValidationRuleUtility.isAssignableFrom((JavaHelpers)bean.getLocalHomeInterface(), type)) {
            return true;
        }
        try {
            JavaHelpers ejbLocalHome = ValidationRuleUtility.getType("javax.ejb.EJBLocalHome", bean);
            if (ValidationRuleUtility.isAssignableFrom(ejbLocalHome, type)) {
                return true;
            }
        }
        catch (InvalidInputException invalidInputException) {}
        try {
            JavaHelpers ejbLocalObject = ValidationRuleUtility.getType("javax.ejb.EJBLocalObject", bean);
            if (ValidationRuleUtility.isAssignableFrom(ejbLocalObject, type)) {
                return true;
            }
        }
        catch (InvalidInputException invalidInputException) {}
        return false;
    }

    public static final boolean usesUnknownPrimaryKey(EnterpriseBean bean) {
        if (bean.isContainerManagedEntity()) {
            return ValidationRuleUtility.usesUnknownPrimaryKey((ContainerManagedEntity)bean);
        }
        return false;
    }

    public static final boolean usesUnknownPrimaryKey(ContainerManagedEntity cmp) {
        List cmpFields;
        if (cmp == null) {
            return false;
        }
        try {
            if (ValidationRuleUtility.isSameType((JavaHelpers)cmp.getPrimaryKey(), ValidationRuleUtility.getType("java.lang.Object", cmp))) {
                return true;
            }
        }
        catch (InvalidInputException invalidInputException) {
            return false;
        }
        if (cmp.getVersionID() == 20 && (cmpFields = cmp.getFilteredFeatures(LocalModelledPersistentAttributeFilter.singleton())) != null && !cmpFields.isEmpty()) {
            Iterator iterator = cmpFields.iterator();
            while (iterator.hasNext()) {
                CMPAttribute attrib = (CMPAttribute)iterator.next();
                if (!ValidationRuleUtility.isUnknownPrimaryKey(attrib)) continue;
                return true;
            }
        }
        return false;
    }

    public static final boolean isUnidirectionalRelationship(IEJBValidationContext vc, EJBRelationshipRole role) {
        ContainerManagedEntity sourceEntity = role.getSource().getEntityBean();
        if (sourceEntity == null) {
            return false;
        }
        if (!sourceEntity.isContainerManagedEntity()) {
            return false;
        }
        CMRField sourceCMRField = role.getCmrField();
        if (sourceCMRField == null) {
            return false;
        }
        EJBRelationshipRole opposite = role.getOpposite();
        if (opposite == null) {
            return false;
        }
        CMRField oppositeCMRField = opposite.getCmrField();
        return oppositeCMRField == null;
    }

    public static final boolean isUnknownPrimaryKey(CMPAttribute attrib) {
        if (attrib == null) {
            return false;
        }
        return "wasGenUnknownkeyValue".equals(attrib.getName());
    }

    public static final boolean isPrimitivePrimaryKey(ContainerManagedEntity cmp) {
        if (cmp == null) {
            return false;
        }
        return cmp.getPrimKeyField() != null && !cmp.getPrimKeyField().eIsProxy();
    }

    public static final boolean isPublic(Field field) {
        if (field == null) {
            return false;
        }
        return JavaVisibilityKind.PUBLIC_LITERAL == field.getJavaVisibility();
    }

    public static final boolean isPublic(Method method) {
        if (method == null) {
            return false;
        }
        return JavaVisibilityKind.PUBLIC_LITERAL == method.getJavaVisibility();
    }

    public static final boolean isSerializable(JavaHelpers cl, EnterpriseBean bean) throws InvalidInputException {
        JavaHelpers remote;
        if (cl == null) {
            return true;
        }
        ValidationRuleUtility.isValidType(cl);
        if (cl.isPrimitive()) {
            return true;
        }
        if (cl.isArray()) {
            ArrayType array = (ArrayType)cl;
            if (array.isPrimitiveArray()) {
                return true;
            }
            cl = array.getFinalComponentType();
        }
        if (ValidationRuleUtility.isAssignableFrom(cl, remote = ValidationRuleUtility.getType("java.rmi.Remote", bean))) {
            return true;
        }
        JavaHelpers serial = ValidationRuleUtility.getType("java.io.Serializable", bean);
        return ValidationRuleUtility.isAssignableFrom(cl, serial);
    }

    public static final boolean isStateful(EnterpriseBean bean) {
        if (bean == null) {
            return false;
        }
        if (bean.isEntity()) {
            return false;
        }
        return ((Session)bean).getSessionType().getValue() == 0;
    }

    public static final boolean isStateless(EnterpriseBean bean) {
        if (bean == null) {
            return false;
        }
        if (bean.isEntity()) {
            return false;
        }
        return ((Session)bean).getSessionType().getValue() == 1;
    }

    public static boolean isUnnamedPackage(JavaPackage pkg) {
        if (pkg == null) {
            return true;
        }
        String pkgName = pkg.getName();
        return pkgName == null || pkgName.equals("");
    }

    public static final boolean isValidJavaIdentifier(String name) {
        if (name == null) {
            return false;
        }
        char[] nameChar = name.toCharArray();
        if (nameChar.length < 1) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(nameChar[0])) {
            return false;
        }
        boolean isValidJavaIdentifier = true;
        int i = 1;
        while (i < nameChar.length) {
            if (!Character.isJavaIdentifierPart(nameChar[i])) {
                isValidJavaIdentifier = false;
                break;
            }
            ++i;
        }
        return isValidJavaIdentifier;
    }

    public static final boolean isValidSessionTypeElement(Session session) {
        if (session == null) {
            return false;
        }
        if (!session.isSetSessionType()) {
            return false;
        }
        if (session.getSessionType() == null) {
            return false;
        }
        if (session.getSessionType().getValue() == 0) {
            return true;
        }
        return session.getSessionType().getValue() == 1;
    }

    public static final boolean isValidTransactionTypeElement(Session sessionBean) {
        if (sessionBean == null) {
            return false;
        }
        if (!sessionBean.isSetTransactionType()) {
            return false;
        }
        if (sessionBean.getTransactionType() == null) {
            return false;
        }
        if (sessionBean.getTransactionType().getValue() == 0) {
            return true;
        }
        return sessionBean.getTransactionType().getValue() == 1;
    }

    public static final void isValidType(JavaHelpers type) throws InvalidInputException {
        if (type == null) {
            Logger aLogger = ValidationRuleUtility.getMsgLogger();
            if (aLogger.isLoggingLevel(Level.FINEST)) {
                LogEntry entry = ValidationRuleUtility.getLogEntry();
                entry.setSourceID("ValidationRuleUtility.isValidType");
                entry.setText("type is null");
                entry.appendStackTrace();
                aLogger.write(Level.FINEST, (Object)entry);
            }
            throw new InvalidInputException();
        }
        if (type.getWrapper() != null) {
            JavaClass wrapper = type.getWrapper();
            if (type.isArray()) {
                ArrayType array = (ArrayType)type;
                ValidationRuleUtility.isValidType(array.getFinalComponentType());
            } else if (!wrapper.isExistingType()) {
                Logger aLogger = ValidationRuleUtility.getMsgLogger();
                if (aLogger.isLoggingLevel(Level.FINEST)) {
                    LogEntry entry = ValidationRuleUtility.getLogEntry();
                    entry.setSourceID("ValidationRuleUtility.isValidType");
                    entry.setText("!wrapper.isExistingType(); type is " + wrapper.getJavaName());
                    aLogger.write(Level.FINEST, (Object)entry);
                }
                throw new InvalidInputException(wrapper);
            }
        }
    }

    public static final void isValidTypeHierarchy(EnterpriseBean bean, JavaHelpers type) throws InvalidInputException {
        EList superInterfaces;
        if (type == null) {
            Logger aLogger = ValidationRuleUtility.getMsgLogger();
            if (aLogger.isLoggingLevel(Level.FINEST)) {
                LogEntry entry = ValidationRuleUtility.getLogEntry();
                entry.setSourceID("ValidationRuleUtility.isValidTypeHierarchy");
                entry.setText("type is null");
                entry.appendStackTrace();
                aLogger.write(Level.FINEST, (Object)entry);
            }
            throw new InvalidInputException();
        }
        ValidationRuleUtility.isValidType(type);
        JavaHelpers javaLangObject = ValidationRuleUtility.getType("java.lang.Object", bean);
        if (ValidationRuleUtility.isSameType(type, javaLangObject)) {
            return;
        }
        JavaClass classType = type.getWrapper();
        if (classType == null) {
            Logger aLogger = ValidationRuleUtility.getMsgLogger();
            if (aLogger.isLoggingLevel(Level.FINEST)) {
                LogEntry entry = ValidationRuleUtility.getLogEntry();
                entry.setSourceID("ValidationRuleUtility.isValidTypeHierarchy");
                entry.setText("type.getWrapper() returns null; type is " + type.getJavaName());
                aLogger.write(Level.FINEST, (Object)entry);
            }
            throw new InvalidInputException();
        }
        if (!classType.isInterface()) {
            JavaClass superType = classType.getSupertype();
            ValidationRuleUtility.isValidTypeHierarchy(bean, (JavaHelpers)superType);
        }
        if ((superInterfaces = classType.getImplementsInterfaces()) != null) {
            Iterator iterator = superInterfaces.iterator();
            while (iterator.hasNext()) {
                JavaClass superIntf = (JavaClass)iterator.next();
                ValidationRuleUtility.isValidTypeHierarchy(bean, (JavaHelpers)superIntf);
            }
        }
    }

    public static final boolean throwsRemoteExceptionOrParent(EnterpriseBean bean, Method method) throws InvalidInputException {
        return ValidationRuleUtility.throwsExceptionOrParent(bean, method, "java.rmi.RemoteException");
    }

    public static final boolean doesNotThrowRemoteException(EnterpriseBean bean, Method method) throws InvalidInputException {
        return !ValidationRuleUtility.throwsException(bean, method, "java.rmi.RemoteException");
    }

    public static final boolean throwsObjectNotFoundException(EnterpriseBean bean, Method method) throws InvalidInputException {
        return ValidationRuleUtility.throwsException(bean, method, "javax.ejb.ObjectNotFoundException");
    }

    public static final boolean throwsFinderException(EnterpriseBean bean, Method method) throws InvalidInputException {
        return ValidationRuleUtility.throwsException(bean, method, "javax.ejb.FinderException");
    }

    public static final boolean throwsCreateException(EnterpriseBean bean, Method method) throws InvalidInputException {
        return ValidationRuleUtility.throwsException(bean, method, "javax.ejb.CreateException");
    }

    public static final boolean throwsApplicationException(Method method, EnterpriseBean bean) {
        EList exceptions = method.getJavaExceptions();
        if (exceptions.size() == 0) {
            return false;
        }
        Iterator iterator = exceptions.iterator();
        while (iterator.hasNext()) {
            JavaClass exception = (JavaClass)iterator.next();
            if (!ValidationRuleUtility.isApplicationException(exception, bean)) continue;
            return true;
        }
        return false;
    }

    public static final boolean throwsException(EnterpriseBean bean, Method method, String exceptionName) throws InvalidInputException {
        if (method == null) {
            return false;
        }
        EList exceptions = method.getJavaExceptions();
        Iterator iterator = exceptions.iterator();
        JavaClass exception = ValidationRuleUtility.getType(exceptionName, bean).getWrapper();
        while (iterator.hasNext()) {
            JavaClass exc = (JavaClass)iterator.next();
            if (!ValidationRuleUtility.isAssignableFrom((JavaHelpers)exc, (JavaHelpers)exception)) continue;
            return true;
        }
        return false;
    }

    public static final boolean throwsExceptionOrParent(EnterpriseBean bean, Method method, String exceptionName) throws InvalidInputException {
        if (method == null) {
            return false;
        }
        JavaClass exception = ValidationRuleUtility.getType(exceptionName, bean).getWrapper();
        EList exceptions = method.getJavaExceptions();
        Iterator iterator = exceptions.iterator();
        while (iterator.hasNext()) {
            JavaClass exc = (JavaClass)iterator.next();
            if (ValidationRuleUtility.isAssignableFrom((JavaHelpers)exc, (JavaHelpers)exception)) {
                return true;
            }
            if (!ValidationRuleUtility.isAssignableFrom((JavaHelpers)exception, (JavaHelpers)exc)) continue;
            return true;
        }
        return false;
    }

    public static final boolean usesCollectionClass(EnterpriseBean bean, Method method) {
        if (bean == null || method == null) {
            return false;
        }
        JavaParameter[] parms = method.listParametersWithoutReturn();
        if (parms != null) {
            int i = 0;
            while (i < parms.length) {
                JavaParameter parm = parms[i];
                try {
                    if (ValidationRuleUtility.isAssignableFromCollection(parm.getJavaType(), bean)) {
                        return true;
                    }
                }
                catch (InvalidInputException invalidInputException) {}
                ++i;
            }
        }
        try {
            if (ValidationRuleUtility.isAssignableFromCollection(method.getReturnType(), bean)) {
                return true;
            }
        }
        catch (InvalidInputException invalidInputException) {}
        return false;
    }

    public static final boolean usesLocalTypes(EnterpriseBean bean, Method method) {
        if (bean == null || method == null) {
            return false;
        }
        JavaParameter[] parms = method.listParametersWithoutReturn();
        if (parms != null) {
            int i = 0;
            while (i < parms.length) {
                JavaParameter parm = parms[i];
                if (ValidationRuleUtility.isLocalType(bean, parm.getJavaType())) {
                    return true;
                }
                ++i;
            }
        }
        return ValidationRuleUtility.isLocalType(bean, method.getReturnType());
    }
}

