/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import org.eclipse.wst.xsd.ui.internal.XSDEditor;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.XSDMenuListener;
import org.eclipse.wst.xsd.ui.internal.XSDSelectionManager;
import org.eclipse.wst.xsd.ui.internal.actions.OpenSchemaAction;
import org.eclipse.wst.xsd.ui.internal.provider.CategoryAdapter;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaDirective;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSDContentOutlinePage
extends ContentOutlinePage
implements ISelectionListener {
    protected XSDEditor xsdEditor;
    protected int level = 0;
    protected Object model;
    protected ITreeContentProvider contentProvider;
    protected ILabelProvider labelProvider;
    protected XSDSelectionManager selectionManager;
    protected SelectionManagerSelectionChangeListener selectionManagerSelectionChangeListener = new SelectionManagerSelectionChangeListener();
    protected TreeSelectionChangeListener treeSelectionChangeListener = new TreeSelectionChangeListener();
    XSDEditor xsdTextEditor;
    XSDMenuListener menuListener;
    SelectionProvider fSelectionProvider = null;
    FilterAction referenceAction;
    FilterAction inheritedAction;
    private Sorter sorter = new Sorter();

    public XSDContentOutlinePage(XSDEditor xsdTextEditor) {
        this.xsdTextEditor = xsdTextEditor;
        this.fSelectionProvider = new SelectionProvider();
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        this.getSite().getWorkbenchWindow().getSelectionService().addPostSelectionListener((ISelectionListener)this);
        this.getSite().setSelectionProvider((ISelectionProvider)this.fSelectionProvider);
    }

    public void dispose() {
        super.dispose();
        this.getSite().getWorkbenchWindow().getSelectionService().removePostSelectionListener((ISelectionListener)this);
    }

    public void setModel(Object newModel) {
        this.model = newModel;
    }

    public void setContentProvider(ITreeContentProvider contentProvider) {
        this.contentProvider = contentProvider;
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public TreeViewer getTreeViewer() {
        return super.getTreeViewer();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.getTreeViewer().setContentProvider((IContentProvider)this.contentProvider);
        this.getTreeViewer().setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.getTreeViewer().setInput(this.model);
        MenuManager menuManager = new MenuManager("#popup");
        menuManager.setRemoveAllWhenShown(true);
        Menu menu = menuManager.createContextMenu(this.getTreeViewer().getControl());
        this.getTreeViewer().getControl().setMenu(menu);
        this.menuListener = new XSDMenuListener(this.xsdTextEditor.getSelectionManager());
        menuManager.addMenuListener((IMenuListener)this.menuListener);
        this.getSite().registerContextMenu("org.eclipse.wst.xsd.ui.popup.outline", menuManager, (ISelectionProvider)this.xsdTextEditor.getSelectionManager());
        this.setSelectionManager(this.xsdTextEditor.getSelectionManager());
        XSDKeyListener keyListener = new XSDKeyListener(this.getTreeViewer(), this.menuListener);
        this.getTreeViewer().getControl().addKeyListener((KeyListener)keyListener);
        this.getTreeViewer().getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                XSDConcreteComponent comp;
                StructuredSelection selection;
                Object obj;
                ISelection iSelection = XSDContentOutlinePage.this.getTreeViewer().getSelection();
                if (iSelection instanceof StructuredSelection && (obj = (selection = (StructuredSelection)iSelection).getFirstElement()) instanceof XSDConcreteComponent && (comp = (XSDConcreteComponent)obj).getContainer() instanceof XSDSchema) {
                    XSDContentOutlinePage.this.xsdTextEditor.getGraphViewer().setInput(obj);
                }
            }
        });
        this.getTreeViewer().addPostSelectionChangedListener(this.fSelectionProvider.getPostSelectionChangedListener());
        this.getTreeViewer().addSelectionChangedListener(this.fSelectionProvider.getSelectionChangedListener());
    }

    public void setExpandToLevel(int i) {
        this.level = i;
    }

    public void setInput(Object value) {
        this.getTreeViewer().setInput(value);
        this.getTreeViewer().expandToLevel(this.level);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (this.selectionManager != null && selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            Object o = structuredSelection.getFirstElement();
            if (o instanceof Element) {
                try {
                    XSDConcreteComponent modelObject = this.xsdTextEditor.getXSDSchema().getCorrespondingComponent((Node)((Element)o));
                    if (modelObject != null) {
                        o = modelObject;
                    }
                }
                catch (Exception exception) {}
            } else {
                boolean cfr_ignored_0 = o instanceof CategoryAdapter;
            }
            if (o != null) {
                if (this.getControl() != null && !this.getControl().isDisposed() && !this.getControl().isFocusControl() && this.getControl().isVisible()) {
                    this.getTreeViewer().setSelection((ISelection)new StructuredSelection(o), true);
                }
                this.selectionManager.setSelection((ISelection)new StructuredSelection(o), (ISelectionProvider)this.getTreeViewer());
            }
        }
    }

    public void setSelectionManager(XSDSelectionManager newSelectionManager) {
        TreeViewer treeViewer = this.getTreeViewer();
        if (this.selectionManager != null) {
            this.selectionManager.removeSelectionChangedListener(this.selectionManagerSelectionChangeListener);
            treeViewer.removeSelectionChangedListener((ISelectionChangedListener)this.treeSelectionChangeListener);
        }
        this.selectionManager = newSelectionManager;
        if (this.selectionManager != null) {
            this.selectionManager.addSelectionChangedListener(this.selectionManagerSelectionChangeListener);
            treeViewer.addSelectionChangedListener((ISelectionChangedListener)this.treeSelectionChangeListener);
        }
    }

    public void setActionBars(IActionBars actionBars) {
        super.setActionBars(actionBars);
        this.referenceAction = new FilterAction(new ReferenceFilter("Reference Content"), XSDEditorPlugin.getXSDString("_UI_OUTLINE_SHOW_REFERENCES"), ImageDescriptor.createFromFile(((Object)((Object)XSDEditorPlugin.getPlugin())).getClass(), (String)"icons/XSDElementRef.gif"));
        boolean initialRef = this.xsdTextEditor.getXSDModelAdapterFactory().getShowReferences();
        this.referenceAction.setChecked(initialRef);
        this.inheritedAction = new FilterAction(new ReferenceFilter("Inherited Content"), XSDEditorPlugin.getXSDString("_UI_OUTLINE_SHOW_INHERITED"), ImageDescriptor.createFromFile(((Object)((Object)XSDEditorPlugin.getPlugin())).getClass(), (String)"icons/XSDComplexContent.gif"));
        IMenuManager menu = actionBars.getMenuManager();
        menu.add((IAction)this.referenceAction);
        menu.add((IAction)this.inheritedAction);
    }

    private void updateActions(Action current) {
        if (this.referenceAction.isChecked()) {
            this.xsdTextEditor.getXSDModelAdapterFactory().setShowReferences(true);
        } else {
            this.xsdTextEditor.getXSDModelAdapterFactory().setShowReferences(false);
        }
        if (this.inheritedAction.isChecked()) {
            this.xsdTextEditor.getXSDModelAdapterFactory().setShowInherited(true);
        } else {
            this.xsdTextEditor.getXSDModelAdapterFactory().setShowInherited(false);
        }
    }

    class XSDKeyListener
    extends KeyAdapter {
        TreeViewer viewer;
        XSDMenuListener menuListener;

        public XSDKeyListener(TreeViewer viewer, XSDMenuListener menuListener) {
            this.viewer = viewer;
            this.menuListener = menuListener;
        }

        public void keyReleased(KeyEvent e) {
            Tree tree;
            TreeItem[] selection;
            if (e.character == '\u007f') {
                this.menuListener.getDeleteAction().run();
            } else if (e.keyCode == 0x100000C && e.widget instanceof Tree && (selection = (tree = (Tree)e.widget).getSelection()).length > 0 && selection[0].getData() instanceof XSDSchemaDirective) {
                XSDSchemaDirective comp = (XSDSchemaDirective)selection[0].getData();
                OpenSchemaAction openSchema = new OpenSchemaAction(XSDEditorPlugin.getXSDString("_UI_ACTION_OPEN_SCHEMA"), (XSDConcreteComponent)comp);
                openSchema.run();
            }
        }
    }

    class SelectionManagerSelectionChangeListener
    implements ISelectionChangedListener {
        SelectionManagerSelectionChangeListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (event.getSelectionProvider() != XSDContentOutlinePage.this.getTreeViewer()) {
                XSDContentOutlinePage.this.getTreeViewer().setSelection(event.getSelection(), true);
            }
        }
    }

    class TreeSelectionChangeListener
    implements ISelectionChangedListener {
        TreeSelectionChangeListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection;
            if (XSDContentOutlinePage.this.selectionManager != null && (selection = event.getSelection()) instanceof IStructuredSelection) {
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                Object o = structuredSelection.getFirstElement();
                if (o instanceof Element) {
                    try {
                        XSDConcreteComponent modelObject = XSDContentOutlinePage.this.xsdTextEditor.getXSDSchema().getCorrespondingComponent((Node)((Element)o));
                        if (modelObject != null) {
                            o = modelObject;
                        }
                    }
                    catch (Exception exception) {}
                } else {
                    boolean cfr_ignored_0 = o instanceof CategoryAdapter;
                }
                if (o != null) {
                    XSDContentOutlinePage.this.selectionManager.setSelection((ISelection)new StructuredSelection(o), (ISelectionProvider)XSDContentOutlinePage.this.getTreeViewer());
                }
            }
        }
    }

    public class Sorter
    extends ViewerSorter {
    }

    public class SortAction
    extends Action {
        public SortAction() {
            super("Sort", ImageDescriptor.createFromFile(((Object)((Object)XSDEditorPlugin.getPlugin())).getClass(), (String)"icons/sort.gif"));
        }

        public void run() {
            XSDContentOutlinePage.this.getTreeViewer().getControl().setVisible(false);
            Object[] expandedElements = XSDContentOutlinePage.this.getTreeViewer().getExpandedElements();
            XSDContentOutlinePage.this.getTreeViewer().setSorter(this.isChecked() ? XSDContentOutlinePage.this.sorter : null);
            Object input = XSDContentOutlinePage.this.getTreeViewer().getInput();
            XSDContentOutlinePage.this.getTreeViewer().setInput(input);
            XSDContentOutlinePage.this.getTreeViewer().setExpandedElements(expandedElements);
            XSDContentOutlinePage.this.getTreeViewer().getControl().setVisible(true);
        }

        public void setChecked(boolean checked) {
            super.setChecked(checked);
            this.setToolTipText(checked ? XSDEditorPlugin.getXSDString("_UI_OUTLINE_DO_NOT_SORT") : XSDEditorPlugin.getXSDString("_UI_OUTLINE_SORT"));
        }
    }

    public class FilterAction
    extends Action {
        ViewerFilter filter;

        public FilterAction(ViewerFilter filter, String label, ImageDescriptor image) {
            super(label, image);
            this.filter = filter;
            this.setChecked(false);
        }

        public void run() {
            XSDContentOutlinePage.this.updateActions(this);
            if (this.isChecked()) {
                XSDContentOutlinePage.this.getTreeViewer().resetFilters();
                XSDContentOutlinePage.this.getTreeViewer().addFilter(this.filter);
            } else {
                XSDContentOutlinePage.this.getTreeViewer().removeFilter(this.filter);
            }
        }
    }

    class ReferenceFilter
    extends ViewerFilter {
        protected String elementTag;

        public ReferenceFilter(String elementTag) {
            this.elementTag = elementTag;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            return true;
        }
    }

    private class SelectionProvider
    implements IPostSelectionProvider {
        private boolean isFiringSelection = false;
        private ListenerList listeners = new ListenerList();
        private ListenerList postListeners = new ListenerList();
        private ISelectionChangedListener postSelectionChangedListener = new PostSelectionChangedListener();
        private ISelectionChangedListener selectionChangedListener = new SelectionChangedListener();

        private SelectionProvider() {
        }

        public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
            this.postListeners.add((Object)listener);
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.listeners.add((Object)listener);
        }

        public void fireSelectionChanged(SelectionChangedEvent event, ListenerList listenerList) {
            this.isFiringSelection = true;
            Object[] listeners = listenerList.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ISelectionChangedListener l = (ISelectionChangedListener)listeners[i];
                Platform.run((ISafeRunnable)new SafeRunnable(this, l, event){
                    final /* synthetic */ SelectionProvider this$1;
                    private final /* synthetic */ ISelectionChangedListener val$l;
                    private final /* synthetic */ SelectionChangedEvent val$event;
                    {
                        this.this$1 = selectionProvider;
                        this.val$l = iSelectionChangedListener;
                        this.val$event = selectionChangedEvent;
                    }

                    public void run() {
                        this.val$l.selectionChanged(this.val$event);
                    }
                });
                ++i;
            }
            this.isFiringSelection = false;
        }

        public void fireSelectionChanged(SelectionChangedEvent event) {
            this.isFiringSelection = true;
            Object[] listeners = this.postListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ISelectionChangedListener l = (ISelectionChangedListener)listeners[i];
                Platform.run((ISafeRunnable)new SafeRunnable(this, l, event){
                    final /* synthetic */ SelectionProvider this$1;
                    private final /* synthetic */ ISelectionChangedListener val$l;
                    private final /* synthetic */ SelectionChangedEvent val$event;
                    {
                        this.this$1 = selectionProvider;
                        this.val$l = iSelectionChangedListener;
                        this.val$event = selectionChangedEvent;
                    }

                    public void run() {
                        this.val$l.selectionChanged(this.val$event);
                    }
                });
                ++i;
            }
            this.isFiringSelection = false;
        }

        public ISelectionChangedListener getPostSelectionChangedListener() {
            return this.postSelectionChangedListener;
        }

        public ISelection getSelection() {
            if (XSDContentOutlinePage.this.getTreeViewer() != null) {
                return XSDContentOutlinePage.this.getTreeViewer().getSelection();
            }
            return StructuredSelection.EMPTY;
        }

        public ISelectionChangedListener getSelectionChangedListener() {
            return this.selectionChangedListener;
        }

        public boolean isFiringSelection() {
            return this.isFiringSelection;
        }

        public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
            this.postListeners.remove((Object)listener);
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.listeners.remove((Object)listener);
        }

        public void setSelection(ISelection selection) {
            if (this.isFiringSelection) {
                XSDContentOutlinePage.this.getTreeViewer().setSelection(selection);
            }
        }

        private class PostSelectionChangedListener
        implements ISelectionChangedListener {
            private PostSelectionChangedListener() {
            }

            public void selectionChanged(SelectionChangedEvent event) {
                if (!SelectionProvider.this.isFiringSelection()) {
                    SelectionProvider.this.fireSelectionChanged(event, SelectionProvider.this.postListeners);
                }
            }
        }

        private class SelectionChangedListener
        implements ISelectionChangedListener {
            private SelectionChangedListener() {
            }

            public void selectionChanged(SelectionChangedEvent event) {
                if (!SelectionProvider.this.isFiringSelection()) {
                    SelectionProvider.this.fireSelectionChanged(event, SelectionProvider.this.listeners);
                }
            }
        }
    }
}

