/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.graph.editparts;

import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.graph.XSDChildUtility;
import org.eclipse.wst.xsd.ui.internal.graph.XSDGraphUtil;
import org.eclipse.wst.xsd.ui.internal.graph.editparts.ElementDeclarationEditPart;
import org.eclipse.wst.xsd.ui.internal.graph.editparts.ExpandableGraphNodeEditPart;
import org.eclipse.wst.xsd.ui.internal.graph.editparts.ModelGroupDefinitionEditPart;
import org.eclipse.wst.xsd.ui.internal.graph.editpolicies.DragAndDropEditPolicy;
import org.eclipse.wst.xsd.ui.internal.graph.figures.CenteredIconFigure;
import org.eclipse.wst.xsd.ui.internal.graph.figures.ContainerFigure;
import org.eclipse.wst.xsd.ui.internal.graph.figures.ExpandableGraphNodeFigure;
import org.eclipse.wst.xsd.ui.internal.graph.figures.GraphNodeFigure;
import org.eclipse.wst.xsd.ui.internal.graph.figures.RoundedLineBorder;
import org.eclipse.wst.xsd.ui.internal.graph.model.XSDModelAdapterFactory;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;

public class ModelGroupEditPart
extends ExpandableGraphNodeEditPart {
    protected CenteredIconFigure centeredIconFigure;
    protected static Color editableBackgroundColor = null;
    protected static Color editableForegroundColor = null;
    protected static Color nonEditableForegroundColor = null;

    public XSDParticle getXSDParticle() {
        XSDConcreteComponent o = this.getXSDModelGroup().getContainer();
        return o instanceof XSDParticle ? (XSDParticle)o : null;
    }

    public XSDModelGroup getXSDModelGroup() {
        return (XSDModelGroup)this.getModel();
    }

    protected GraphNodeFigure createGraphNodeFigure() {
        ExpandableGraphNodeFigure figure = new ExpandableGraphNodeFigure();
        this.centeredIconFigure = new CenteredIconFigure();
        this.centeredIconFigure.setPreferredSize(new Dimension(32, 20));
        figure.getIconArea().add((IFigure)this.centeredIconFigure);
        ContainerFigure outlinedArea = figure.getOutlinedArea();
        outlinedArea.setBorder((Border)new RoundedLineBorder(1, 10));
        figure.getOuterContentArea().getContainerLayout().setHorizontal(false);
        figure.getOuterContentArea().getContainerLayout().setSpacing(10);
        return figure;
    }

    protected List getModelChildrenHelper() {
        return XSDChildUtility.getModelChildren(this.getXSDModelGroup());
    }

    protected void refreshVisuals() {
        String iconName = "icons/XSDSequence.gif";
        switch (this.getXSDModelGroup().getCompositor().getValue()) {
            case 0: {
                iconName = "icons/XSDAll.gif";
                break;
            }
            case 1: {
                iconName = "icons/XSDChoice.gif";
                break;
            }
            case 2: {
                iconName = "icons/XSDSequence.gif";
            }
        }
        this.centeredIconFigure.image = XSDEditorPlugin.getXSDImage(iconName);
        this.centeredIconFigure.repaint();
        ContainerFigure outlinedArea = this.graphNodeFigure.getOutlinedArea();
        if (XSDGraphUtil.isEditable(this.getXSDModelGroup())) {
            if (editableForegroundColor == null) {
                editableForegroundColor = new Color((Device)Display.getCurrent(), 120, 152, 184);
            }
            if (editableBackgroundColor == null) {
                editableBackgroundColor = new Color((Device)Display.getCurrent(), 232, 240, 248);
            }
            outlinedArea.setForegroundColor(this.isSelected ? ColorConstants.black : editableForegroundColor);
            outlinedArea.setBackgroundColor(editableBackgroundColor);
        } else {
            if (nonEditableForegroundColor == null) {
                nonEditableForegroundColor = new Color((Device)Display.getCurrent(), 164, 164, 164);
            }
            outlinedArea.setForegroundColor(this.isSelected ? ColorConstants.black : nonEditableForegroundColor);
            outlinedArea.setBackgroundColor(ColorConstants.white);
        }
        this.refreshOccurenceLabel(this.getXSDParticle());
    }

    protected boolean isChildLayoutHorizontal() {
        return false;
    }

    protected boolean isDefaultExpanded() {
        return !this.isPossibleCycle();
    }

    protected boolean isPossibleCycle() {
        boolean result = false;
        if (this.getParent() instanceof ModelGroupDefinitionEditPart) {
            ModelGroupDefinitionEditPart group = (ModelGroupDefinitionEditPart)this.getParent();
            EditPart parent = group.getParent();
            while (parent != null) {
                if (parent.getModel() instanceof ElementDeclarationEditPart) break;
                if (parent.getModel() == group.getModel()) {
                    result = true;
                    break;
                }
                parent = parent.getParent();
            }
        }
        return result;
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("PrimaryDrag Policy", (EditPolicy)new DragAndDropEditPolicy(this.getViewer(), this.selectionHandlesEditPolicy));
    }

    public void activate() {
        super.activate();
        if (this.getXSDParticle() != null) {
            XSDModelAdapterFactory.addModelAdapterListener(this.getXSDParticle(), this);
        }
    }

    public void deactivate() {
        if (this.getXSDParticle() != null) {
            XSDModelAdapterFactory.removeModelAdapterListener(this.getXSDParticle(), this);
        }
        super.deactivate();
    }
}

