/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.properties;

import java.util.ArrayList;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.properties.AnyContentPropertyDescriptor;
import org.eclipse.wst.xsd.ui.internal.properties.BasePropertySource;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class DocumentationPropertySource
extends BasePropertySource
implements IPropertySource {
    public static String CONTENT = "Content";

    public DocumentationPropertySource() {
    }

    public DocumentationPropertySource(Viewer viewer, XSDSchema xsdSchema) {
        super(viewer, xsdSchema);
    }

    public DocumentationPropertySource(XSDSchema xsdSchema) {
        super(xsdSchema);
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<Object> list = new ArrayList<Object>();
        TextPropertyDescriptor languageDescriptor = new TextPropertyDescriptor((Object)"xml:lang", "xml:lang");
        list.add(languageDescriptor);
        TextPropertyDescriptor sourceDescriptor = new TextPropertyDescriptor((Object)"source", "source");
        list.add(sourceDescriptor);
        AnyContentPropertyDescriptor contentDescriptor = new AnyContentPropertyDescriptor(CONTENT, CONTENT, this.element);
        list.add((Object)contentDescriptor);
        IPropertyDescriptor[] result = new IPropertyDescriptor[list.size()];
        list.toArray(result);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getPropertyValue(Object id) {
        String result = null;
        if (id instanceof String) {
            if (((String)id).equals(CONTENT)) {
                try {
                    if (!this.element.hasChildNodes()) {
                        return "";
                    }
                    Node node = this.element.getFirstChild();
                    if (node instanceof CharacterData) {
                        return ((CharacterData)node).getData();
                    }
                }
                catch (Exception exception) {}
            } else {
                result = this.element.getAttribute((String)id);
            }
        }
        if (result != null) return result;
        return "";
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
        if (value != null) {
            if (value instanceof String) {
                String newValue = (String)value;
                if (((String)id).equals("xml:lang")) {
                    this.beginRecording(XSDEditorPlugin.getXSDString("_UI_DOCUMENTATION_LANG_CHANGE"), this.element);
                    if (newValue.length() > 0) {
                        if (this.validateLanguage(newValue)) {
                            this.element.setAttribute("xml:lang", newValue);
                        }
                    } else {
                        this.element.removeAttribute("xml:lang");
                    }
                    this.endRecording(this.element);
                } else if (((String)id).equals("source")) {
                    this.beginRecording(XSDEditorPlugin.getXSDString("_UI_DOCUMENTATION_SOURCE_CHANGE"), this.element);
                    if (newValue.length() > 0) {
                        this.element.setAttribute("source", newValue);
                    } else {
                        this.element.removeAttribute("source");
                    }
                    this.endRecording(this.element);
                } else if (((String)id).equals(CONTENT)) {
                    this.beginRecording(XSDEditorPlugin.getXSDString("_UI_DOCUMENTATION_COMMENT_CHANGE"), this.element);
                    try {
                        if (this.element.hasChildNodes()) {
                            Node node = this.element.getFirstChild();
                            if (node instanceof CharacterData) {
                                ((CharacterData)node).setData(newValue);
                            }
                        } else if (newValue.length() > 0) {
                            Text childNode = this.element.getOwnerDocument().createTextNode(newValue);
                            this.element.appendChild(childNode);
                        }
                        this.endRecording(this.element);
                    }
                    catch (Exception exception) {}
                } else {
                    this.element.setAttribute((String)id, newValue);
                }
            } else {
                boolean cfr_ignored_0 = value instanceof Integer;
            }
        } else {
            this.element.removeAttribute((String)id);
        }
        Runnable delayedUpdate = new Runnable(){

            public void run() {
                if (DocumentationPropertySource.this.viewer != null) {
                    DocumentationPropertySource.this.viewer.refresh();
                }
            }
        };
        Display.getCurrent().asyncExec(delayedUpdate);
    }
}

