/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.properties.section;

import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.wst.common.ui.properties.internal.provisional.ISection;
import org.eclipse.wst.common.ui.properties.internal.provisional.TabbedPropertySheetPage;
import org.eclipse.wst.common.ui.properties.internal.provisional.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.xml.core.internal.document.DocumentImpl;
import org.eclipse.wst.xml.core.internal.provisional.NameValidator;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.actions.CreateElementAction;
import org.eclipse.wst.xsd.ui.internal.util.XSDDOMHelper;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AbstractSection
implements ISection,
IPropertyChangeListener,
Listener,
SelectionListener {
    private TabbedPropertySheetWidgetFactory factory;
    protected IWorkbenchPart part;
    protected ISelection selection;
    protected Object input;
    protected boolean doRefresh = true;
    XSDSchema xsdSchema;
    protected boolean isReadOnly = false;
    private IStatusLineManager statusLine;
    protected Composite composite;
    protected int rightMarginSpace;
    protected int tableMinimumWidth = 50;
    boolean listenerEnabled = true;
    protected DelayedEvent delayedTask;
    boolean isInDoHandle;
    protected XSDDOMHelper domHelper = new XSDDOMHelper();
    EditorActionBarContributor contributor;

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        this.createControls(parent, tabbedPropertySheetPage.getWidgetFactory());
    }

    public void createControls(Composite parent, TabbedPropertySheetWidgetFactory aFactory) {
        this.factory = aFactory;
        GC gc = new GC((Drawable)parent);
        Point extent = gc.textExtent("  ...  ");
        this.rightMarginSpace = extent.x;
        gc.dispose();
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        Object input;
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        this.part = part;
        this.selection = selection;
        this.input = input = ((IStructuredSelection)selection).getFirstElement();
        if (input instanceof XSDConcreteComponent) {
            this.xsdSchema = ((XSDConcreteComponent)input).getSchema();
            Element element = ((XSDConcreteComponent)input).getElement();
            this.isReadOnly = !(element instanceof IDOMNode);
        }
        this.statusLine = this.getStatusLine();
        this.clearErrorMessage();
    }

    public void aboutToBeShown() {
    }

    public void aboutToBeHidden() {
    }

    public void dispose() {
    }

    public int getMinimumHeight() {
        return -1;
    }

    public boolean shouldUseExtraSpace() {
        return false;
    }

    public void refresh() {
    }

    public Object getInput() {
        if (this.input instanceof Element) {
            this.input = this.xsdSchema.getCorrespondingComponent((Node)((Element)this.input));
        }
        return this.input;
    }

    public XSDSchema getSchema() {
        return this.xsdSchema;
    }

    public TabbedPropertySheetWidgetFactory getWidgetFactory() {
        return this.factory;
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.refresh();
    }

    public void doWidgetDefaultSelected(SelectionEvent e) {
    }

    public void doWidgetSelected(SelectionEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        if (this.isListenerEnabled() && this.getInput() != null && !this.isInDoHandle && !this.isReadOnly) {
            this.isInDoHandle = true;
            this.doWidgetDefaultSelected(e);
            this.isInDoHandle = false;
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.isListenerEnabled() && this.getInput() != null && !this.isInDoHandle && !this.isReadOnly) {
            this.isInDoHandle = true;
            this.doWidgetSelected(e);
            this.isInDoHandle = false;
        }
    }

    public boolean isListenerEnabled() {
        return this.listenerEnabled;
    }

    public void setListenerEnabled(boolean v) {
        this.listenerEnabled = v;
    }

    public void handleEvent(Event event) {
        if (this.isListenerEnabled() && !this.isInDoHandle && !this.isReadOnly) {
            this.isInDoHandle = true;
            this.startDelayedEvent(event);
            this.isInDoHandle = false;
        }
    }

    public void doHandleEvent(Event event) {
    }

    protected void startDelayedEvent(Event e) {
        if (this.delayedTask == null || this.delayedTask.getEvent() == null) {
            this.delayedTask = new DelayedEvent();
            this.delayedTask.setEvent(e);
            Display.getDefault().timerExec(500, (Runnable)this.delayedTask);
        } else {
            Event delayedEvent = this.delayedTask.getEvent();
            if (e.widget == delayedEvent.widget && e.type == delayedEvent.type) {
                this.delayedTask.setEvent(null);
            }
            this.delayedTask = new DelayedEvent();
            this.delayedTask.setEvent(e);
            Display.getDefault().timerExec(500, (Runnable)this.delayedTask);
        }
    }

    public boolean isInDoHandle() {
        return this.isInDoHandle;
    }

    protected IEditorPart getActiveEditor() {
        IWorkbench workbench = XSDEditorPlugin.getPlugin().getWorkbench();
        IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
        IEditorPart editorPart = workbenchWindow.getActivePage().getActiveEditor();
        return editorPart;
    }

    protected static IStatusLineManager getStatusLineManager(IEditorPart editorPart) {
        IStatusLineManager result = null;
        try {
            EditorActionBarContributor contributor = (EditorActionBarContributor)editorPart.getEditorSite().getActionBarContributor();
            result = contributor.getActionBars().getStatusLineManager();
        }
        catch (Exception exception) {}
        return result;
    }

    public XSDDOMHelper getDomHelper() {
        return this.domHelper;
    }

    public DocumentImpl getDocument(Element element) {
        return (DocumentImpl)element.getOwnerDocument();
    }

    public void beginRecording(String description, Element element) {
        this.getDocument(element).getModel().beginRecording((Object)this, description);
    }

    public void endRecording(Element element) {
        DocumentImpl doc = this.getDocument(element);
        doc.getModel().endRecording((Object)this);
    }

    protected boolean validateName(String name) {
        try {
            return NameValidator.isValid((String)name);
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean validateLanguage(String lang) {
        return true;
    }

    protected boolean validatePrefix(String prefix) {
        return true;
    }

    protected Action getNewElementAction(String elementTag, String label, List attributes, Element parent, Node relativeNode) {
        CreateElementAction action = new CreateElementAction(label);
        action.setElementTag(elementTag);
        action.setAttributes(attributes);
        action.setParentNode(parent);
        action.setRelativeNode(relativeNode);
        action.setXSDSchema(this.getSchema());
        action.setSelectionProvider(null);
        return action;
    }

    public void setErrorMessage(String message) {
        if (this.statusLine != null) {
            this.statusLine.setErrorMessage(message);
            this.statusLine.update(true);
        }
    }

    public void clearErrorMessage() {
        if (this.statusLine != null) {
            this.statusLine.setErrorMessage(null);
            this.statusLine.update(false);
        }
    }

    protected IStatusLineManager getStatusLine() {
        IEditorPart editorPart = this.part.getSite().getWorkbenchWindow().getActivePage().getActiveEditor();
        if (this.statusLine == null) {
            try {
                this.contributor = (EditorActionBarContributor)editorPart.getEditorSite().getActionBarContributor();
                this.statusLine = this.contributor.getActionBars().getStatusLineManager();
            }
            catch (Exception exception) {}
        }
        return this.statusLine;
    }

    protected int getStandardLabelWidth(Composite parent, String[] labels) {
        int standardLabelWidth = 100;
        GC gc = new GC((Drawable)parent);
        int indent = gc.textExtent((String)"XXX").x;
        int i = 0;
        while (i < labels.length) {
            int width = gc.textExtent((String)labels[i]).x;
            if (width + indent > standardLabelWidth) {
                standardLabelWidth = width + indent;
            }
            ++i;
        }
        gc.dispose();
        return standardLabelWidth;
    }

    class DelayedEvent
    implements Runnable {
        protected Event event;

        DelayedEvent() {
        }

        public void run() {
            if (this.event != null) {
                AbstractSection.this.isInDoHandle = true;
                AbstractSection.this.doHandleEvent(this.event);
                AbstractSection.this.isInDoHandle = false;
                this.event = null;
            }
        }

        public Event getEvent() {
            return this.event;
        }

        public void setEvent(Event event) {
            this.event = event;
        }
    }
}

