/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.properties.section;

import org.eclipse.core.resources.IFile;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.wst.common.ui.properties.internal.provisional.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.actions.SetBaseTypeAction;
import org.eclipse.wst.xsd.ui.internal.dialogs.types.xml.XMLComponentSpecification;
import org.eclipse.wst.xsd.ui.internal.dialogs.types.xsd.XSDComponentSelectionDialog;
import org.eclipse.wst.xsd.ui.internal.dialogs.types.xsd.XSDComponentSelectionProvider;
import org.eclipse.wst.xsd.ui.internal.dialogs.types.xsd.XSDSetTypeHelper;
import org.eclipse.wst.xsd.ui.internal.properties.section.AbstractSection;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Element;

public class ComplexTypeSection
extends AbstractSection {
    private String[] derivedByChoicesComboValues = new String[]{"", "restriction", "extension"};
    Text baseTypeCombo;
    CCombo derivedByCombo;
    Button button;

    public void createControls(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        super.createControls(parent, factory);
        this.composite = this.getWidgetFactory().createFlatFormComposite(parent);
        String textBaseType = XSDEditorPlugin.getXSDString("_UI_LABEL_BASE_TYPE_WITH_COLON");
        String textDerivedType = XSDEditorPlugin.getXSDString("_UI_LABEL_DERIVED_BY");
        GC gc = new GC((Drawable)parent);
        int xoffset = Math.max(100, gc.textExtent((String)textBaseType).x + 20);
        xoffset = Math.max(xoffset, gc.textExtent((String)textDerivedType).x + 20);
        gc.dispose();
        this.baseTypeCombo = this.getWidgetFactory().createText(this.composite, "");
        CLabel baseTypeLabel = this.getWidgetFactory().createCLabel(this.composite, textBaseType);
        this.button = this.getWidgetFactory().createButton(this.composite, "", 8);
        this.button.setImage(XSDEditorPlugin.getXSDImage("icons/browsebutton.gif"));
        this.baseTypeCombo.setEditable(false);
        this.baseTypeCombo.addListener(24, (Listener)this);
        FormData data = new FormData();
        data.left = new FormAttachment(0, xoffset);
        data.right = new FormAttachment((Control)this.button, 0);
        this.baseTypeCombo.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.baseTypeCombo, -5);
        data.top = new FormAttachment((Control)this.button, 0, 0x1000000);
        baseTypeLabel.setLayoutData((Object)data);
        this.button.addSelectionListener((SelectionListener)this);
        data = new FormData();
        data.left = new FormAttachment(100, -this.rightMarginSpace + 2);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.baseTypeCombo, 0, 0x1000000);
        this.button.setLayoutData((Object)data);
        this.derivedByCombo = this.getWidgetFactory().createCCombo(this.composite, 0x800000);
        data = new FormData();
        data.left = new FormAttachment(0, xoffset);
        data.right = new FormAttachment(100, -this.rightMarginSpace - 5);
        data.top = new FormAttachment((Control)this.baseTypeCombo, 4);
        this.derivedByCombo.setLayoutData((Object)data);
        this.derivedByCombo.setItems(this.derivedByChoicesComboValues);
        this.derivedByCombo.addSelectionListener((SelectionListener)this);
        CLabel derivedByLabel = this.getWidgetFactory().createCLabel(this.composite, textDerivedType);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.derivedByCombo, -5);
        data.top = new FormAttachment((Control)this.derivedByCombo, 0, 0x1000000);
        derivedByLabel.setLayoutData((Object)data);
    }

    public void refresh() {
        this.setListenerEnabled(false);
        if (this.isReadOnly) {
            this.composite.setEnabled(false);
        } else {
            this.composite.setEnabled(true);
        }
        Object input = this.getInput();
        this.baseTypeCombo.setText("");
        if (input instanceof XSDComplexTypeDefinition) {
            XSDComplexTypeDefinition complexType = (XSDComplexTypeDefinition)input;
            Element element = complexType.getElement();
            Element contentModelElement = this.getDomHelper().getContentModelFromParent(element);
            String baseType = this.getDomHelper().getBaseType(contentModelElement);
            this.derivedByCombo.setText(this.getDomHelper().getDerivedByName(contentModelElement));
            if (baseType != null) {
                this.baseTypeCombo.setText(baseType);
            }
        }
        this.setListenerEnabled(true);
    }

    public void widgetSelected(SelectionEvent e) {
        XSDComplexTypeDefinition xsdComplexType = (XSDComplexTypeDefinition)this.getInput();
        Element ctElement = xsdComplexType.getElement();
        if (e.widget == this.button) {
            Shell shell = Display.getCurrent().getActiveShell();
            Element element = null;
            if (xsdComplexType.getContent() != null) {
                element = ((XSDComplexTypeDefinition)this.getInput()).getContent().getElement();
            }
            IFile currentIFile = ((IFileEditorInput)this.getActiveEditor().getEditorInput()).getFile();
            Object input = this.getInput();
            XSDSchema schema = null;
            if (input instanceof XSDConcreteComponent) {
                schema = ((XSDConcreteComponent)input).getSchema();
            }
            XSDComponentSelectionProvider provider = new XSDComponentSelectionProvider(currentIFile, schema);
            XSDComponentSelectionDialog dialog = new XSDComponentSelectionDialog(shell, XSDEditorPlugin.getXSDString("_UI_LABEL_SET_TYPE"), provider);
            provider.setDialog(dialog);
            dialog.setBlockOnOpen(true);
            dialog.create();
            int result = dialog.open();
            if (result == 0) {
                XMLComponentSpecification spec = dialog.getSelection();
                XSDSetTypeHelper helper = new XSDSetTypeHelper(currentIFile, schema);
                helper.addImportIfNecessary(element, spec);
                String typeString = helper.getPrefixedTypeName(spec);
                String derivedBy = this.getDomHelper().getDerivedByName(element);
                SetBaseTypeAction setBaseTypeAction = new SetBaseTypeAction(XSDEditorPlugin.getXSDString("_UI_LABEL_SET_BASE_TYPE"));
                setBaseTypeAction.setXSDSchema(this.xsdSchema);
                setBaseTypeAction.setComplexTypeElement(ctElement);
                setBaseTypeAction.setType(typeString);
                setBaseTypeAction.setDerivedBy(derivedBy);
                setBaseTypeAction.performAction();
            }
        } else if (e.widget == this.derivedByCombo) {
            Element contentModelElement = this.getDomHelper().getContentModelFromParent(ctElement);
            String baseType = this.getDomHelper().getBaseType(contentModelElement);
            this.beginRecording(XSDEditorPlugin.getXSDString("_UI_DERIVEDBY_CHANGE"), ctElement);
            if (contentModelElement != null) {
                this.getDomHelper().changeDerivedByType(contentModelElement, this.derivedByCombo.getText(), baseType);
            }
            this.endRecording(ctElement);
        }
    }

    public boolean shouldUseExtraSpace() {
        return false;
    }
}

