/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.refactor.rename;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.GlobalBuildAction;
import org.eclipse.wst.xsd.ui.internal.XSDEditorPlugin;
import org.eclipse.wst.xsd.ui.internal.refactor.RefactoringMessages;
import org.eclipse.wst.xsd.ui.internal.refactor.rename.RenameComponentProcessor;
import org.eclipse.wst.xsd.ui.internal.refactor.rename.RenameRefactoringWizard;
import org.eclipse.xsd.XSDNamedComponent;

public class RenameSupport {
    private RenameRefactoring fRefactoring;
    private RefactoringStatus fPreCheckStatus;

    public IStatus preCheck() throws CoreException {
        this.ensureChecked();
        if (this.fPreCheckStatus.hasFatalError()) {
            return RenameSupport.asStatus(this.fPreCheckStatus.getEntryMatchingSeverity(4));
        }
        return new Status(0, "org.eclipse.wst.xsd.ui", 0, "", null);
    }

    public void openDialog(Shell parent) throws CoreException {
        this.ensureChecked();
        if (this.fPreCheckStatus.hasFatalError()) {
            this.showInformation(parent, this.fPreCheckStatus);
            return;
        }
        try {
            RenameRefactoringWizard wizard = new RenameRefactoringWizard((Refactoring)this.fRefactoring, RefactoringMessages.getString("RenameComponentWizard.defaultPageTitle"), RefactoringMessages.getString("RenameComponentWizard.inputPage.description"), null);
            RefactoringWizardOpenOperation op = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
            int result = op.run(parent, wizard.getDefaultPageTitle());
            op.getInitialConditionCheckingStatus();
            if (result == 1 || result == 1025) {
                this.triggerBuild();
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    public void triggerBuild() {
        if (ResourcesPlugin.getWorkspace().getDescription().isAutoBuilding()) {
            new GlobalBuildAction(XSDEditorPlugin.getPlugin().getWorkbench().getActiveWorkbenchWindow(), 10).run();
        }
    }

    public void perform(Shell parent, IRunnableContext context) throws InterruptedException, InvocationTargetException {
        try {
            this.ensureChecked();
            if (this.fPreCheckStatus.hasFatalError()) {
                this.showInformation(parent, this.fPreCheckStatus);
                return;
            }
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
    }

    private RenameSupport(RenameComponentProcessor processor, String newName) throws CoreException {
        this.fRefactoring = new RenameRefactoring((RenameProcessor)processor);
    }

    public static RenameSupport create(XSDNamedComponent component, String newName) throws CoreException {
        RenameComponentProcessor processor = new RenameComponentProcessor(component, newName);
        return new RenameSupport(processor, newName);
    }

    private void ensureChecked() throws CoreException {
        if (this.fPreCheckStatus == null) {
            this.fPreCheckStatus = !this.fRefactoring.isApplicable() ? RefactoringStatus.createFatalErrorStatus((String)RefactoringMessages.getString("RenameSupport.not_available")) : new RefactoringStatus();
        }
    }

    private void showInformation(Shell parent, RefactoringStatus status) {
        String message = status.getMessageMatchingSeverity(4);
        MessageDialog.openInformation((Shell)parent, (String)RefactoringMessages.getString("RenameSupport.dialog.title"), (String)message);
    }

    private static IStatus asStatus(RefactoringStatusEntry entry) {
        int statusSeverity = 4;
        switch (entry.getSeverity()) {
            case 0: {
                statusSeverity = 0;
                break;
            }
            case 1: {
                statusSeverity = 1;
                break;
            }
            case 2: 
            case 3: {
                statusSeverity = 2;
            }
        }
        String pluginId = entry.getPluginId();
        int code = entry.getCode();
        if (pluginId == null) {
            pluginId = "org.eclipse.wst.xsd.ui";
            code = 4;
        }
        return new Status(statusSeverity, pluginId, code, entry.getMessage(), null);
    }
}

