/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.ITeamStatus;
import org.eclipse.team.core.synchronize.ISyncInfoSetChangeEvent;
import org.eclipse.team.core.synchronize.ISyncInfoSetChangeListener;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.core.synchronize.SyncInfoTree;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.SyncInfoSetSynchronizePage;
import org.eclipse.team.internal.ui.synchronize.SynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;
import org.eclipse.ui.forms.HyperlinkGroup;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.part.PageBook;

public class ChangesSection
extends Composite {
    private ISynchronizeParticipant participant;
    private SyncInfoSetSynchronizePage page;
    private FormToolkit forms;
    private PageBook changesSectionContainer;
    private Composite filteredContainer;
    private Viewer changesViewer;
    private boolean showingError;
    private SynchronizePageActionGroup changedListener = new SynchronizePageActionGroup(){

        public void modelChanged(ISynchronizeModelElement root) {
            ChangesSection.this.calculateDescription();
        }
    };
    private ISyncInfoSetChangeListener subscriberListener = new ISyncInfoSetChangeListener(){

        public void syncInfoSetReset(SyncInfoSet set, IProgressMonitor monitor) {
        }

        public void syncInfoChanged(ISyncInfoSetChangeEvent event, IProgressMonitor monitor) {
            ChangesSection.this.calculateDescription();
        }

        public void syncInfoSetErrors(SyncInfoSet set, ITeamStatus[] errors, IProgressMonitor monitor) {
        }
    };
    private ISyncInfoSetChangeListener outputSetListener = new ISyncInfoSetChangeListener(){

        public void syncInfoSetReset(SyncInfoSet set, IProgressMonitor monitor) {
            ChangesSection.this.calculateDescription();
        }

        public void syncInfoChanged(ISyncInfoSetChangeEvent event, IProgressMonitor monitor) {
        }

        public void syncInfoSetErrors(SyncInfoSet set, ITeamStatus[] errors, IProgressMonitor monitor) {
            ChangesSection.this.calculateDescription();
        }
    };
    private ISynchronizePageConfiguration configuration;

    public ChangesSection(Composite parent, SyncInfoSetSynchronizePage page, ISynchronizePageConfiguration configuration) {
        super(parent, 0);
        this.page = page;
        this.configuration = configuration;
        this.participant = configuration.getParticipant();
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.grabExcessVerticalSpace = true;
        this.setLayoutData(data);
        this.forms = new FormToolkit(parent.getDisplay());
        this.forms.setBackground(this.getBackgroundColor());
        HyperlinkGroup group = this.forms.getHyperlinkGroup();
        group.setBackground(this.getBackgroundColor());
        this.changesSectionContainer = new PageBook((Composite)this, 0);
        data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.changesSectionContainer.setLayoutData((Object)data);
    }

    public Composite getComposite() {
        return this.changesSectionContainer;
    }

    public void setViewer(Viewer viewer) {
        this.changesViewer = viewer;
        this.calculateDescription();
        this.configuration.addActionContribution(this.changedListener);
        this.getParticipantSyncInfoSet().addSyncSetChangedListener(this.subscriberListener);
        this.getVisibleSyncInfoSet().addSyncSetChangedListener(this.outputSetListener);
    }

    private void calculateDescription() {
        SyncInfoTree syncInfoTree = this.getVisibleSyncInfoSet();
        if (syncInfoTree.getErrors().length > 0) {
            if (!this.showingError) {
                TeamUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (ChangesSection.this.changesSectionContainer.isDisposed()) {
                            return;
                        }
                        if (ChangesSection.this.filteredContainer != null) {
                            ChangesSection.this.filteredContainer.dispose();
                            ChangesSection.this.filteredContainer = null;
                        }
                        ChangesSection.this.filteredContainer = ChangesSection.this.getErrorComposite((Composite)ChangesSection.this.changesSectionContainer);
                        ChangesSection.this.changesSectionContainer.showPage((Control)ChangesSection.this.filteredContainer);
                        ChangesSection.this.showingError = true;
                    }
                });
            }
            return;
        }
        this.showingError = false;
        if (syncInfoTree.size() == 0) {
            TeamUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (ChangesSection.this.changesSectionContainer.isDisposed()) {
                        return;
                    }
                    if (ChangesSection.this.filteredContainer != null) {
                        ChangesSection.this.filteredContainer.dispose();
                        ChangesSection.this.filteredContainer = null;
                    }
                    ChangesSection.this.filteredContainer = ChangesSection.this.getEmptyChangesComposite((Composite)ChangesSection.this.changesSectionContainer);
                    ChangesSection.this.changesSectionContainer.showPage((Control)ChangesSection.this.filteredContainer);
                }
            });
        } else {
            TeamUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (ChangesSection.this.filteredContainer != null) {
                        ChangesSection.this.filteredContainer.dispose();
                        ChangesSection.this.filteredContainer = null;
                    }
                    Control control = ChangesSection.this.changesViewer.getControl();
                    if (!ChangesSection.this.changesSectionContainer.isDisposed() && !control.isDisposed()) {
                        ChangesSection.this.changesSectionContainer.showPage(control);
                    }
                }
            });
        }
    }

    private boolean isThreeWay() {
        return "three-way".equals(this.configuration.getComparisonType());
    }

    private Composite getEmptyChangesComposite(Composite parent) {
        long numChanges;
        int currentMode;
        int candidateMode;
        Composite composite = new Composite(parent, 0);
        composite.setBackground(this.getBackgroundColor());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.grabExcessVerticalSpace = true;
        composite.setLayoutData((Object)data);
        if (!this.isThreeWay()) {
            this.createDescriptionLabel(composite, NLS.bind((String)TeamUIMessages.ChangesSection_noChanges, (Object[])new String[]{this.participant.getName()}));
            return composite;
        }
        SyncInfoSet participantSet = this.getParticipantSyncInfoSet();
        int allChanges = participantSet.size();
        int visibleChanges = this.getVisibleSyncInfoSet().size();
        if (visibleChanges == 0 && allChanges != 0 && (candidateMode = this.getCandidateMode(participantSet)) != (currentMode = this.page.getConfiguration().getMode()) && (numChanges = this.getChangesInMode(participantSet, candidateMode)) > 0L) {
            String message = numChanges > 1L ? NLS.bind((String)TeamUIMessages.ChangesSection_filterHidesPlural, (Object[])new String[]{Long.toString(numChanges), Utils.modeToString(candidateMode)}) : NLS.bind((String)TeamUIMessages.ChangesSection_filterHidesSingular, (Object[])new String[]{Long.toString(numChanges), Utils.modeToString(candidateMode)});
            message = NLS.bind((String)TeamUIMessages.ChangesSection_filterHides, (Object[])new String[]{Utils.modeToString(this.configuration.getMode()), message});
            Label warning = new Label(composite, 0);
            warning.setImage(TeamUIPlugin.getPlugin().getImage("ovr/warning_co.gif"));
            Hyperlink link = this.forms.createHyperlink(composite, NLS.bind((String)TeamUIMessages.ChangesSection_filterChange, (Object[])new String[]{Utils.modeToString(candidateMode)}), 64);
            link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    ChangesSection.this.configuration.setMode(candidateMode);
                }
            });
            this.forms.getHyperlinkGroup().add(link);
            this.createDescriptionLabel(composite, message);
            return composite;
        }
        this.createDescriptionLabel(composite, NLS.bind((String)TeamUIMessages.ChangesSection_noChanges, (Object[])new String[]{this.participant.getName()}));
        return composite;
    }

    private long getChangesInMode(SyncInfoSet participantSet, int candidateMode) {
        long numChanges;
        switch (candidateMode) {
            case 2: {
                numChanges = participantSet.countFor(4, 12);
                break;
            }
            case 1: {
                numChanges = participantSet.countFor(8, 12);
                break;
            }
            case 4: {
                numChanges = participantSet.countFor(8, 12) + participantSet.countFor(4, 12);
                break;
            }
            default: {
                numChanges = 0L;
            }
        }
        return numChanges;
    }

    private int getCandidateMode(SyncInfoSet participantSet) {
        long incomingChanges;
        SynchronizePageConfiguration configuration = (SynchronizePageConfiguration)this.page.getConfiguration();
        long outgoingChanges = participantSet.countFor(4, 12);
        if (outgoingChanges > 0L) {
            if (configuration.isModeSupported(2)) {
                return 2;
            }
            if (configuration.isModeSupported(4)) {
                return 4;
            }
        }
        if ((incomingChanges = participantSet.countFor(8, 12)) > 0L) {
            if (configuration.isModeSupported(1)) {
                return 1;
            }
            if (configuration.isModeSupported(4)) {
                return 4;
            }
        }
        return configuration.getMode();
    }

    private Label createDescriptionLabel(Composite parent, String text) {
        Label description = new Label(parent, 64);
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        data.widthHint = 100;
        description.setLayoutData((Object)data);
        description.setText(text);
        description.setBackground(this.getBackgroundColor());
        return description;
    }

    public void dispose() {
        super.dispose();
        this.forms.dispose();
        this.configuration.removeActionContribution(this.changedListener);
        this.getParticipantSyncInfoSet().removeSyncSetChangedListener(this.subscriberListener);
        this.getVisibleSyncInfoSet().removeSyncSetChangedListener(this.outputSetListener);
    }

    private Composite getErrorComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackground(this.getBackgroundColor());
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.grabExcessVerticalSpace = true;
        composite.setLayoutData((Object)data);
        Hyperlink link = new Hyperlink(composite, 64);
        link.setText(TeamUIMessages.ChangesSection_8);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ChangesSection.this.showErrors();
            }
        });
        link.setBackground(this.getBackgroundColor());
        link.setUnderlined(true);
        link = new Hyperlink(composite, 64);
        link.setText(TeamUIMessages.ChangesSection_9);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ChangesSection.this.page.reset();
            }
        });
        link.setBackground(this.getBackgroundColor());
        link.setUnderlined(true);
        this.createDescriptionLabel(composite, NLS.bind((String)TeamUIMessages.ChangesSection_10, (Object[])new String[]{this.participant.getName()}));
        return composite;
    }

    void showErrors() {
        ITeamStatus[] status = this.getVisibleSyncInfoSet().getErrors();
        String title = TeamUIMessages.ChangesSection_11;
        if (status.length == 1) {
            ErrorDialog.openError((Shell)this.getShell(), (String)title, (String)status[0].getMessage(), (IStatus)status[0]);
        } else {
            MultiStatus multi = new MultiStatus("org.eclipse.team.ui", 0, (IStatus[])status, TeamUIMessages.ChangesSection_12, null);
            ErrorDialog.openError((Shell)this.getShell(), (String)title, null, (IStatus)multi);
        }
    }

    protected Color getBackgroundColor() {
        return this.getShell().getDisplay().getSystemColor(25);
    }

    private SyncInfoTree getVisibleSyncInfoSet() {
        return (SyncInfoTree)this.configuration.getProperty("org.eclipse.team.ui.P_SYNC_INFO_SET");
    }

    private SyncInfoSet getParticipantSyncInfoSet() {
        return (SyncInfoSet)this.configuration.getProperty("org.eclipse.team.ui.P_WORKING_SET_SYNC_INFO_SET");
    }
}

