/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.refactoring;

import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaClassPrepareBreakpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.core.refactoring.JavaBreakpointTypeChange;
import org.eclipse.jdt.internal.debug.core.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.ltk.core.refactoring.Change;

public class JavaClassPrepareBreakpointTypeChange
extends JavaBreakpointTypeChange {
    private int fMemberType;

    public JavaClassPrepareBreakpointTypeChange(IJavaClassPrepareBreakpoint classPrepareBreakpoint, Object changedElement, Object argument, int changeType) throws CoreException {
        super((IJavaBreakpoint)classPrepareBreakpoint, changedElement, argument, changeType);
        this.fMemberType = classPrepareBreakpoint.getMemberType();
    }

    public String getErrorMessageNoMoreExists() {
        return MessageFormat.format(RefactoringMessages.JavaClassPrepareBreakpointTypeChange_0, this.getDeclaringType().getElementName());
    }

    public String getName() {
        return MessageFormat.format(RefactoringMessages.JavaClassPrepareBreakpointTypeChange_1, this.getDeclaringType().getElementName());
    }

    public Change performChange(IType newType, Object undoChangedElement, Object undoArgument, int changeType) throws CoreException {
        Map attributes = this.getAttributes();
        BreakpointUtils.addJavaBreakpointAttributes(attributes, (IJavaElement)newType);
        ISourceRange range = newType.getNameRange();
        int charStart = -1;
        int charEnd = -1;
        if (range != null) {
            charStart = range.getOffset();
            charEnd = charStart + range.getLength();
        }
        IJavaClassPrepareBreakpoint newClassPrepareBreakpoint = JDIDebugModel.createClassPrepareBreakpoint((IResource)BreakpointUtils.getBreakpointResource((IMember)newType), (String)newType.getFullyQualifiedName(), (int)this.fMemberType, (int)charStart, (int)charEnd, (boolean)true, (Map)attributes);
        this.getBreakpoint().delete();
        return new JavaClassPrepareBreakpointTypeChange(newClassPrepareBreakpoint, undoChangedElement, undoArgument, changeType);
    }
}

