/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.navigator.internal.provisional.views;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.wst.common.navigator.internal.provisional.views.NavigatorContentService;
import org.eclipse.wst.common.navigator.internal.views.NavigatorPlugin;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentDescriptor;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentDescriptorInstance;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorContentDescriptorRegistry;
import org.eclipse.wst.common.navigator.internal.views.extensions.NavigatorRegistry;

public class CommonSorter
extends ViewerSorter {
    private static final NavigatorContentDescriptorRegistry CONTENT_DESCRIPTOR_REGISTRY = NavigatorContentDescriptorRegistry.getInstance();
    private NavigatorRegistry navigatorRegistry = null;
    private Comparator comparator = null;
    private NavigatorContentService contentService;

    public CommonSorter(NavigatorContentService aContentService) {
        this.contentService = aContentService;
    }

    public int category(Object anElement) {
        List descriptors = CONTENT_DESCRIPTOR_REGISTRY.getEnabledContentDescriptors(anElement);
        if (descriptors.size() > 0) {
            return ((NavigatorContentDescriptor)descriptors.get(0)).getPriority();
        }
        return 4;
    }

    public int compare(Viewer viewer, Object lvalue, Object rvalue) {
        int rank = this.category(lvalue) - this.category(rvalue);
        if (rank == 0) {
            StructuredSelection selection = new StructuredSelection(new Object[]{lvalue, rvalue});
            NavigatorContentDescriptorInstance[] descriptorInstances = this.contentService.findRelevantContentDescriptorInstances((IStructuredSelection)selection);
            if (descriptorInstances.length > 0) {
                return descriptorInstances[0].getSorter().compare(lvalue, rvalue);
            }
            return rank;
        }
        return rank;
    }

    public void sort(Viewer viewer, Object[] elements) {
        Arrays.sort(elements, this.getComparator());
    }

    protected NavigatorRegistry getNavigatorRegistry() {
        if (this.navigatorRegistry == null) {
            this.navigatorRegistry = NavigatorPlugin.getDefault().getNavigatorRegistry();
        }
        return this.navigatorRegistry;
    }

    protected Comparator getComparator() {
        if (this.comparator == null) {
            this.comparator = new Comparator(){

                public int compare(Object o1, Object o2) {
                    return CommonSorter.this.compare(null, o1, o2);
                }
            };
        }
        return this.comparator;
    }
}

