/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;

public class XDocletRuntime {
    public static final String LIBPATH = "lib";
    private String version = "1.2.2";
    private String home = "";
    private String[] libs;

    public String getHome() {
        return this.home;
    }

    public void setHome(String home) {
        this.home = home;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String[] getLibs() {
        return this.libs;
    }

    public void setLibs(String[] libs) {
        this.libs = libs;
    }

    public IClasspathEntry[] resolveClasspathContainer() {
        ArrayList list = new ArrayList();
        XDocletRuntime.addLibraryEntries(list, new File(String.valueOf(this.home) + File.separator + LIBPATH), false);
        return XDocletRuntime.resolveList(list);
    }

    protected static void addJarFiles(File dir, List list, boolean includeSubdirectories) {
        int depth = 0;
        if (includeSubdirectories) {
            depth = 2;
        }
        XDocletRuntime.addJarFiles(dir, list, depth);
    }

    private static void addJarFiles(File dir, List list, int depth) {
        File[] files = dir.listFiles();
        if (files != null) {
            int size = files.length;
            int i = 0;
            while (i < size) {
                if (files[i].isDirectory() && depth > 0) {
                    XDocletRuntime.addJarFiles(files[i], list, depth - 1);
                } else if (files[i].getAbsolutePath().endsWith(".jar") || files[i].getAbsolutePath().endsWith(".zip")) {
                    Path path = new Path(files[i].getAbsolutePath());
                    list.add(JavaCore.newLibraryEntry((IPath)path, null, null));
                }
                ++i;
            }
        }
    }

    protected static void addLibraryEntries(List list, File dir, boolean includeSubdirectories) {
        XDocletRuntime.addJarFiles(dir, list, includeSubdirectories);
    }

    protected static IClasspathEntry[] resolveList(List list) {
        IClasspathEntry[] entries = new IClasspathEntry[list.size()];
        list.toArray(entries);
        return entries;
    }

    public URL getHomeURL() throws MalformedURLException {
        return new File(this.getHome()).toURL();
    }

    public IStatus[] validate() {
        ArrayList<Status> errors = new ArrayList<Status>();
        String[] vLibs = this.getLibs();
        if (vLibs == null) {
            errors.add(new Status(4, "org.eclipse.jst.j2ee.ejb.annotations.xdoclet", 0, "Could not find library for version: " + this.version, null));
        } else {
            int i = 0;
            while (i < vLibs.length) {
                String jar = vLibs[i];
                File libFile = new File(String.valueOf(this.getHome()) + File.separator + LIBPATH + File.separator + jar);
                File libFile2 = new File(String.valueOf(this.getHome()) + File.separator + jar);
                if (!libFile.exists() && !libFile2.exists()) {
                    errors.add(new Status(4, "org.eclipse.jst.j2ee.ejb.annotations.xdoclet", 0, "Could not find library: " + jar, null));
                }
                ++i;
            }
        }
        return errors.toArray(new IStatus[errors.size()]);
    }

    public boolean isValid() {
        return this.validate().length == 0;
    }
}

