/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.ui;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.XDocletPreferenceStore;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.ui.TagPropertiesWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class TaskProviderDecorator {
    private IExtension[] extensions;
    private XDocletPreferenceStore preferenceStore;
    Table table;
    Button edit;
    protected static String[] columnNames = new String[]{"include", "task"};

    public TaskProviderDecorator(IExtension[] extensions, XDocletPreferenceStore preferenceStore) {
        this.extensions = extensions;
        this.preferenceStore = preferenceStore;
    }

    public void decorate(Composite composite) {
        this.createTableViewer(this.createTable(composite));
        Dialog.applyDialogFont((Control)composite);
    }

    private Table createTable(final Composite parent) {
        int style = 101156;
        Group libraryPanel = new Group(parent, 0);
        libraryPanel.setText("Tasks");
        GridLayout layout = new GridLayout(3, false);
        libraryPanel.setLayout((Layout)layout);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        libraryPanel.setLayoutData((Object)gridData);
        this.table = new Table((Composite)libraryPanel, style);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 1;
        this.table.setLayoutData((Object)gridData);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        TableColumn column = new TableColumn(this.table, 0x1000000, 0);
        column.setText(columnNames[0]);
        column.setWidth(60);
        column = new TableColumn(this.table, 16384, 1);
        column.setText(columnNames[1]);
        column.setWidth(200);
        this.edit = new Button((Composite)libraryPanel, 8);
        this.edit.setText("Edit...");
        GridData data = new GridData(258);
        this.edit.setLayoutData((Object)data);
        this.edit.setEnabled(false);
        this.edit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IExtension extension = (IExtension)TaskProviderDecorator.this.table.getSelection()[0].getData();
                if (extension != null) {
                    TaskProviderDecorator.this.showWizard(extension, parent.getShell());
                }
            }
        });
        return this.table;
    }

    private TableViewer createTableViewer(Table table) {
        CheckboxTableViewer tableViewer = new CheckboxTableViewer(table);
        tableViewer.setUseHashlookup(true);
        tableViewer.setColumnProperties(columnNames);
        tableViewer.setLabelProvider((IBaseLabelProvider)new FieldLabelProvider());
        tableViewer.setContentProvider((IContentProvider)new FieldContentProvider());
        tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                IExtension extension = (IExtension)event.getElement();
                IConfigurationElement[] elements = extension.getConfigurationElements();
                if (elements == null) {
                    return;
                }
                String id = elements[0].getAttribute("id");
                String selection = String.valueOf(id) + ".defaultSelection";
                TaskProviderDecorator.this.preferenceStore.setProperty(selection, event.getChecked());
            }
        });
        tableViewer.setInput((Object)this.extensions);
        tableViewer.setCheckedElements(this.getCheckedTasks());
        tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object obj = TaskProviderDecorator.this.getSelection(event.getSelection());
                boolean enabled = false;
                if (obj != null && obj instanceof IExtension) {
                    enabled = ((IExtension)obj).getConfigurationElements().length > 1;
                }
                TaskProviderDecorator.this.edit.setEnabled(enabled);
            }
        });
        return tableViewer;
    }

    protected Object getSelection(ISelection sele) {
        IStructuredSelection sel = (IStructuredSelection)sele;
        return sel.getFirstElement();
    }

    private Object[] getCheckedTasks() {
        ArrayList<IExtension> checked = new ArrayList<IExtension>(this.extensions.length);
        int i = 0;
        while (i < this.extensions.length) {
            String id;
            String selection;
            IExtension extension = this.extensions[i];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            if (elements != null && this.preferenceStore.getBooleanPropertyNoGlobal(selection = String.valueOf(id = elements[0].getAttribute("id")) + ".defaultSelection")) {
                checked.add(extension);
            }
            ++i;
        }
        return checked.toArray();
    }

    protected int getColumnIndex(String columName) {
        if (columName == null) {
            return -1;
        }
        int i = 0;
        while (i < columnNames.length) {
            String col = columnNames[i];
            if (columName.equals(col)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected int showWizard(IExtension extension, Shell shell) {
        TagPropertiesWizard wizard = new TagPropertiesWizard(extension, this.preferenceStore);
        wizard.setForcePreviousAndNextButtons(true);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        return dialog.open();
    }

    public class FieldContentProvider
    implements IStructuredContentProvider {
        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object parent) {
            return (IExtension[])parent;
        }
    }

    public class FieldLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public String getColumnText(Viewer v, Object obj, int index) {
            return this.getColumnText(obj, index);
        }

        public Image getColumnImage(Viewer v, Object obj, int index) {
            return this.getColumnImage(obj, index);
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }

        public String getColumnText(Object obj, int index) {
            IExtension extension = (IExtension)obj;
            IConfigurationElement[] elements = extension.getConfigurationElements();
            if (elements == null) {
                return "";
            }
            switch (index) {
                case 0: {
                    return "";
                }
                case 1: {
                    return elements[0].getAttribute("name");
                }
            }
            return "";
        }
    }
}

