/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IProjectProperties;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeLifecycleListener;
import org.eclipse.wst.server.core.IRuntimeTargetHandler;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerLifecycleListener;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.internal.IStartup;
import org.eclipse.wst.server.core.internal.ModuleProperties;
import org.eclipse.wst.server.core.internal.ResourceManager;
import org.eclipse.wst.server.core.internal.RuntimeType;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.internal.ServerType;
import org.eclipse.wst.server.core.internal.Trace;

public class ServerCore {
    private static final String EXTENSION_SERVER_TYPE = "serverTypes";
    private static final String EXTENSION_RUNTIME_TYPE = "runtimeTypes";
    private static List runtimeTypes;
    private static List serverTypes;
    private static IRegistryChangeListener registryListener;

    static {
        ServerCore.executeStartups();
    }

    private ServerCore() {
    }

    private static final ResourceManager getResourceManager() {
        return ResourceManager.getInstance();
    }

    public static IProjectProperties getProjectProperties(IProject project) {
        if (project == null) {
            throw new IllegalArgumentException();
        }
        return new IProjectProperties(){

            public IRuntime getRuntimeTarget() {
                return null;
            }
        };
    }

    public static IRuntimeType[] getRuntimeTypes() {
        if (runtimeTypes == null) {
            ServerCore.loadRuntimeTypes();
        }
        IRuntimeType[] rt = new IRuntimeType[runtimeTypes.size()];
        runtimeTypes.toArray(rt);
        return rt;
    }

    public static IRuntimeType findRuntimeType(String id) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        if (runtimeTypes == null) {
            ServerCore.loadRuntimeTypes();
        }
        Iterator iterator = runtimeTypes.iterator();
        while (iterator.hasNext()) {
            IRuntimeType runtimeType = (IRuntimeType)iterator.next();
            if (!id.equals(runtimeType.getId())) continue;
            return runtimeType;
        }
        return null;
    }

    public static IRuntimeTargetHandler[] getRuntimeTargetHandlers() {
        throw new RuntimeException("Attempt to use deprecated code");
    }

    public static IRuntimeTargetHandler findRuntimeTargetHandler(String id) {
        throw new RuntimeException("Attempt to use deprecated code");
    }

    public static IServerType[] getServerTypes() {
        if (serverTypes == null) {
            ServerCore.loadServerTypes();
        }
        IServerType[] st = new IServerType[serverTypes.size()];
        serverTypes.toArray(st);
        return st;
    }

    public static IServerType findServerType(String id) {
        if (id == null) {
            throw new IllegalArgumentException();
        }
        if (serverTypes == null) {
            ServerCore.loadServerTypes();
        }
        Iterator iterator = serverTypes.iterator();
        while (iterator.hasNext()) {
            IServerType serverType = (IServerType)iterator.next();
            if (!id.equals(serverType.getId())) continue;
            return serverType;
        }
        return null;
    }

    private static synchronized void executeStartups() {
        Trace.trace(Trace.EXTENSION_POINT, "->- Loading .startup extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.wst.server.core", "internalStartup");
        int size = cf.length;
        int i = 0;
        while (i < size) {
            try {
                IStartup startup = (IStartup)cf[i].createExecutableExtension("class");
                try {
                    startup.startup();
                }
                catch (Exception ex) {
                    Trace.trace(Trace.SEVERE, "Startup failed" + startup.toString(), ex);
                }
                Trace.trace(Trace.EXTENSION_POINT, "  Loaded startup: " + cf[i].getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.trace(Trace.SEVERE, "  Could not load startup: " + cf[i].getAttribute("id"), t);
            }
            ++i;
        }
        Trace.trace(Trace.EXTENSION_POINT, "-<- Done loading .startup extension point -<-");
    }

    private static synchronized void loadRuntimeTypes() {
        if (runtimeTypes != null) {
            return;
        }
        Trace.trace(Trace.EXTENSION_POINT, "->- Loading .runtimeTypes extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.wst.server.core", EXTENSION_RUNTIME_TYPE);
        runtimeTypes = new ArrayList(cf.length);
        ServerCore.addRuntimeTypes(cf);
        ServerCore.addRegistryListener();
        Trace.trace(Trace.EXTENSION_POINT, "-<- Done loading .runtimeTypes extension point -<-");
    }

    private static synchronized void addRuntimeTypes(IConfigurationElement[] cf) {
        int i = 0;
        while (i < cf.length) {
            try {
                RuntimeType runtimeType = new RuntimeType(cf[i]);
                runtimeTypes.add(runtimeType);
                Trace.trace(Trace.EXTENSION_POINT, "  Loaded runtimeType: " + cf[i].getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.trace(Trace.SEVERE, "  Could not load runtimeType: " + cf[i].getAttribute("id"), t);
            }
            ++i;
        }
    }

    private static synchronized void loadServerTypes() {
        if (serverTypes != null) {
            return;
        }
        Trace.trace(Trace.EXTENSION_POINT, "->- Loading .serverTypes extension point ->-");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.wst.server.core", EXTENSION_SERVER_TYPE);
        serverTypes = new ArrayList(cf.length);
        ServerCore.addServerTypes(cf);
        ServerCore.addRegistryListener();
        Trace.trace(Trace.EXTENSION_POINT, "-<- Done loading .serverTypes extension point -<-");
    }

    private static synchronized void addServerTypes(IConfigurationElement[] cf) {
        int i = 0;
        while (i < cf.length) {
            try {
                ServerType serverType = new ServerType(cf[i]);
                serverTypes.add(serverType);
                Trace.trace(Trace.EXTENSION_POINT, "  Loaded serverType: " + cf[i].getAttribute("id"));
            }
            catch (Throwable t) {
                Trace.trace(Trace.SEVERE, "  Could not load serverType: " + cf[i].getAttribute("id"), t);
            }
            ++i;
        }
    }

    public static IRuntime findRuntime(String id) {
        return ServerCore.getResourceManager().getRuntime(id);
    }

    public static IRuntime[] getRuntimes() {
        return ServerCore.getResourceManager().getRuntimes();
    }

    public static IServer findServer(String id) {
        return ServerCore.getResourceManager().getServer(id);
    }

    public static IServer[] getServers() {
        return ServerCore.getResourceManager().getServers();
    }

    public static void addRuntimeLifecycleListener(IRuntimeLifecycleListener listener) {
        ServerCore.getResourceManager().addRuntimeLifecycleListener(listener);
    }

    public static void removeRuntimeLifecycleListener(IRuntimeLifecycleListener listener) {
        ServerCore.getResourceManager().removeRuntimeLifecycleListener(listener);
    }

    public static void addServerLifecycleListener(IServerLifecycleListener listener) {
        ServerCore.getResourceManager().addServerLifecycleListener(listener);
    }

    public static void removeServerLifecycleListener(IServerLifecycleListener listener) {
        ServerCore.getResourceManager().removeServerLifecycleListener(listener);
    }

    public static IServer getDefaultServer(IModule module) {
        return ModuleProperties.getInstance().getDefaultServer(module);
    }

    public static void setDefaultServer(IModule module, IServer server, IProgressMonitor monitor) throws CoreException {
        ModuleProperties.getInstance().setDefaultServer(module, server, monitor);
    }

    protected static void handleServerTypeDelta(IExtensionDelta delta) {
        if (serverTypes == null) {
            return;
        }
        IConfigurationElement[] cf = delta.getExtension().getConfigurationElements();
        if (delta.getKind() == 1) {
            ServerCore.addServerTypes(cf);
        } else {
            int size = serverTypes.size();
            ServerType[] st = new ServerType[size];
            serverTypes.toArray(st);
            int size2 = cf.length;
            int i = 0;
            while (i < size) {
                int j = 0;
                while (j < size2) {
                    if (st[i].getId().equals(cf[j].getAttribute("id"))) {
                        st[i].dispose();
                        serverTypes.remove(st[i]);
                    }
                    ++j;
                }
                ++i;
            }
        }
        ServerCore.getResourceManager().resolveServers();
    }

    protected static void handleRuntimeTypeDelta(IExtensionDelta delta) {
        if (runtimeTypes == null) {
            return;
        }
        IConfigurationElement[] cf = delta.getExtension().getConfigurationElements();
        if (delta.getKind() == 1) {
            ServerCore.addRuntimeTypes(cf);
        } else {
            int size = runtimeTypes.size();
            RuntimeType[] rt = new RuntimeType[size];
            runtimeTypes.toArray(rt);
            int size2 = cf.length;
            int i = 0;
            while (i < size) {
                int j = 0;
                while (j < size2) {
                    if (rt[i].getId().equals(cf[j].getAttribute("id"))) {
                        rt[i].dispose();
                        runtimeTypes.remove(rt[i]);
                    }
                    ++j;
                }
                ++i;
            }
        }
        ServerCore.getResourceManager().resolveRuntimes();
        ServerCore.getResourceManager().resolveServers();
    }

    private static void addRegistryListener() {
        if (registryListener != null) {
            return;
        }
        registryListener = new RegistryChangeListener();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        registry.addRegistryChangeListener(registryListener, "org.eclipse.wst.server.core");
        ServerPlugin.setRegistryListener(registryListener);
    }

    private static class RegistryChangeListener
    implements IRegistryChangeListener {
        private RegistryChangeListener() {
        }

        public void registryChanged(IRegistryChangeEvent event) {
            int i;
            IExtensionDelta[] deltas = event.getExtensionDeltas("org.eclipse.wst.server.core", ServerCore.EXTENSION_RUNTIME_TYPE);
            if (deltas != null) {
                i = 0;
                while (i < deltas.length) {
                    ServerCore.handleRuntimeTypeDelta(deltas[i]);
                    ++i;
                }
            }
            if ((deltas = event.getExtensionDeltas("org.eclipse.wst.server.core", ServerCore.EXTENSION_SERVER_TYPE)) != null) {
                i = 0;
                while (i < deltas.length) {
                    ServerCore.handleServerTypeDelta(deltas[i]);
                    ++i;
                }
            }
        }
    }
}

